/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v133.indexeddb;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v133.indexeddb.model.DataEntry;
import org.openqa.selenium.devtools.v133.indexeddb.model.DatabaseWithObjectStores;
import org.openqa.selenium.devtools.v133.indexeddb.model.KeyRange;
import org.openqa.selenium.devtools.v133.storage.model.StorageBucket;
import org.openqa.selenium.json.JsonInput;

@Beta
public class IndexedDB {
    public static Command<Void> clearObjectStore(Optional<String> securityOrigin, Optional<String> storageKey, Optional<StorageBucket> storageBucket, String databaseName, String objectStoreName) {
        Objects.requireNonNull(databaseName, "databaseName is required");
        Objects.requireNonNull(objectStoreName, "objectStoreName is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        securityOrigin.ifPresent(p -> params.put("securityOrigin", (String)p));
        storageKey.ifPresent(p -> params.put("storageKey", (String)p));
        storageBucket.ifPresent(p -> params.put("storageBucket", (String)p));
        params.put("databaseName", databaseName);
        params.put("objectStoreName", objectStoreName);
        return new Command<Void>("IndexedDB.clearObjectStore", Map.copyOf(params));
    }

    public static Command<Void> deleteDatabase(Optional<String> securityOrigin, Optional<String> storageKey, Optional<StorageBucket> storageBucket, String databaseName) {
        Objects.requireNonNull(databaseName, "databaseName is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        securityOrigin.ifPresent(p -> params.put("securityOrigin", (String)p));
        storageKey.ifPresent(p -> params.put("storageKey", (String)p));
        storageBucket.ifPresent(p -> params.put("storageBucket", (String)p));
        params.put("databaseName", databaseName);
        return new Command<Void>("IndexedDB.deleteDatabase", Map.copyOf(params));
    }

    public static Command<Void> deleteObjectStoreEntries(Optional<String> securityOrigin, Optional<String> storageKey, Optional<StorageBucket> storageBucket, String databaseName, String objectStoreName, KeyRange keyRange) {
        Objects.requireNonNull(databaseName, "databaseName is required");
        Objects.requireNonNull(objectStoreName, "objectStoreName is required");
        Objects.requireNonNull(keyRange, "keyRange is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        securityOrigin.ifPresent(p -> params.put("securityOrigin", p));
        storageKey.ifPresent(p -> params.put("storageKey", p));
        storageBucket.ifPresent(p -> params.put("storageBucket", p));
        params.put("databaseName", databaseName);
        params.put("objectStoreName", objectStoreName);
        params.put("keyRange", keyRange);
        return new Command<Void>("IndexedDB.deleteObjectStoreEntries", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("IndexedDB.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("IndexedDB.enable", Map.copyOf(params));
    }

    public static Command<RequestDataResponse> requestData(Optional<String> securityOrigin, Optional<String> storageKey, Optional<StorageBucket> storageBucket, String databaseName, String objectStoreName, String indexName, Integer skipCount, Integer pageSize, Optional<KeyRange> keyRange) {
        Objects.requireNonNull(databaseName, "databaseName is required");
        Objects.requireNonNull(objectStoreName, "objectStoreName is required");
        Objects.requireNonNull(indexName, "indexName is required");
        Objects.requireNonNull(skipCount, "skipCount is required");
        Objects.requireNonNull(pageSize, "pageSize is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        securityOrigin.ifPresent(p -> params.put("securityOrigin", p));
        storageKey.ifPresent(p -> params.put("storageKey", p));
        storageBucket.ifPresent(p -> params.put("storageBucket", p));
        params.put("databaseName", databaseName);
        params.put("objectStoreName", objectStoreName);
        params.put("indexName", indexName);
        params.put("skipCount", skipCount);
        params.put("pageSize", pageSize);
        keyRange.ifPresent(p -> params.put("keyRange", p));
        return new Command<RequestDataResponse>("IndexedDB.requestData", Map.copyOf(params), input -> (RequestDataResponse)input.read((Type)((Object)RequestDataResponse.class)));
    }

    public static Command<GetMetadataResponse> getMetadata(Optional<String> securityOrigin, Optional<String> storageKey, Optional<StorageBucket> storageBucket, String databaseName, String objectStoreName) {
        Objects.requireNonNull(databaseName, "databaseName is required");
        Objects.requireNonNull(objectStoreName, "objectStoreName is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        securityOrigin.ifPresent(p -> params.put("securityOrigin", (String)p));
        storageKey.ifPresent(p -> params.put("storageKey", (String)p));
        storageBucket.ifPresent(p -> params.put("storageBucket", (String)p));
        params.put("databaseName", databaseName);
        params.put("objectStoreName", objectStoreName);
        return new Command<GetMetadataResponse>("IndexedDB.getMetadata", Map.copyOf(params), input -> (GetMetadataResponse)input.read((Type)((Object)GetMetadataResponse.class)));
    }

    public static Command<DatabaseWithObjectStores> requestDatabase(Optional<String> securityOrigin, Optional<String> storageKey, Optional<StorageBucket> storageBucket, String databaseName) {
        Objects.requireNonNull(databaseName, "databaseName is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        securityOrigin.ifPresent(p -> params.put("securityOrigin", (String)p));
        storageKey.ifPresent(p -> params.put("storageKey", (String)p));
        storageBucket.ifPresent(p -> params.put("storageBucket", (String)p));
        params.put("databaseName", databaseName);
        return new Command<DatabaseWithObjectStores>("IndexedDB.requestDatabase", Map.copyOf(params), ConverterFunctions.map("databaseWithObjectStores", DatabaseWithObjectStores.class));
    }

    public static Command<List<String>> requestDatabaseNames(Optional<String> securityOrigin, Optional<String> storageKey, Optional<StorageBucket> storageBucket) {
        LinkedHashMap params = new LinkedHashMap();
        securityOrigin.ifPresent(p -> params.put("securityOrigin", p));
        storageKey.ifPresent(p -> params.put("storageKey", p));
        storageBucket.ifPresent(p -> params.put("storageBucket", p));
        return new Command<List<String>>("IndexedDB.requestDatabaseNames", Map.copyOf(params), ConverterFunctions.map("databaseNames", input -> input.readArray((Type)((Object)String.class))));
    }

    public static class GetMetadataResponse {
        private final Number entriesCount;
        private final Number keyGeneratorValue;

        public GetMetadataResponse(Number entriesCount, Number keyGeneratorValue) {
            this.entriesCount = Objects.requireNonNull(entriesCount, "entriesCount is required");
            this.keyGeneratorValue = Objects.requireNonNull(keyGeneratorValue, "keyGeneratorValue is required");
        }

        public Number getEntriesCount() {
            return this.entriesCount;
        }

        public Number getKeyGeneratorValue() {
            return this.keyGeneratorValue;
        }

        private static GetMetadataResponse fromJson(JsonInput input) {
            Number entriesCount = 0;
            Number keyGeneratorValue = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "entriesCount": {
                        entriesCount = input.nextNumber();
                        continue block8;
                    }
                    case "keyGeneratorValue": {
                        keyGeneratorValue = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetMetadataResponse(entriesCount, keyGeneratorValue);
        }
    }

    public static class RequestDataResponse {
        private final List<DataEntry> objectStoreDataEntries;
        private final Boolean hasMore;

        public RequestDataResponse(List<DataEntry> objectStoreDataEntries, Boolean hasMore) {
            this.objectStoreDataEntries = Objects.requireNonNull(objectStoreDataEntries, "objectStoreDataEntries is required");
            this.hasMore = Objects.requireNonNull(hasMore, "hasMore is required");
        }

        public List<DataEntry> getObjectStoreDataEntries() {
            return this.objectStoreDataEntries;
        }

        public Boolean getHasMore() {
            return this.hasMore;
        }

        private static RequestDataResponse fromJson(JsonInput input) {
            List objectStoreDataEntries = null;
            Boolean hasMore = false;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "objectStoreDataEntries": {
                        objectStoreDataEntries = input.readArray((Type)((Object)DataEntry.class));
                        continue block8;
                    }
                    case "hasMore": {
                        hasMore = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new RequestDataResponse(objectStoreDataEntries, hasMore);
        }
    }
}

