/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.applicationcache;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v85.applicationcache.model.ApplicationCacheStatusUpdated;
import org.openqa.selenium.devtools.v85.applicationcache.model.FrameWithManifest;
import org.openqa.selenium.devtools.v85.page.model.FrameId;

@Beta
public class ApplicationCache {
    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("ApplicationCache.enable", Map.copyOf(params));
    }

    public static Command<org.openqa.selenium.devtools.v85.applicationcache.model.ApplicationCache> getApplicationCacheForFrame(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, FrameId> params = new LinkedHashMap<String, FrameId>();
        params.put("frameId", frameId);
        return new Command<org.openqa.selenium.devtools.v85.applicationcache.model.ApplicationCache>("ApplicationCache.getApplicationCacheForFrame", Map.copyOf(params), ConverterFunctions.map("applicationCache", org.openqa.selenium.devtools.v85.applicationcache.model.ApplicationCache.class));
    }

    public static Command<List<FrameWithManifest>> getFramesWithManifests() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<List<FrameWithManifest>>("ApplicationCache.getFramesWithManifests", Map.copyOf(params), ConverterFunctions.map("frameIds", input -> input.readArray((Type)((Object)FrameWithManifest.class))));
    }

    public static Command<String> getManifestForFrame(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, FrameId> params = new LinkedHashMap<String, FrameId>();
        params.put("frameId", frameId);
        return new Command<String>("ApplicationCache.getManifestForFrame", Map.copyOf(params), ConverterFunctions.map("manifestURL", String.class));
    }

    public static Event<ApplicationCacheStatusUpdated> applicationCacheStatusUpdated() {
        return new Event<ApplicationCacheStatusUpdated>("ApplicationCache.applicationCacheStatusUpdated", input -> (ApplicationCacheStatusUpdated)input.read((Type)((Object)ApplicationCacheStatusUpdated.class)));
    }

    public static Event<Boolean> networkStateUpdated() {
        return new Event<Boolean>("ApplicationCache.networkStateUpdated", ConverterFunctions.map("isNowOnline", Boolean.class));
    }
}

