/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing.opentelemetry;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryTracer;

public class SeleniumSpanExporter {
    private static final Logger LOG = Logger.getLogger(SeleniumSpanExporter.class.getName());
    private static final Set<String> EXCEPTION_ATTRIBUTES = Set.of("exception.message", "exception.stacktrace");
    private static final boolean httpLogs = OpenTelemetryTracer.getHttpLogs();
    private static final io.opentelemetry.api.common.AttributeKey<String> KEY_SPAN_KIND = io.opentelemetry.api.common.AttributeKey.stringKey(AttributeKey.SPAN_KIND.getKey());

    private static String getJsonString(Map<String, Object> map) {
        StringBuilder text = new StringBuilder();
        try (JsonOutput json = new Json().newOutput(text).setPrettyPrint(false);){
            json.write(map);
            text.append('\n');
        }
        return text.toString();
    }

    public static SpanProcessor getSpanProcessor() {
        return SimpleSpanProcessor.create(new SpanExporter(){

            @Override
            public CompletableResultCode export(Collection<SpanData> spans) {
                spans.forEach(span -> {
                    Level logLevel;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(String.valueOf(span));
                    }
                    if (!LOG.isLoggable(logLevel = SeleniumSpanExporter.getLogLevel(span))) {
                        return;
                    }
                    String traceId = span.getTraceId();
                    List<EventData> eventList = span.getEvents();
                    eventList.forEach(event -> {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("eventTime", event.getEpochNanos());
                        map.put("traceId", traceId);
                        map.put("eventName", event.getName());
                        Attributes attributes = event.getAttributes();
                        map.put("attributes", attributes.asMap());
                        EXCEPTION_ATTRIBUTES.forEach(exceptionAttribute -> attributes.asMap().keySet().stream().filter(key -> exceptionAttribute.equalsIgnoreCase(key.getKey())).findFirst().ifPresent(key -> LOG.log(logLevel, attributes.asMap().get(key).toString())));
                        String jsonString = SeleniumSpanExporter.getJsonString(map);
                        LOG.log(logLevel, jsonString);
                    });
                });
                return CompletableResultCode.ofSuccess();
            }

            @Override
            public CompletableResultCode flush() {
                return CompletableResultCode.ofSuccess();
            }

            @Override
            public CompletableResultCode shutdown() {
                return CompletableResultCode.ofSuccess();
            }
        });
    }

    private static Level getLogLevel(SpanData span) {
        Optional<String> kind;
        Level level = Level.FINE;
        if (span.getStatus().getStatusCode() == StatusCode.ERROR) {
            level = Level.WARNING;
        } else if (httpLogs && (kind = Optional.ofNullable(span.getAttributes().get(KEY_SPAN_KIND))).isPresent()) {
            String kindValue = kind.get();
            if (Span.Kind.SERVER.name().equalsIgnoreCase(kindValue) || Span.Kind.CLIENT.name().equalsIgnoreCase(kindValue)) {
                level = Level.INFO;
            }
        }
        return level;
    }
}

