/*
 * Decompiled with CFR 0.152.
 */
package zmq.io;

import java.nio.channels.SelectableChannel;
import zmq.io.IOThread;
import zmq.poll.IPollEvents;
import zmq.poll.Poller;

public class IOObject
implements IPollEvents {
    private final Poller poller;
    private final IPollEvents handler;
    private boolean alive;

    public IOObject(IOThread ioThread, IPollEvents handler) {
        assert (ioThread != null);
        assert (handler != null);
        this.handler = handler;
        this.poller = ioThread.getPoller();
    }

    public final void plug() {
        this.alive = true;
    }

    public final void unplug() {
        this.alive = false;
    }

    public final Poller.Handle addFd(SelectableChannel fd) {
        return this.poller.addHandle(fd, this);
    }

    public final void removeHandle(Poller.Handle handle) {
        this.poller.removeHandle(handle);
    }

    public final void setPollIn(Poller.Handle handle) {
        this.poller.setPollIn(handle);
    }

    public final void setPollOut(Poller.Handle handle) {
        this.poller.setPollOut(handle);
    }

    public final void setPollConnect(Poller.Handle handle) {
        this.poller.setPollConnect(handle);
    }

    public final void setPollAccept(Poller.Handle handle) {
        this.poller.setPollAccept(handle);
    }

    public final void resetPollIn(Poller.Handle handle) {
        this.poller.resetPollIn(handle);
    }

    public final void resetPollOut(Poller.Handle handle) {
        this.poller.resetPollOut(handle);
    }

    @Override
    public final void inEvent() {
        assert (this.alive);
        this.handler.inEvent();
    }

    @Override
    public final void outEvent() {
        assert (this.alive);
        this.handler.outEvent();
    }

    @Override
    public final void connectEvent() {
        assert (this.alive);
        this.handler.connectEvent();
    }

    @Override
    public final void acceptEvent() {
        assert (this.alive);
        this.handler.acceptEvent();
    }

    @Override
    public final void timerEvent(int id) {
        assert (this.alive);
        this.handler.timerEvent(id);
    }

    public final void addTimer(long timeout, int id) {
        assert (this.alive);
        this.poller.addTimer(timeout, this, id);
    }

    public final void cancelTimer(int id) {
        assert (this.alive);
        this.poller.cancelTimer(this, id);
    }

    public String toString() {
        return String.valueOf(this.handler);
    }
}

