package org.openqa.selenium.devtools.v133.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum ContentSecurityPolicySource {

    HTTP("HTTP"), META("Meta");

    private String value;

    ContentSecurityPolicySource(String value) {
        this.value = value;
    }

    public static ContentSecurityPolicySource fromString(String s) {
        return java.util.Arrays.stream(ContentSecurityPolicySource.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within ContentSecurityPolicySource "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static ContentSecurityPolicySource fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
