package org.openqa.selenium.devtools.v134.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Inherited CSS style collection for animated styles from ancestor node.
 */
public class InheritedAnimatedStyleEntry {

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v134.css.model.CSSAnimationStyle>> animationStyles;

    private final java.util.Optional<org.openqa.selenium.devtools.v134.css.model.CSSStyle> transitionsStyle;

    public InheritedAnimatedStyleEntry(java.util.Optional<java.util.List<org.openqa.selenium.devtools.v134.css.model.CSSAnimationStyle>> animationStyles, java.util.Optional<org.openqa.selenium.devtools.v134.css.model.CSSStyle> transitionsStyle) {
        this.animationStyles = animationStyles;
        this.transitionsStyle = transitionsStyle;
    }

    /**
     * Styles coming from the animations of the ancestor, if any, in the style inheritance chain.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v134.css.model.CSSAnimationStyle>> getAnimationStyles() {
        return animationStyles;
    }

    /**
     * The style coming from the transitions of the ancestor, if any, in the style inheritance chain.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v134.css.model.CSSStyle> getTransitionsStyle() {
        return transitionsStyle;
    }

    private static InheritedAnimatedStyleEntry fromJson(JsonInput input) {
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v134.css.model.CSSAnimationStyle>> animationStyles = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v134.css.model.CSSStyle> transitionsStyle = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "animationStyles":
                    animationStyles = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v134.css.model.CSSAnimationStyle.class));
                    break;
                case "transitionsStyle":
                    transitionsStyle = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v134.css.model.CSSStyle.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new InheritedAnimatedStyleEntry(animationStyles, transitionsStyle);
    }
}
