package org.openqa.selenium.devtools.v134.tracing;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

public class Tracing {

    /**
     * Stop trace events collection.
     */
    public static Command<Void> end() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Tracing.end", Map.copyOf(params));
    }

    /**
     * Gets supported tracing categories.
     */
    @Beta()
    public static Command<java.util.List<java.lang.String>> getCategories() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Tracing.getCategories", Map.copyOf(params), ConverterFunctions.map("categories", input -> input.readArray(java.lang.String.class)));
    }

    /**
     * Record a clock sync marker in the trace.
     */
    @Beta()
    public static Command<Void> recordClockSyncMarker(java.lang.String syncId) {
        java.util.Objects.requireNonNull(syncId, "syncId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("syncId", syncId);
        return new Command<>("Tracing.recordClockSyncMarker", Map.copyOf(params));
    }

    public static class RequestMemoryDumpResponse {

        private final java.lang.String dumpGuid;

        private final java.lang.Boolean success;

        public RequestMemoryDumpResponse(java.lang.String dumpGuid, java.lang.Boolean success) {
            this.dumpGuid = java.util.Objects.requireNonNull(dumpGuid, "dumpGuid is required");
            this.success = java.util.Objects.requireNonNull(success, "success is required");
        }

        /**
         * GUID of the resulting global memory dump.
         */
        public java.lang.String getDumpGuid() {
            return dumpGuid;
        }

        /**
         * True iff the global memory dump succeeded.
         */
        public java.lang.Boolean getSuccess() {
            return success;
        }

        private static RequestMemoryDumpResponse fromJson(JsonInput input) {
            java.lang.String dumpGuid = null;
            java.lang.Boolean success = false;
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "dumpGuid":
                        dumpGuid = input.nextString();
                        break;
                    case "success":
                        success = input.nextBoolean();
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new RequestMemoryDumpResponse(dumpGuid, success);
        }
    }

    /**
     * Request a global memory dump.
     */
    @Beta()
    public static Command<org.openqa.selenium.devtools.v134.tracing.Tracing.RequestMemoryDumpResponse> requestMemoryDump(java.util.Optional<java.lang.Boolean> deterministic, java.util.Optional<org.openqa.selenium.devtools.v134.tracing.model.MemoryDumpLevelOfDetail> levelOfDetail) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        deterministic.ifPresent(p -> params.put("deterministic", p));
        levelOfDetail.ifPresent(p -> params.put("levelOfDetail", p));
        return new Command<>("Tracing.requestMemoryDump", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v134.tracing.Tracing.RequestMemoryDumpResponse.class));
    }

    public enum StartTransferMode {

        REPORTEVENTS("ReportEvents"), RETURNASSTREAM("ReturnAsStream");

        private String value;

        StartTransferMode(String value) {
            this.value = value;
        }

        public static StartTransferMode fromString(String s) {
            return java.util.Arrays.stream(StartTransferMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within StartTransferMode "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static StartTransferMode fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    /**
     * Start trace events collection.
     */
    public static Command<Void> start(java.util.Optional<java.lang.String> categories, java.util.Optional<java.lang.String> options, java.util.Optional<java.lang.Number> bufferUsageReportingInterval, java.util.Optional<StartTransferMode> transferMode, java.util.Optional<org.openqa.selenium.devtools.v134.tracing.model.StreamFormat> streamFormat, java.util.Optional<org.openqa.selenium.devtools.v134.tracing.model.StreamCompression> streamCompression, java.util.Optional<org.openqa.selenium.devtools.v134.tracing.model.TraceConfig> traceConfig, java.util.Optional<java.lang.String> perfettoConfig, java.util.Optional<org.openqa.selenium.devtools.v134.tracing.model.TracingBackend> tracingBackend) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        categories.ifPresent(p -> params.put("categories", p));
        options.ifPresent(p -> params.put("options", p));
        bufferUsageReportingInterval.ifPresent(p -> params.put("bufferUsageReportingInterval", p));
        transferMode.ifPresent(p -> params.put("transferMode", p));
        streamFormat.ifPresent(p -> params.put("streamFormat", p));
        streamCompression.ifPresent(p -> params.put("streamCompression", p));
        traceConfig.ifPresent(p -> params.put("traceConfig", p));
        perfettoConfig.ifPresent(p -> params.put("perfettoConfig", p));
        tracingBackend.ifPresent(p -> params.put("tracingBackend", p));
        return new Command<>("Tracing.start", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v134.tracing.model.BufferUsage> bufferUsage() {
        return new Event<>("Tracing.bufferUsage", input -> input.read(org.openqa.selenium.devtools.v134.tracing.model.BufferUsage.class));
    }

    public static Event<java.util.List<java.util.Map<String, Object>>> dataCollected() {
        return new Event<>("Tracing.dataCollected", ConverterFunctions.map("value", input -> input.readArray(java.util.Map.class)));
    }

    public static Event<org.openqa.selenium.devtools.v134.tracing.model.TracingComplete> tracingComplete() {
        return new Event<>("Tracing.tracingComplete", input -> input.read(org.openqa.selenium.devtools.v134.tracing.model.TracingComplete.class));
    }
}
