/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v133.network.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum ContentSecurityPolicySource {
    HTTP("HTTP"),
    META("Meta");

    private String value;

    private ContentSecurityPolicySource(String value) {
        this.value = value;
    }

    public static ContentSecurityPolicySource fromString(String s) {
        return Arrays.stream(ContentSecurityPolicySource.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within ContentSecurityPolicySource "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ContentSecurityPolicySource fromJson(JsonInput input) {
        return ContentSecurityPolicySource.fromString(input.nextString());
    }
}

