/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v133.security.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v133.network.model.TimeSinceEpoch;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CertificateSecurityState {
    private final String protocol;
    private final String keyExchange;
    private final Optional<String> keyExchangeGroup;
    private final String cipher;
    private final Optional<String> mac;
    private final List<String> certificate;
    private final String subjectName;
    private final String issuer;
    private final TimeSinceEpoch validFrom;
    private final TimeSinceEpoch validTo;
    private final Optional<String> certificateNetworkError;
    private final Boolean certificateHasWeakSignature;
    private final Boolean certificateHasSha1Signature;
    private final Boolean modernSSL;
    private final Boolean obsoleteSslProtocol;
    private final Boolean obsoleteSslKeyExchange;
    private final Boolean obsoleteSslCipher;
    private final Boolean obsoleteSslSignature;

    public CertificateSecurityState(String protocol, String keyExchange, Optional<String> keyExchangeGroup, String cipher, Optional<String> mac, List<String> certificate, String subjectName, String issuer, TimeSinceEpoch validFrom, TimeSinceEpoch validTo, Optional<String> certificateNetworkError, Boolean certificateHasWeakSignature, Boolean certificateHasSha1Signature, Boolean modernSSL, Boolean obsoleteSslProtocol, Boolean obsoleteSslKeyExchange, Boolean obsoleteSslCipher, Boolean obsoleteSslSignature) {
        this.protocol = Objects.requireNonNull(protocol, "protocol is required");
        this.keyExchange = Objects.requireNonNull(keyExchange, "keyExchange is required");
        this.keyExchangeGroup = keyExchangeGroup;
        this.cipher = Objects.requireNonNull(cipher, "cipher is required");
        this.mac = mac;
        this.certificate = Objects.requireNonNull(certificate, "certificate is required");
        this.subjectName = Objects.requireNonNull(subjectName, "subjectName is required");
        this.issuer = Objects.requireNonNull(issuer, "issuer is required");
        this.validFrom = Objects.requireNonNull(validFrom, "validFrom is required");
        this.validTo = Objects.requireNonNull(validTo, "validTo is required");
        this.certificateNetworkError = certificateNetworkError;
        this.certificateHasWeakSignature = Objects.requireNonNull(certificateHasWeakSignature, "certificateHasWeakSignature is required");
        this.certificateHasSha1Signature = Objects.requireNonNull(certificateHasSha1Signature, "certificateHasSha1Signature is required");
        this.modernSSL = Objects.requireNonNull(modernSSL, "modernSSL is required");
        this.obsoleteSslProtocol = Objects.requireNonNull(obsoleteSslProtocol, "obsoleteSslProtocol is required");
        this.obsoleteSslKeyExchange = Objects.requireNonNull(obsoleteSslKeyExchange, "obsoleteSslKeyExchange is required");
        this.obsoleteSslCipher = Objects.requireNonNull(obsoleteSslCipher, "obsoleteSslCipher is required");
        this.obsoleteSslSignature = Objects.requireNonNull(obsoleteSslSignature, "obsoleteSslSignature is required");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getKeyExchange() {
        return this.keyExchange;
    }

    public Optional<String> getKeyExchangeGroup() {
        return this.keyExchangeGroup;
    }

    public String getCipher() {
        return this.cipher;
    }

    public Optional<String> getMac() {
        return this.mac;
    }

    public List<String> getCertificate() {
        return this.certificate;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public TimeSinceEpoch getValidFrom() {
        return this.validFrom;
    }

    public TimeSinceEpoch getValidTo() {
        return this.validTo;
    }

    public Optional<String> getCertificateNetworkError() {
        return this.certificateNetworkError;
    }

    public Boolean getCertificateHasWeakSignature() {
        return this.certificateHasWeakSignature;
    }

    public Boolean getCertificateHasSha1Signature() {
        return this.certificateHasSha1Signature;
    }

    public Boolean getModernSSL() {
        return this.modernSSL;
    }

    public Boolean getObsoleteSslProtocol() {
        return this.obsoleteSslProtocol;
    }

    public Boolean getObsoleteSslKeyExchange() {
        return this.obsoleteSslKeyExchange;
    }

    public Boolean getObsoleteSslCipher() {
        return this.obsoleteSslCipher;
    }

    public Boolean getObsoleteSslSignature() {
        return this.obsoleteSslSignature;
    }

    private static CertificateSecurityState fromJson(JsonInput input) {
        String protocol = null;
        String keyExchange = null;
        Optional<String> keyExchangeGroup = Optional.empty();
        String cipher = null;
        Optional<String> mac = Optional.empty();
        List certificate = null;
        String subjectName = null;
        String issuer = null;
        TimeSinceEpoch validFrom = null;
        TimeSinceEpoch validTo = null;
        Optional<String> certificateNetworkError = Optional.empty();
        Boolean certificateHasWeakSignature = false;
        Boolean certificateHasSha1Signature = false;
        Boolean modernSSL = false;
        Boolean obsoleteSslProtocol = false;
        Boolean obsoleteSslKeyExchange = false;
        Boolean obsoleteSslCipher = false;
        Boolean obsoleteSslSignature = false;
        input.beginObject();
        block40: while (input.hasNext()) {
            switch (input.nextName()) {
                case "protocol": {
                    protocol = input.nextString();
                    continue block40;
                }
                case "keyExchange": {
                    keyExchange = input.nextString();
                    continue block40;
                }
                case "keyExchangeGroup": {
                    keyExchangeGroup = Optional.ofNullable(input.nextString());
                    continue block40;
                }
                case "cipher": {
                    cipher = input.nextString();
                    continue block40;
                }
                case "mac": {
                    mac = Optional.ofNullable(input.nextString());
                    continue block40;
                }
                case "certificate": {
                    certificate = input.readArray(String.class);
                    continue block40;
                }
                case "subjectName": {
                    subjectName = input.nextString();
                    continue block40;
                }
                case "issuer": {
                    issuer = input.nextString();
                    continue block40;
                }
                case "validFrom": {
                    validFrom = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block40;
                }
                case "validTo": {
                    validTo = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block40;
                }
                case "certificateNetworkError": {
                    certificateNetworkError = Optional.ofNullable(input.nextString());
                    continue block40;
                }
                case "certificateHasWeakSignature": {
                    certificateHasWeakSignature = input.nextBoolean();
                    continue block40;
                }
                case "certificateHasSha1Signature": {
                    certificateHasSha1Signature = input.nextBoolean();
                    continue block40;
                }
                case "modernSSL": {
                    modernSSL = input.nextBoolean();
                    continue block40;
                }
                case "obsoleteSslProtocol": {
                    obsoleteSslProtocol = input.nextBoolean();
                    continue block40;
                }
                case "obsoleteSslKeyExchange": {
                    obsoleteSslKeyExchange = input.nextBoolean();
                    continue block40;
                }
                case "obsoleteSslCipher": {
                    obsoleteSslCipher = input.nextBoolean();
                    continue block40;
                }
                case "obsoleteSslSignature": {
                    obsoleteSslSignature = input.nextBoolean();
                    continue block40;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CertificateSecurityState(protocol, keyExchange, keyExchangeGroup, cipher, mac, certificate, subjectName, issuer, validFrom, validTo, certificateNetworkError, certificateHasWeakSignature, certificateHasSha1Signature, modernSSL, obsoleteSslProtocol, obsoleteSslKeyExchange, obsoleteSslCipher, obsoleteSslSignature);
    }
}

