/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v135.page.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v135.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class NavigatedWithinDocument {
    private final FrameId frameId;
    private final String url;
    private final NavigationType navigationType;

    public NavigatedWithinDocument(FrameId frameId, String url, NavigationType navigationType) {
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.url = Objects.requireNonNull(url, "url is required");
        this.navigationType = Objects.requireNonNull(navigationType, "navigationType is required");
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public String getUrl() {
        return this.url;
    }

    public NavigationType getNavigationType() {
        return this.navigationType;
    }

    private static NavigatedWithinDocument fromJson(JsonInput input) {
        FrameId frameId = null;
        String url = null;
        NavigationType navigationType = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block10;
                }
                case "url": {
                    url = input.nextString();
                    continue block10;
                }
                case "navigationType": {
                    navigationType = NavigationType.fromString(input.nextString());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new NavigatedWithinDocument(frameId, url, navigationType);
    }

    public static enum NavigationType {
        FRAGMENT("fragment"),
        HISTORYAPI("historyApi"),
        OTHER("other");

        private String value;

        private NavigationType(String value) {
            this.value = value;
        }

        public static NavigationType fromString(String s) {
            return Arrays.stream(NavigationType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within NavigationType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static NavigationType fromJson(JsonInput input) {
            return NavigationType.fromString(input.nextString());
        }
    }
}

