/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.io.Charsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharsetsTest {
    public static final String AVAIL_CHARSETS = "org.apache.commons.io.CharsetsTest#availableCharsetsKeySet";
    public static final String REQUIRED_CHARSETS = "org.apache.commons.io.CharsetsTest#getRequiredCharsetNames";

    public static Set<String> availableCharsetsKeySet() {
        return Charset.availableCharsets().keySet();
    }

    public static Set<String> getRequiredCharsetNames() {
        return Charsets.requiredCharsets().keySet();
    }

    @Test
    public void testIso8859_1() {
        Assertions.assertEquals((Object)"ISO-8859-1", (Object)Charsets.ISO_8859_1.name());
    }

    @Test
    public void testRequiredCharsets() {
        SortedMap requiredCharsets = Charsets.requiredCharsets();
        Assertions.assertEquals((Object)((Charset)requiredCharsets.get("US-ASCII")).name(), (Object)"US-ASCII");
        Assertions.assertEquals((Object)((Charset)requiredCharsets.get("ISO-8859-1")).name(), (Object)"ISO-8859-1");
        Assertions.assertEquals((Object)((Charset)requiredCharsets.get("UTF-8")).name(), (Object)"UTF-8");
        Assertions.assertEquals((Object)((Charset)requiredCharsets.get("UTF-16")).name(), (Object)"UTF-16");
        Assertions.assertEquals((Object)((Charset)requiredCharsets.get("UTF-16BE")).name(), (Object)"UTF-16BE");
        Assertions.assertEquals((Object)((Charset)requiredCharsets.get("UTF-16LE")).name(), (Object)"UTF-16LE");
    }

    @Test
    public void testToCharset_String() {
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((String)null));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((Charset)null));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((Charset)Charset.defaultCharset()));
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)Charsets.toCharset((Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void testToCharset_String_Charset() {
        Assertions.assertNull((Object)Charsets.toCharset((String)null, null));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((String)null, (Charset)Charset.defaultCharset()));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((Charset)null, (Charset)Charset.defaultCharset()));
        Assertions.assertNull((Object)Charsets.toCharset((Charset)null, null));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((Charset)Charset.defaultCharset(), (Charset)Charset.defaultCharset()));
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)Charsets.toCharset((Charset)StandardCharsets.UTF_8, (Charset)Charset.defaultCharset()));
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)Charsets.toCharset((Charset)StandardCharsets.UTF_8, null));
    }

    @Test
    public void testUsAscii() {
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII.name(), (Object)Charsets.US_ASCII.name());
    }

    @Test
    public void testUtf16() {
        Assertions.assertEquals((Object)StandardCharsets.UTF_16.name(), (Object)Charsets.UTF_16.name());
    }

    @Test
    public void testUtf16Be() {
        Assertions.assertEquals((Object)StandardCharsets.UTF_16BE.name(), (Object)Charsets.UTF_16BE.name());
    }

    @Test
    public void testUtf16Le() {
        Assertions.assertEquals((Object)StandardCharsets.UTF_16LE.name(), (Object)Charsets.UTF_16LE.name());
    }

    @Test
    public void testUtf8() {
        Assertions.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)Charsets.UTF_8.name());
    }
}

