/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RegexFileFilterTest {
    public void assertFiltering(IOFileFilter filter, File file, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)filter.accept(file), (String)("Filter(File) " + filter.getClass().getName() + " not " + expected + " for " + file));
        if (file != null && file.getParentFile() != null) {
            Assertions.assertEquals((Object)expected, (Object)filter.accept(file.getParentFile(), file.getName()), (String)("Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for " + file));
            Assertions.assertEquals((Object)expected, (Object)filter.matches(file.toPath()), (String)("Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for " + file));
        } else if (file == null) {
            Assertions.assertEquals((Object)expected, (Object)filter.accept(file), (String)("Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for null"));
            Assertions.assertEquals((Object)expected, (Object)filter.matches(null), (String)("Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for null"));
        }
        Assertions.assertNotNull((Object)filter.toString());
    }

    public void assertFiltering(IOFileFilter filter, Path path, boolean expected) {
        FileVisitResult expectedFileVisitResult = AbstractFileFilter.toDefaultFileVisitResult((boolean)expected);
        Assertions.assertEquals((Object)((Object)expectedFileVisitResult), (Object)((Object)filter.accept(path, null)), (String)("Filter(Path) " + filter.getClass().getName() + " not " + (Object)((Object)expectedFileVisitResult) + " for " + path));
        Assertions.assertEquals((Object)(expectedFileVisitResult != FileVisitResult.TERMINATE ? 1 : 0), (Object)filter.matches(path), (String)("Filter(Path) " + filter.getClass().getName() + " not " + (Object)((Object)expectedFileVisitResult) + " for " + path));
        if (path != null && path.getParent() != null) {
            Assertions.assertEquals((Object)((Object)expectedFileVisitResult), (Object)((Object)filter.accept(path, null)), (String)("Filter(Path, Path) " + filter.getClass().getName() + " not " + (Object)((Object)expectedFileVisitResult) + " for " + path));
        } else if (path == null) {
            Assertions.assertEquals((Object)((Object)expectedFileVisitResult), (Object)((Object)filter.accept(path, null)), (String)("Filter(Path, Path) " + filter.getClass().getName() + " not " + (Object)((Object)expectedFileVisitResult) + " for null"));
        }
        Assertions.assertNotNull((Object)filter.toString());
    }

    private RegexFileFilter assertSerializable(RegexFileFilter serializable) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (ObjectOutputStream oos = new ObjectOutputStream((OutputStream)baos);){
                oos.writeObject(serializable);
            }
            baos.flush();
            Assertions.assertTrue((baos.toByteArray().length > 0 ? 1 : 0) != 0);
        }
        return serializable;
    }

    @Test
    public void testRegex() throws IOException {
        RegexFileFilter filter = new RegexFileFilter("^.*[tT]est(-\\d+)?\\.java$");
        this.assertSerializable(filter);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test-10.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test-.java"), false);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("test-10.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("test-.java").toPath(), false);
        filter = new RegexFileFilter("^[Tt]est.java$");
        this.assertSerializable(filter);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java"), false);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java").toPath(), false);
        filter = new RegexFileFilter(Pattern.compile("^test.java$", 2));
        this.assertSerializable(filter);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java").toPath(), true);
        filter = new RegexFileFilter("^test.java$", 2);
        this.assertSerializable(filter);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java").toPath(), true);
        filter = new RegexFileFilter("^test.java$", IOCase.INSENSITIVE);
        this.assertSerializable(filter);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java").toPath(), true);
    }

    @Test
    public void testRegexEdgeCases() {
        Assertions.assertThrows(NullPointerException.class, () -> this.assertSerializable(new RegexFileFilter((String)null)));
        Assertions.assertThrows(NullPointerException.class, () -> this.assertSerializable(new RegexFileFilter(null, 2)));
        Assertions.assertThrows(NullPointerException.class, () -> this.assertSerializable(new RegexFileFilter(null, IOCase.INSENSITIVE)));
        Assertions.assertThrows(NullPointerException.class, () -> this.assertSerializable(new RegexFileFilter((Pattern)null)));
    }

    @Test
    public void testRegexFileNameOnly() throws IOException {
        Path path = Paths.get("folder", "Foo.java");
        String patternStr = "Foo.*";
        this.assertFiltering((IOFileFilter)this.assertSerializable(new RegexFileFilter("Foo.*")), path, true);
        this.assertFiltering((IOFileFilter)this.assertSerializable(new RegexFileFilter(Pattern.compile("Foo.*"), Path::toString)), path, false);
        this.assertFiltering((IOFileFilter)new RegexFileFilter(Pattern.compile("Foo.*"), (Function)null), path, false);
        this.assertFiltering((IOFileFilter)new RegexFileFilter(Pattern.compile("Foo.*"), (Function<Path, String> & Serializable)p -> null), path, false);
        this.assertFiltering((IOFileFilter)this.assertSerializable(new RegexFileFilter(Pattern.compile("Foo.*"), (Function)null)), path, false);
        this.assertFiltering((IOFileFilter)this.assertSerializable(new RegexFileFilter(Pattern.compile("Foo.*"), (Function<Path, String> & Serializable)p -> null)), path, false);
    }
}

