/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.BrokenInputStream;
import org.apache.commons.io.input.MarkShieldInputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.input.ProxyInputStreamTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class MarkShieldInputStreamTest {
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    public void testAvailableAfterClose(int len) throws Exception {
        MarkTestableInputStream shadow;
        try (MarkTestableInputStream in = new MarkTestableInputStream((InputStream)new NullInputStream((long)len, false, false));
             MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)((Object)in));){
            Assertions.assertEquals((int)len, (int)in.available());
            shadow = in;
        }
        Assertions.assertEquals((int)0, (int)((InputStream)((Object)shadow)).available());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    public void testAvailableAfterOpen(int len) throws Exception {
        try (MarkTestableInputStream in = new MarkTestableInputStream((InputStream)new NullInputStream((long)len, false, false));
             MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)((Object)in));){
            Assertions.assertEquals((int)len, (int)in.available());
        }
    }

    @Test
    public void testCloseHandleIOException() throws IOException {
        ProxyInputStreamTest.testCloseHandleIOException((ProxyInputStream)new MarkShieldInputStream((InputStream)new BrokenInputStream((Throwable)new IOException())));
    }

    @Test
    public void testMarkIsNoOpWhenUnderlyingDoesNotSupport() throws IOException {
        try (MarkTestableInputStream in = new MarkTestableInputStream((InputStream)new NullInputStream(64L, false, false));
             MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)((Object)in));){
            msis.mark(1024);
            Assertions.assertEquals((int)0, (int)in.markcount);
            Assertions.assertEquals((int)0, (int)in.readLimit);
        }
    }

    @Test
    public void testMarkIsNoOpWhenUnderlyingSupports() throws IOException {
        try (MarkTestableInputStream in = new MarkTestableInputStream((InputStream)new NullInputStream(64L, true, false));
             MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)((Object)in));){
            msis.mark(1024);
            Assertions.assertEquals((int)0, (int)in.markcount);
            Assertions.assertEquals((int)0, (int)in.readLimit);
        }
    }

    @Test
    public void testMarkSupportedIsFalseWhenUnderlyingFalse() throws IOException {
        try (NullInputStream is = new NullInputStream(64L, false, false);){
            Assertions.assertFalse((boolean)is.markSupported());
            try (MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)is);){
                Assertions.assertFalse((boolean)msis.markSupported());
            }
        }
    }

    @Test
    public void testMarkSupportedIsFalseWhenUnderlyingTrue() throws IOException {
        try (NullInputStream is = new NullInputStream(64L, true, false);){
            Assertions.assertTrue((boolean)is.markSupported());
            try (MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)is);){
                Assertions.assertFalse((boolean)msis.markSupported());
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    public void testReadAfterClose(int len) throws Exception {
        try (MarkTestableInputStream in = new MarkTestableInputStream((InputStream)new NullInputStream((long)len, false, false));
             MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)((Object)in));){
            Assertions.assertEquals((int)len, (int)in.available());
            in.close();
            Assertions.assertThrows(IOException.class, () -> ((MarkTestableInputStream)in).read());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    public void testReadByteArrayAfterClose(int len) throws Exception {
        try (MarkTestableInputStream in = new MarkTestableInputStream((InputStream)new NullInputStream((long)len, false, false));
             MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)((Object)in));){
            Assertions.assertEquals((int)len, (int)in.available());
            in.close();
            Assertions.assertEquals((int)0, (int)in.read(new byte[0]));
            Assertions.assertThrows(IOException.class, () -> in.read(new byte[2]));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    public void testReadByteArrayIntIntAfterClose(int len) throws Exception {
        try (MarkTestableInputStream in = new MarkTestableInputStream((InputStream)new NullInputStream((long)len, false, false));
             MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)((Object)in));){
            Assertions.assertEquals((int)len, (int)in.available());
            in.close();
            Assertions.assertEquals((int)0, (int)in.read(new byte[0], 0, 1));
            Assertions.assertEquals((int)0, (int)in.read(new byte[1], 0, 0));
            Assertions.assertThrows(IOException.class, () -> in.read(new byte[2], 0, 1));
        }
    }

    @Test
    public void testResetThrowsExceptionWhenUnderlyingDoesNotSupport() throws IOException {
        try (MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)new NullInputStream(64L, false, false));){
            Assertions.assertThrows(UnsupportedOperationException.class, () -> ((MarkShieldInputStream)msis).reset());
        }
    }

    @Test
    public void testResetThrowsExceptionWhenUnderlyingSupports() throws IOException {
        try (MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)new NullInputStream(64L, true, false));){
            Assertions.assertThrows(UnsupportedOperationException.class, () -> ((MarkShieldInputStream)msis).reset());
        }
    }

    private static final class MarkTestableInputStream
    extends ProxyInputStream {
        int markcount;
        int readLimit;

        MarkTestableInputStream(InputStream in) {
            super(in);
        }

        public void mark(int readLimit) {
            ++this.markcount;
            this.readLimit = readLimit;
            super.mark(readLimit);
        }
    }
}

