/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.RandomAccessFileMode;
import org.apache.commons.io.input.RandomAccessFileInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RandomAccessFileInputStreamTest {
    private static final String DATA_FILE_NAME = "src/test/resources/org/apache/commons/io/test-file-iso8859-1.bin";
    private static final Path DATA_PATH = Paths.get("src/test/resources/org/apache/commons/io/test-file-iso8859-1.bin", new String[0]);
    private static final int DATA_FILE_LEN = 1430;

    private RandomAccessFile createRandomAccessFile() throws FileNotFoundException {
        return RandomAccessFileMode.READ_ONLY.create(DATA_FILE_NAME);
    }

    @Test
    public void testAvailableAfterClose() throws IOException {
        try (RandomAccessFileInputStream inputStream = RandomAccessFileInputStream.builder().setRandomAccessFile(this.createRandomAccessFile()).setCloseOnClose(true).get();){
            inputStream.close();
            Assertions.assertEquals((int)0, (int)inputStream.available());
        }
    }

    @Test
    public void testAvailableAfterOpen() throws IOException {
        try (RandomAccessFileInputStream inputStream = RandomAccessFileInputStream.builder().setRandomAccessFile(this.createRandomAccessFile()).setCloseOnClose(true).get();){
            Assertions.assertEquals((int)1430, (int)inputStream.available());
        }
    }

    @Test
    public void testAvailableLong() throws IOException {
        try (RandomAccessFileInputStream inputStream = RandomAccessFileInputStream.builder().setRandomAccessFile(this.createRandomAccessFile()).setCloseOnClose(true).get();){
            Assertions.assertEquals((long)1430L, (long)inputStream.availableLong());
        }
    }

    @Test
    public void testBuilderFile() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = ((RandomAccessFileInputStream.Builder)RandomAccessFileInputStream.builder().setFile(new File(DATA_FILE_NAME))).get();){
                Assertions.assertFalse((boolean)inputStream.isCloseOnClose());
                Assertions.assertNotEquals((int)-1, (int)inputStream.getRandomAccessFile().read());
            }
            file.read();
        }
    }

    @Test
    public void testBuilderGet() {
        Assertions.assertThrows(IllegalStateException.class, () -> RandomAccessFileInputStream.builder().get());
    }

    @Test
    public void testBuilderPath() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = ((RandomAccessFileInputStream.Builder)RandomAccessFileInputStream.builder().setPath(DATA_PATH)).get();){
                Assertions.assertFalse((boolean)inputStream.isCloseOnClose());
                Assertions.assertNotEquals((int)-1, (int)inputStream.getRandomAccessFile().read());
            }
            file.read();
        }
    }

    @Test
    public void testBuilderPathOpenOptions() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = ((RandomAccessFileInputStream.Builder)((RandomAccessFileInputStream.Builder)RandomAccessFileInputStream.builder().setPath(DATA_PATH)).setOpenOptions(new OpenOption[]{StandardOpenOption.READ})).get();){
                Assertions.assertFalse((boolean)inputStream.isCloseOnClose());
                Assertions.assertNotEquals((int)-1, (int)inputStream.getRandomAccessFile().read());
            }
            file.read();
        }
    }

    @Test
    public void testBuilderRandomAccessFile() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = RandomAccessFileInputStream.builder().setRandomAccessFile(file).get();){
                Assertions.assertFalse((boolean)inputStream.isCloseOnClose());
                Assertions.assertNotEquals((int)-1, (int)inputStream.getRandomAccessFile().read());
            }
            file.read();
        }
    }

    @Test
    public void testConstructorCloseOnCloseFalse() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = RandomAccessFileInputStream.builder().setRandomAccessFile(this.createRandomAccessFile()).get();){
                Assertions.assertFalse((boolean)inputStream.isCloseOnClose());
                Assertions.assertNotEquals((int)-1, (int)inputStream.getRandomAccessFile().read());
            }
            file.read();
        }
    }

    @Test
    public void testCopy() throws IOException {
        try (RandomAccessFileInputStream inputStream = RandomAccessFileInputStream.builder().setRandomAccessFile(this.createRandomAccessFile()).setCloseOnClose(true).get();
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Assertions.assertEquals((long)12L, (long)inputStream.copy(0L, 12L, (OutputStream)baos));
            Assertions.assertArrayEquals((byte[])"A Test Line.".getBytes(StandardCharsets.ISO_8859_1), (byte[])baos.toByteArray());
            baos.reset();
            Assertions.assertEquals((long)1L, (long)inputStream.copy(0L, 1L, (OutputStream)baos));
            Assertions.assertArrayEquals((byte[])"A".getBytes(StandardCharsets.ISO_8859_1), (byte[])baos.toByteArray());
            baos.reset();
            Assertions.assertEquals((long)1L, (long)inputStream.copy(11L, 1L, (OutputStream)baos));
            Assertions.assertArrayEquals((byte[])".".getBytes(StandardCharsets.ISO_8859_1), (byte[])baos.toByteArray());
            baos.reset();
            Assertions.assertEquals((long)10L, (long)inputStream.copy(1L, 10L, (OutputStream)baos));
            Assertions.assertArrayEquals((byte[])" Test Line".getBytes(StandardCharsets.ISO_8859_1), (byte[])baos.toByteArray());
            Assertions.assertEquals((int)46, (int)inputStream.read());
        }
    }

    @Test
    public void testDeprecatedConstructorCloseOnCloseTrue() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(file, true);){
                Assertions.assertTrue((boolean)inputStream.isCloseOnClose());
                Assertions.assertNotEquals((int)-1, (int)inputStream.getRandomAccessFile().read());
            }
            Assertions.assertThrows(IOException.class, file::read);
        }
    }

    @Test
    public void testDeprecatedConstructorRandomAccessFile() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(file);){
                Assertions.assertFalse((boolean)inputStream.isCloseOnClose());
                Assertions.assertNotEquals((int)-1, (int)inputStream.getRandomAccessFile().read());
            }
            file.read();
        }
    }

    @Test
    public void testDeprecatedConstructors() throws IOException {
        try (RandomAccessFile randomAccessFile = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(randomAccessFile);){
                Assertions.assertFalse((boolean)inputStream.isCloseOnClose());
                Assertions.assertEquals((Object)randomAccessFile, (Object)inputStream.getRandomAccessFile());
            }
            inputStream = new RandomAccessFileInputStream(randomAccessFile, true);
            try {
                Assertions.assertTrue((boolean)inputStream.isCloseOnClose());
                Assertions.assertEquals((Object)randomAccessFile, (Object)inputStream.getRandomAccessFile());
            }
            finally {
                inputStream.close();
            }
            inputStream = new RandomAccessFileInputStream(randomAccessFile, false);
            try {
                Assertions.assertFalse((boolean)inputStream.isCloseOnClose());
                Assertions.assertEquals((Object)randomAccessFile, (Object)inputStream.getRandomAccessFile());
            }
            finally {
                inputStream.close();
            }
        }
    }

    @Test
    public void testDeprecatedConstructorsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new RandomAccessFileInputStream(null));
        Assertions.assertThrows(NullPointerException.class, () -> new RandomAccessFileInputStream(null, true));
        Assertions.assertThrows(NullPointerException.class, () -> new RandomAccessFileInputStream(null, false));
    }

    @Test
    public void testGetters() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();
             RandomAccessFileInputStream inputStream = RandomAccessFileInputStream.builder().setRandomAccessFile(file).setCloseOnClose(true).get();){
            Assertions.assertEquals((Object)file, (Object)inputStream.getRandomAccessFile());
            Assertions.assertTrue((boolean)inputStream.isCloseOnClose());
        }
    }

    @Test
    public void testRead() throws IOException {
        try (RandomAccessFileInputStream inputStream = RandomAccessFileInputStream.builder().setRandomAccessFile(this.createRandomAccessFile()).setCloseOnClose(true).get();){
            Assertions.assertEquals((int)65, (int)inputStream.read());
            Assertions.assertEquals((int)32, (int)inputStream.read());
            Assertions.assertEquals((int)84, (int)inputStream.read());
            Assertions.assertEquals((int)101, (int)inputStream.read());
            Assertions.assertEquals((int)115, (int)inputStream.read());
            Assertions.assertEquals((int)116, (int)inputStream.read());
            Assertions.assertEquals((int)32, (int)inputStream.read());
            Assertions.assertEquals((int)76, (int)inputStream.read());
            Assertions.assertEquals((int)105, (int)inputStream.read());
            Assertions.assertEquals((int)110, (int)inputStream.read());
            Assertions.assertEquals((int)101, (int)inputStream.read());
            Assertions.assertEquals((int)46, (int)inputStream.read());
            Assertions.assertEquals((int)1418, (int)inputStream.available());
            Assertions.assertEquals((long)1418L, (long)inputStream.availableLong());
        }
    }

    @Test
    public void testReadAfterClose() throws IOException {
        try (RandomAccessFileInputStream inputStream = RandomAccessFileInputStream.builder().setRandomAccessFile(this.createRandomAccessFile()).setCloseOnClose(true).get();){
            inputStream.close();
            Assertions.assertThrows(IOException.class, () -> ((RandomAccessFileInputStream)inputStream).read());
        }
    }

    @Test
    public void testReadByteArray() throws IOException {
        try (RandomAccessFileInputStream inputStream = RandomAccessFileInputStream.builder().setRandomAccessFile(this.createRandomAccessFile()).setCloseOnClose(true).get();){
            int dataLen = 12;
            byte[] buffer = new byte[12];
            Assertions.assertEquals((int)12, (int)inputStream.read(buffer));
            Assertions.assertArrayEquals((byte[])"A Test Line.".getBytes(StandardCharsets.ISO_8859_1), (byte[])buffer);
            Assertions.assertEquals((int)1418, (int)inputStream.available());
            Assertions.assertEquals((long)1418L, (long)inputStream.availableLong());
        }
    }

    @Test
    public void testReadByteArrayBounds() throws IOException {
        try (RandomAccessFileInputStream inputStream = RandomAccessFileInputStream.builder().setRandomAccessFile(this.createRandomAccessFile()).setCloseOnClose(true).get();){
            int dataLen = 12;
            byte[] buffer = new byte[12];
            Assertions.assertEquals((int)12, (int)inputStream.read(buffer, 0, 12));
            Assertions.assertArrayEquals((byte[])"A Test Line.".getBytes(StandardCharsets.ISO_8859_1), (byte[])buffer);
            Assertions.assertEquals((int)1418, (int)inputStream.available());
            Assertions.assertEquals((long)1418L, (long)inputStream.availableLong());
        }
    }

    @Test
    public void testSkip() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();
             RandomAccessFileInputStream inputStream = RandomAccessFileInputStream.builder().setRandomAccessFile(file).get();){
            Assertions.assertEquals((long)0L, (long)inputStream.skip(-1L));
            Assertions.assertEquals((long)0L, (long)inputStream.skip(Integer.MIN_VALUE));
            Assertions.assertEquals((long)0L, (long)inputStream.skip(0L));
            Assertions.assertEquals((int)65, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)84, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)115, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)32, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)105, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)101, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)1418, (int)inputStream.available());
            Assertions.assertEquals((long)1418L, (long)inputStream.availableLong());
            Assertions.assertEquals((long)10L, (long)inputStream.skip(10L));
            Assertions.assertEquals((long)1408L, (long)inputStream.availableLong());
            long avail = inputStream.availableLong();
            Assertions.assertEquals((long)avail, (long)inputStream.skip(inputStream.availableLong()));
            Assertions.assertEquals((long)1430L, (long)file.length());
            Assertions.assertEquals((long)1430L, (long)file.getFilePointer());
            Assertions.assertEquals((long)0L, (long)inputStream.skip(1L));
            Assertions.assertEquals((long)0L, (long)inputStream.skip(1000000000000L));
        }
    }
}

