/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.io.output.BrokenOutputStream;
import org.apache.commons.io.output.UncheckedFilterOutputStream;
import org.apache.commons.io.output.WriterOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class UncheckedFilterOutputStreamTest {
    private IOException exception;
    private UncheckedFilterOutputStream brokenWriter;
    private UncheckedFilterOutputStream stringWriter;

    @BeforeEach
    public void setUp() throws IOException {
        this.exception = new IOException("test exception");
        this.brokenWriter = ((UncheckedFilterOutputStream.Builder)UncheckedFilterOutputStream.builder().setOutputStream((OutputStream)new BrokenOutputStream(this.exception))).get();
        this.stringWriter = ((UncheckedFilterOutputStream.Builder)UncheckedFilterOutputStream.builder().setOutputStream((OutputStream)((WriterOutputStream.Builder)WriterOutputStream.builder().setWriter((Writer)new StringWriter())).setCharset(Charset.defaultCharset()).get())).get();
    }

    @Test
    public void testClose() {
        this.stringWriter.close();
    }

    @Test
    public void testCloseThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.close())).getCause());
    }

    @Test
    public void testEquals() {
        this.stringWriter.equals(null);
    }

    @Test
    @Disabled(value="What should happen here?")
    public void testEqualsThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.equals(null))).getCause());
    }

    @Test
    public void testFlush() {
        this.stringWriter.flush();
    }

    @Test
    public void testFlushThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.flush())).getCause());
    }

    @Test
    public void testHashCode() {
        this.stringWriter.hashCode();
    }

    @Test
    @Disabled(value="What should happen here?")
    public void testHashCodeThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.hashCode())).getCause());
    }

    @Test
    public void testToString() {
        this.stringWriter.toString();
    }

    @Test
    @Disabled(value="What should happen here?")
    public void testToStringThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.toString())).getCause());
    }

    @Test
    public void testWriteInt() {
        this.stringWriter.write(1);
    }

    @Test
    public void testWriteIntThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.write(1))).getCause());
    }
}

