/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.internal.Require;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlParseError;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlTable;

public class TomlConfig
implements Config {
    private final TomlParseResult toml;

    public TomlConfig(Reader reader) {
        try {
            this.toml = Toml.parse(reader);
            if (this.toml.hasErrors()) {
                String error = this.toml.errors().stream().map(TomlParseError::toString).collect(Collectors.joining("\n"));
                throw new ConfigException(error, new Object[0]);
            }
        }
        catch (IOException e) {
            throw new ConfigException("Unable to read TOML.", new Object[]{e});
        }
        catch (TomlParseError e) {
            throw new ConfigException(String.valueOf(e.getCause()) + "\n Validate the config using https://www.toml-lint.com/. \n Refer to https://toml.io/en/ for TOML usage guidance. ", new Object[0]);
        }
    }

    public static Config from(Path path) {
        TomlConfig tomlConfig;
        block8: {
            Require.nonNull("Path to read", path);
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                tomlConfig = new TomlConfig(reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigException(String.format("Unable to parse: %s", path), new Object[]{e});
                }
            }
            ((Reader)reader).close();
        }
        return tomlConfig;
    }

    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Require.nonNull("Section to read", section);
        Require.nonNull("Option to read", option);
        if (!this.toml.contains(section)) {
            return Optional.empty();
        }
        Object raw = this.toml.get(section);
        if (!(raw instanceof TomlTable)) {
            throw new ConfigException(String.format("Section %s is not a section! %s", section, raw), new Object[0]);
        }
        TomlTable table = this.toml.getTable(section);
        List<Object> value = null;
        if (table != null) {
            value = table.get(option);
        }
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof TomlArray) {
            value = ((TomlArray)((Object)value)).toList();
        }
        if (value instanceof Collection) {
            Collection collection = value;
            if (collection.stream().anyMatch(TomlTable.class::isInstance)) {
                return Optional.of((List)collection.stream().map(TomlTable.class::cast).map(TomlTable::toMap).map(this::toEntryList).flatMap(Collection::stream).collect(ImmutableList.toImmutableList()));
            }
            return Optional.of((List)collection.stream().filter(item -> !(item instanceof Collection)).map(String::valueOf).collect(ImmutableList.toImmutableList()));
        }
        if (value instanceof TomlTable) {
            return Optional.of(this.toEntryList(((TomlTable)((Object)value)).toMap()));
        }
        return Optional.of(List.of(String.valueOf(value)));
    }

    @Override
    public Set<String> getSectionNames() {
        return ImmutableSortedSet.copyOf(this.toml.keySet());
    }

    @Override
    public Set<String> getOptions(String section) {
        Require.nonNull("Section name to get options for", section);
        Object raw = this.toml.get(section);
        if (!(raw instanceof TomlTable)) {
            return ImmutableSortedSet.of();
        }
        return ImmutableSortedSet.copyOf(((TomlTable)raw).keySet());
    }
}

