/*
 * Decompiled with CFR 0.152.
 */
package zmq.pipe;

import java.util.concurrent.atomic.AtomicInteger;
import zmq.pipe.YPipeBase;
import zmq.pipe.YQueue;

public class YPipe<T>
implements YPipeBase<T> {
    private final YQueue<T> queue;
    private int w;
    private int r;
    private int f;
    private final AtomicInteger c;

    public YPipe(int qsize) {
        int pos;
        this.queue = new YQueue(qsize);
        this.f = pos = this.queue.backPos();
        this.r = pos;
        this.w = pos;
        this.c = new AtomicInteger(pos);
    }

    @Override
    public void write(T value, boolean incomplete) {
        this.queue.push(value);
        if (!incomplete) {
            this.f = this.queue.backPos();
        }
    }

    @Override
    public T unwrite() {
        if (this.f == this.queue.backPos()) {
            return null;
        }
        this.queue.unpush();
        return this.queue.back();
    }

    @Override
    public boolean flush() {
        if (this.w == this.f) {
            return true;
        }
        if (!this.c.compareAndSet(this.w, this.f)) {
            this.c.set(this.f);
            this.w = this.f;
            return false;
        }
        this.w = this.f;
        return true;
    }

    @Override
    public boolean checkRead() {
        int h2 = this.queue.frontPos();
        if (h2 != this.r && this.r != -1) {
            return true;
        }
        if (!this.c.compareAndSet(h2, -1)) {
            this.r = this.c.get();
        }
        return h2 != this.r && this.r != -1;
    }

    @Override
    public T read() {
        if (!this.checkRead()) {
            return null;
        }
        return this.queue.pop();
    }

    @Override
    public T probe() {
        boolean rc = this.checkRead();
        assert (rc);
        return this.queue.front();
    }
}

