package org.openqa.selenium.devtools.v135.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * This issue warns about errors in the select element content model.
 */
public class SelectElementAccessibilityIssueDetails {

    private final org.openqa.selenium.devtools.v135.dom.model.BackendNodeId nodeId;

    private final org.openqa.selenium.devtools.v135.audits.model.SelectElementAccessibilityIssueReason selectElementAccessibilityIssueReason;

    private final java.lang.Boolean hasDisallowedAttributes;

    public SelectElementAccessibilityIssueDetails(org.openqa.selenium.devtools.v135.dom.model.BackendNodeId nodeId, org.openqa.selenium.devtools.v135.audits.model.SelectElementAccessibilityIssueReason selectElementAccessibilityIssueReason, java.lang.Boolean hasDisallowedAttributes) {
        this.nodeId = java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        this.selectElementAccessibilityIssueReason = java.util.Objects.requireNonNull(selectElementAccessibilityIssueReason, "selectElementAccessibilityIssueReason is required");
        this.hasDisallowedAttributes = java.util.Objects.requireNonNull(hasDisallowedAttributes, "hasDisallowedAttributes is required");
    }

    public org.openqa.selenium.devtools.v135.dom.model.BackendNodeId getNodeId() {
        return nodeId;
    }

    public org.openqa.selenium.devtools.v135.audits.model.SelectElementAccessibilityIssueReason getSelectElementAccessibilityIssueReason() {
        return selectElementAccessibilityIssueReason;
    }

    public java.lang.Boolean getHasDisallowedAttributes() {
        return hasDisallowedAttributes;
    }

    private static SelectElementAccessibilityIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v135.dom.model.BackendNodeId nodeId = null;
        org.openqa.selenium.devtools.v135.audits.model.SelectElementAccessibilityIssueReason selectElementAccessibilityIssueReason = null;
        java.lang.Boolean hasDisallowedAttributes = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "nodeId":
                    nodeId = input.read(org.openqa.selenium.devtools.v135.dom.model.BackendNodeId.class);
                    break;
                case "selectElementAccessibilityIssueReason":
                    selectElementAccessibilityIssueReason = input.read(org.openqa.selenium.devtools.v135.audits.model.SelectElementAccessibilityIssueReason.class);
                    break;
                case "hasDisallowedAttributes":
                    hasDisallowedAttributes = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SelectElementAccessibilityIssueDetails(nodeId, selectElementAccessibilityIssueReason, hasDisallowedAttributes);
    }
}
