package org.openqa.selenium.devtools.v85.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Details for a request that has been blocked with the BLOCKED_BY_RESPONSE
 * code. Currently only used for COEP/COOP, but may be extended to include
 * some CSP errors in the future.
 */
public class BlockedByResponseIssueDetails {

    private final org.openqa.selenium.devtools.v85.audits.model.AffectedRequest request;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.audits.model.AffectedFrame> frame;

    private final org.openqa.selenium.devtools.v85.audits.model.BlockedByResponseReason reason;

    public BlockedByResponseIssueDetails(org.openqa.selenium.devtools.v85.audits.model.AffectedRequest request, java.util.Optional<org.openqa.selenium.devtools.v85.audits.model.AffectedFrame> frame, org.openqa.selenium.devtools.v85.audits.model.BlockedByResponseReason reason) {
        this.request = java.util.Objects.requireNonNull(request, "request is required");
        this.frame = frame;
        this.reason = java.util.Objects.requireNonNull(reason, "reason is required");
    }

    public org.openqa.selenium.devtools.v85.audits.model.AffectedRequest getRequest() {
        return request;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v85.audits.model.AffectedFrame> getFrame() {
        return frame;
    }

    public org.openqa.selenium.devtools.v85.audits.model.BlockedByResponseReason getReason() {
        return reason;
    }

    private static BlockedByResponseIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v85.audits.model.AffectedRequest request = null;
        java.util.Optional<org.openqa.selenium.devtools.v85.audits.model.AffectedFrame> frame = java.util.Optional.empty();
        org.openqa.selenium.devtools.v85.audits.model.BlockedByResponseReason reason = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "request":
                    request = input.read(org.openqa.selenium.devtools.v85.audits.model.AffectedRequest.class);
                    break;
                case "frame":
                    frame = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.audits.model.AffectedFrame.class));
                    break;
                case "reason":
                    reason = input.read(org.openqa.selenium.devtools.v85.audits.model.BlockedByResponseReason.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new BlockedByResponseIssueDetails(request, frame, reason);
    }
}
