/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation;

import graphql.Assert;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExperimentalApi;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.Async;
import graphql.execution.ExecutionContext;
import graphql.execution.FieldValueInfo;
import graphql.execution.instrumentation.DocumentAndVariables;
import graphql.execution.instrumentation.ExecuteObjectInstrumentationContext;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.FieldFetchingInstrumentationContext;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldCompleteParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.language.Document;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLSchema;
import graphql.validation.ValidationError;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class ChainedInstrumentation
implements Instrumentation {
    protected final ImmutableList<Instrumentation> instrumentations;

    public ChainedInstrumentation(List<Instrumentation> instrumentations) {
        this.instrumentations = ImmutableList.copyOf((Collection)Assert.assertNotNull(instrumentations));
    }

    public ChainedInstrumentation(Instrumentation ... instrumentations) {
        this(Arrays.asList(instrumentations));
    }

    public List<Instrumentation> getInstrumentations() {
        return this.instrumentations;
    }

    private <T> InstrumentationContext<T> chainedCtx(InstrumentationState state, BiFunction<Instrumentation, InstrumentationState, InstrumentationContext<T>> mapper) {
        if (this.instrumentations.isEmpty()) {
            return SimpleInstrumentationContext.noOp();
        }
        ChainedInstrumentationState chainedInstrumentationState = (ChainedInstrumentationState)state;
        if (this.instrumentations.size() == 1) {
            return mapper.apply((Instrumentation)this.instrumentations.get(0), chainedInstrumentationState.getState(0));
        }
        return new ChainedInstrumentationContext<T>(this.chainedMapAndDropNulls(chainedInstrumentationState, mapper));
    }

    private <T> T chainedInstrument(InstrumentationState state, T input, ChainedInstrumentationFunction<Instrumentation, InstrumentationState, T, T> mapper) {
        ChainedInstrumentationState chainedInstrumentationState = (ChainedInstrumentationState)state;
        for (int i = 0; i < this.instrumentations.size(); ++i) {
            Instrumentation instrumentation = (Instrumentation)this.instrumentations.get(i);
            InstrumentationState specificState = chainedInstrumentationState.getState(i);
            input = mapper.apply(instrumentation, specificState, input);
        }
        return input;
    }

    protected <T> ImmutableList<T> chainedMapAndDropNulls(InstrumentationState state, BiFunction<Instrumentation, InstrumentationState, T> mapper) {
        ChainedInstrumentationState chainedInstrumentationState = (ChainedInstrumentationState)state;
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize(this.instrumentations.size());
        for (int i = 0; i < this.instrumentations.size(); ++i) {
            InstrumentationState specificState;
            Instrumentation instrumentation = (Instrumentation)this.instrumentations.get(i);
            T value = mapper.apply(instrumentation, specificState = chainedInstrumentationState.getState(i));
            if (value == null) continue;
            result.add(value);
        }
        return result.build();
    }

    protected void chainedConsume(InstrumentationState state, BiConsumer<Instrumentation, InstrumentationState> stateConsumer) {
        ChainedInstrumentationState chainedInstrumentationState = (ChainedInstrumentationState)state;
        for (int i = 0; i < this.instrumentations.size(); ++i) {
            Instrumentation instrumentation = (Instrumentation)this.instrumentations.get(i);
            InstrumentationState specificState = chainedInstrumentationState.getState(i);
            stateConsumer.accept(instrumentation, specificState);
        }
    }

    @Override
    @NotNull
    public CompletableFuture<InstrumentationState> createStateAsync(InstrumentationCreateStateParameters parameters) {
        return ChainedInstrumentationState.combineAll(this.instrumentations, parameters);
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginExecution(InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return this.chainedCtx(state, (instrumentation, specificState) -> instrumentation.beginExecution(parameters, (InstrumentationState)specificState));
    }

    @Override
    public InstrumentationContext<Document> beginParse(InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return this.chainedCtx(state, (instrumentation, specificState) -> instrumentation.beginParse(parameters, (InstrumentationState)specificState));
    }

    @Override
    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters, InstrumentationState state) {
        return this.chainedCtx(state, (instrumentation, specificState) -> instrumentation.beginValidation(parameters, (InstrumentationState)specificState));
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters, InstrumentationState state) {
        return this.chainedCtx(state, (instrumentation, specificState) -> instrumentation.beginExecuteOperation(parameters, (InstrumentationState)specificState));
    }

    @Override
    public ExecutionStrategyInstrumentationContext beginExecutionStrategy(InstrumentationExecutionStrategyParameters parameters, InstrumentationState state) {
        if (this.instrumentations.isEmpty()) {
            return ExecutionStrategyInstrumentationContext.NOOP;
        }
        BiFunction<Instrumentation, InstrumentationState, ExecutionStrategyInstrumentationContext> mapper = (instrumentation, specificState) -> instrumentation.beginExecutionStrategy(parameters, (InstrumentationState)specificState);
        ChainedInstrumentationState chainedInstrumentationState = (ChainedInstrumentationState)state;
        if (this.instrumentations.size() == 1) {
            return mapper.apply((Instrumentation)this.instrumentations.get(0), chainedInstrumentationState.getState(0));
        }
        return new ChainedExecutionStrategyInstrumentationContext(this.chainedMapAndDropNulls(chainedInstrumentationState, mapper));
    }

    @Override
    @Nullable
    public ExecuteObjectInstrumentationContext beginExecuteObject(InstrumentationExecutionStrategyParameters parameters, InstrumentationState state) {
        if (this.instrumentations.isEmpty()) {
            return ExecuteObjectInstrumentationContext.NOOP;
        }
        BiFunction<Instrumentation, InstrumentationState, ExecuteObjectInstrumentationContext> mapper = (instrumentation, specificState) -> instrumentation.beginExecuteObject(parameters, (InstrumentationState)specificState);
        ChainedInstrumentationState chainedInstrumentationState = (ChainedInstrumentationState)state;
        if (this.instrumentations.size() == 1) {
            return mapper.apply((Instrumentation)this.instrumentations.get(0), chainedInstrumentationState.getState(0));
        }
        return new ChainedExecuteObjectInstrumentationContext(this.chainedMapAndDropNulls(chainedInstrumentationState, mapper));
    }

    @Override
    @ExperimentalApi
    public InstrumentationContext<Object> beginDeferredField(InstrumentationState instrumentationState) {
        return new ChainedDeferredExecutionStrategyInstrumentationContext(this.chainedMapAndDropNulls(instrumentationState, Instrumentation::beginDeferredField));
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginSubscribedFieldEvent(InstrumentationFieldParameters parameters, InstrumentationState state) {
        return this.chainedCtx(state, (instrumentation, specificState) -> instrumentation.beginSubscribedFieldEvent(parameters, (InstrumentationState)specificState));
    }

    @Override
    @Nullable
    public InstrumentationContext<Object> beginFieldExecution(InstrumentationFieldParameters parameters, InstrumentationState state) {
        return this.chainedCtx(state, (instrumentation, specificState) -> instrumentation.beginFieldExecution(parameters, (InstrumentationState)specificState));
    }

    @Override
    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        return this.chainedCtx(state, (instrumentation, specificState) -> instrumentation.beginFieldFetch(parameters, (InstrumentationState)specificState));
    }

    @Override
    public FieldFetchingInstrumentationContext beginFieldFetching(InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        if (this.instrumentations.isEmpty()) {
            return FieldFetchingInstrumentationContext.NOOP;
        }
        BiFunction<Instrumentation, InstrumentationState, FieldFetchingInstrumentationContext> mapper = (instrumentation, specificState) -> instrumentation.beginFieldFetching(parameters, (InstrumentationState)specificState);
        ChainedInstrumentationState chainedInstrumentationState = (ChainedInstrumentationState)state;
        if (this.instrumentations.size() == 1) {
            return mapper.apply((Instrumentation)this.instrumentations.get(0), chainedInstrumentationState.getState(0));
        }
        ImmutableList<FieldFetchingInstrumentationContext> objects = this.chainedMapAndDropNulls(chainedInstrumentationState, mapper);
        return new ChainedFieldFetchingInstrumentationContext(objects);
    }

    @Override
    @Nullable
    public InstrumentationContext<Object> beginFieldCompletion(InstrumentationFieldCompleteParameters parameters, InstrumentationState state) {
        return this.chainedCtx(state, (instrumentation, specificState) -> instrumentation.beginFieldCompletion(parameters, (InstrumentationState)specificState));
    }

    @Override
    @Nullable
    public InstrumentationContext<Object> beginFieldListCompletion(InstrumentationFieldCompleteParameters parameters, InstrumentationState state) {
        return this.chainedCtx(state, (instrumentation, specificState) -> instrumentation.beginFieldListCompletion(parameters, (InstrumentationState)specificState));
    }

    @Override
    @NotNull
    public ExecutionInput instrumentExecutionInput(ExecutionInput executionInput, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return this.chainedInstrument(state, executionInput, (instrumentation, specificState, accumulator) -> instrumentation.instrumentExecutionInput((ExecutionInput)accumulator, parameters, (InstrumentationState)specificState));
    }

    @Override
    @NotNull
    public DocumentAndVariables instrumentDocumentAndVariables(DocumentAndVariables documentAndVariables, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return this.chainedInstrument(state, documentAndVariables, (instrumentation, specificState, accumulator) -> instrumentation.instrumentDocumentAndVariables((DocumentAndVariables)accumulator, parameters, (InstrumentationState)specificState));
    }

    @Override
    @NotNull
    public GraphQLSchema instrumentSchema(GraphQLSchema schema, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return this.chainedInstrument(state, schema, (instrumentation, specificState, accumulator) -> instrumentation.instrumentSchema((GraphQLSchema)accumulator, parameters, (InstrumentationState)specificState));
    }

    @Override
    @NotNull
    public ExecutionContext instrumentExecutionContext(ExecutionContext executionContext, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return this.chainedInstrument(state, executionContext, (instrumentation, specificState, accumulator) -> instrumentation.instrumentExecutionContext((ExecutionContext)accumulator, parameters, (InstrumentationState)specificState));
    }

    @Override
    @NotNull
    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        return this.chainedInstrument(state, dataFetcher, (instrumentation, specificState, accumulator) -> instrumentation.instrumentDataFetcher((DataFetcher<?>)accumulator, parameters, (InstrumentationState)specificState));
    }

    @Override
    @NotNull
    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        ImmutableList<Map.Entry> entries = this.chainedMapAndDropNulls(state, AbstractMap.SimpleEntry::new);
        CompletableFuture resultsFuture = Async.eachSequentially(entries, (entry, prevResults) -> {
            Instrumentation instrumentation = (Instrumentation)entry.getKey();
            InstrumentationState specificState = (InstrumentationState)entry.getValue();
            ExecutionResult lastResult = !prevResults.isEmpty() ? (ExecutionResult)prevResults.get(prevResults.size() - 1) : executionResult;
            return instrumentation.instrumentExecutionResult(lastResult, parameters, specificState);
        });
        return resultsFuture.thenApply(results -> results.isEmpty() ? executionResult : (ExecutionResult)results.get(results.size() - 1));
    }

    @FunctionalInterface
    private static interface ChainedInstrumentationFunction<I, S, V, R> {
        public R apply(I var1, S var2, V var3);
    }

    private static class ChainedDeferredExecutionStrategyInstrumentationContext
    implements InstrumentationContext<Object> {
        private final List<InstrumentationContext<Object>> contexts;

        ChainedDeferredExecutionStrategyInstrumentationContext(List<InstrumentationContext<Object>> contexts) {
            this.contexts = Collections.unmodifiableList(contexts);
        }

        @Override
        public void onDispatched() {
            this.contexts.forEach(InstrumentationContext::onDispatched);
        }

        @Override
        public void onCompleted(Object result, Throwable t2) {
            this.contexts.forEach(context -> context.onCompleted(result, t2));
        }
    }

    private static class ChainedFieldFetchingInstrumentationContext
    implements FieldFetchingInstrumentationContext {
        private final ImmutableList<FieldFetchingInstrumentationContext> contexts;

        ChainedFieldFetchingInstrumentationContext(ImmutableList<FieldFetchingInstrumentationContext> contexts) {
            this.contexts = contexts;
        }

        @Override
        public void onDispatched() {
            this.contexts.forEach(InstrumentationContext::onDispatched);
        }

        @Override
        public void onFetchedValue(Object fetchedValue) {
            this.contexts.forEach(context -> context.onFetchedValue(fetchedValue));
        }

        @Override
        public void onCompleted(Object result, Throwable t2) {
            this.contexts.forEach(context -> context.onCompleted(result, t2));
        }
    }

    private static class ChainedExecuteObjectInstrumentationContext
    implements ExecuteObjectInstrumentationContext {
        private final ImmutableList<ExecuteObjectInstrumentationContext> contexts;

        ChainedExecuteObjectInstrumentationContext(ImmutableList<ExecuteObjectInstrumentationContext> contexts) {
            this.contexts = contexts;
        }

        @Override
        public void onDispatched() {
            this.contexts.forEach(InstrumentationContext::onDispatched);
        }

        @Override
        public void onCompleted(Map<String, Object> result, Throwable t2) {
            this.contexts.forEach(context -> context.onCompleted(result, t2));
        }

        @Override
        public void onFieldValuesInfo(List<FieldValueInfo> fieldValueInfoList) {
            this.contexts.forEach(context -> context.onFieldValuesInfo(fieldValueInfoList));
        }

        @Override
        public void onFieldValuesException() {
            this.contexts.forEach(ExecuteObjectInstrumentationContext::onFieldValuesException);
        }
    }

    private static class ChainedExecutionStrategyInstrumentationContext
    implements ExecutionStrategyInstrumentationContext {
        private final ImmutableList<ExecutionStrategyInstrumentationContext> contexts;

        ChainedExecutionStrategyInstrumentationContext(ImmutableList<ExecutionStrategyInstrumentationContext> contexts) {
            this.contexts = contexts;
        }

        @Override
        public void onDispatched() {
            this.contexts.forEach(InstrumentationContext::onDispatched);
        }

        @Override
        public void onCompleted(ExecutionResult result, Throwable t2) {
            this.contexts.forEach(context -> context.onCompleted(result, t2));
        }

        @Override
        public void onFieldValuesInfo(List<FieldValueInfo> fieldValueInfoList) {
            this.contexts.forEach(context -> context.onFieldValuesInfo(fieldValueInfoList));
        }

        @Override
        public void onFieldValuesException() {
            this.contexts.forEach(ExecutionStrategyInstrumentationContext::onFieldValuesException);
        }
    }

    private static class ChainedInstrumentationContext<T>
    implements InstrumentationContext<T> {
        private final ImmutableList<InstrumentationContext<T>> contexts;

        ChainedInstrumentationContext(ImmutableList<InstrumentationContext<T>> contexts) {
            this.contexts = contexts;
        }

        @Override
        public void onDispatched() {
            this.contexts.forEach((Consumer<InstrumentationContext<T>>)((Consumer<InstrumentationContext>)InstrumentationContext::onDispatched));
        }

        @Override
        public void onCompleted(T result, Throwable t2) {
            this.contexts.forEach((Consumer<InstrumentationContext<T>>)((Consumer<InstrumentationContext>)context -> context.onCompleted(result, t2)));
        }
    }

    static class ChainedInstrumentationState
    implements InstrumentationState {
        private final List<InstrumentationState> instrumentationStates;

        private ChainedInstrumentationState(List<InstrumentationState> instrumentationStates) {
            this.instrumentationStates = instrumentationStates;
        }

        private InstrumentationState getState(int index) {
            return this.instrumentationStates.get(index);
        }

        private static CompletableFuture<InstrumentationState> combineAll(List<Instrumentation> instrumentations, InstrumentationCreateStateParameters parameters) {
            Async.CombinedBuilder<InstrumentationState> builder = Async.ofExpectedSize(instrumentations.size());
            for (Instrumentation instrumentation : instrumentations) {
                CompletableFuture<InstrumentationState> stateCF = Async.orNullCompletedFuture(instrumentation.createStateAsync(parameters));
                builder.add(stateCF);
            }
            return builder.await().thenApply(ChainedInstrumentationState::new);
        }
    }
}

