/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.AbstractFileComparator;
import org.apache.commons.io.comparator.ComparatorAbstractTest;
import org.apache.commons.io.comparator.SizeFileComparator;
import org.apache.commons.io.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SizeFileComparatorTest
extends ComparatorAbstractTest {
    private File smallerDir;
    private File largerDir;
    private File smallerFile;
    private File largerFile;

    @BeforeEach
    public void setUp() throws Exception {
        this.comparator = (AbstractFileComparator)SizeFileComparator.SIZE_COMPARATOR;
        this.reverse = SizeFileComparator.SIZE_REVERSE;
        this.smallerDir = new File(this.dir, "smallerdir");
        this.largerDir = new File(this.dir, "largerdir");
        this.smallerFile = new File(this.smallerDir, "smaller.txt");
        File equalFile = new File(this.dir, "equal.txt");
        this.largerFile = new File(this.largerDir, "larger.txt");
        this.smallerDir.mkdir();
        this.largerDir.mkdir();
        if (!this.smallerFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.smallerFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output2 = new BufferedOutputStream(Files.newOutputStream(this.smallerFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output2, 32L);
        }
        if (!equalFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + equalFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(equalFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 48L);
        }
        if (!this.largerFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.largerFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.largerFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 64L);
        }
        this.equalFile1 = equalFile;
        this.equalFile2 = equalFile;
        this.lessFile = this.smallerFile;
        this.moreFile = this.largerFile;
    }

    @Test
    public void testCompareDirectorySizes() {
        Assertions.assertEquals((int)0, (int)this.comparator.compare(this.smallerDir, this.largerDir), (String)"sumDirectoryContents=false");
        Assertions.assertEquals((int)-1, (int)SizeFileComparator.SIZE_SUMDIR_COMPARATOR.compare(this.smallerDir, this.largerDir), (String)"less");
        Assertions.assertEquals((int)1, (int)SizeFileComparator.SIZE_SUMDIR_REVERSE.compare(this.smallerDir, this.largerDir), (String)"less");
    }

    @Test
    public void testNonExistentFile() {
        File nonExistentFile = new File(FileUtils.current(), "non-existent.txt");
        Assertions.assertFalse((boolean)nonExistentFile.exists());
        Assertions.assertTrue((this.comparator.compare(nonExistentFile, this.moreFile) < 0 ? 1 : 0) != 0, (String)"less");
    }
}

