/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v131.input.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum GestureSourceType {
    DEFAULT("default"),
    TOUCH("touch"),
    MOUSE("mouse");

    private String value;

    private GestureSourceType(String value) {
        this.value = value;
    }

    public static GestureSourceType fromString(String s2) {
        return Arrays.stream(GestureSourceType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within GestureSourceType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static GestureSourceType fromJson(JsonInput input) {
        return GestureSourceType.fromString(input.nextString());
    }
}

