/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.function.IOBinaryOperator;
import org.apache.commons.io.function.IOComparatorTest;
import org.apache.commons.io.function.TestConstants;
import org.apache.commons.io.function.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IOBinaryOperatorStreamTest {
    private static final IOBinaryOperator<Path> MIN_BY_IO_BO = IOBinaryOperator.minBy(IOComparatorTest.REAL_PATH_COMP);
    private static final BinaryOperator<Path> MIN_BY_BO = MIN_BY_IO_BO.asBinaryOperator();
    private static final IOBinaryOperator<Path> MAX_BY_IO_BO = IOBinaryOperator.maxBy(IOComparatorTest.REAL_PATH_COMP);
    private static final BinaryOperator<Path> MAX_BY_BO = MAX_BY_IO_BO.asBinaryOperator();
    private static final IOBinaryOperator<Path> REAL_PATH_IO_BO = (t, u) -> t.toRealPath(new LinkOption[0]);
    private static final BinaryOperator<Path> REAL_PATH_BO = REAL_PATH_IO_BO.asBinaryOperator();

    IOBinaryOperatorStreamTest() {
    }

    @Test
    void testAsBinaryOperator() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Stream.of(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_A).reduce(TestUtils.throwingIOBinaryOperator().asBinaryOperator()).get());
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, (Object)Stream.of(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_A).reduce(MAX_BY_BO).get());
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, (Object)Stream.of(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_A).reduce(MIN_BY_BO).get());
    }

    @Test
    void testMaxBy() {
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, (Object)Stream.of(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_A).reduce(MAX_BY_BO).get());
        IOBinaryOperator binIoOp = IOBinaryOperator.maxBy((t, u) -> t.toRealPath(new LinkOption[0]).compareTo((Path)u));
        BiFunction asBiFunction = binIoOp.asBiFunction();
        BinaryOperator asBinaryOperator = binIoOp.asBinaryOperator();
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_B, asBiFunction.apply(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_B));
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_B, asBinaryOperator.apply(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_B));
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, (Object)Stream.of(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_A).reduce(asBinaryOperator).get());
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_B, (Object)Stream.of(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_B).reduce(asBinaryOperator).get());
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_B, (Object)Stream.of(TestConstants.ABS_PATH_B, TestConstants.ABS_PATH_A).reduce(asBinaryOperator).get());
    }

    @Test
    void testMinBy() {
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, (Object)Stream.of(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_A).reduce(MIN_BY_BO).get());
        IOBinaryOperator binIoOp = IOBinaryOperator.minBy((t, u) -> t.toRealPath(new LinkOption[0]).compareTo((Path)u));
        BiFunction asBiFunction = binIoOp.asBiFunction();
        BinaryOperator asBinaryOperator = binIoOp.asBinaryOperator();
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, asBiFunction.apply(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_B));
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, asBinaryOperator.apply(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_B));
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, (Object)Stream.of(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_A).reduce(asBinaryOperator).get());
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, (Object)Stream.of(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_B).reduce(asBinaryOperator).get());
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, (Object)Stream.of(TestConstants.ABS_PATH_B, TestConstants.ABS_PATH_A).reduce(asBinaryOperator).get());
    }

    @Test
    void testReduce() throws IOException {
        Path expected;
        Path current = PathUtils.current();
        try (Stream<Path> stream = Files.list(current);){
            expected = stream.reduce((t, u) -> {
                try {
                    return t.toRealPath(new LinkOption[0]);
                }
                catch (IOException e) {
                    return (Path)Assertions.fail((Throwable)e);
                }
            }).get();
        }
        stream = Files.list(current);
        try {
            Assertions.assertEquals((Object)expected, (Object)stream.reduce(REAL_PATH_BO).get());
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

