/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.validation;

import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.NonNullableValueCoercedAsNullException;
import graphql.execution.ValuesResolver;
import graphql.language.Value;
import graphql.schema.CoercingParseValueException;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.InputValueWithState;
import graphql.schema.validation.SchemaValidationError;
import graphql.schema.validation.SchemaValidationErrorCollector;
import graphql.schema.validation.SchemaValidationErrorType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.validation.ValidationUtil;
import java.util.Locale;

@Internal
public class AppliedDirectiveArgumentsAreValid
extends GraphQLTypeVisitorStub {
    private ValidationUtil validationUtil = new ValidationUtil();

    @Override
    public TraversalControl visitGraphQLDirective(GraphQLDirective directive, TraverserContext<GraphQLSchemaElement> context) {
        if (context.getParentNode() != null) {
            for (GraphQLArgument graphQLArgument : directive.getArguments()) {
                this.checkArgument(directive.getName(), graphQLArgument.getName(), graphQLArgument.getArgumentValue(), graphQLArgument.getType(), context);
            }
        }
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitGraphQLAppliedDirective(GraphQLAppliedDirective directive, TraverserContext<GraphQLSchemaElement> context) {
        if (context.getParentNode() != null) {
            for (GraphQLAppliedDirectiveArgument graphQLArgument : directive.getArguments()) {
                this.checkArgument(directive.getName(), graphQLArgument.getName(), graphQLArgument.getArgumentValue(), graphQLArgument.getType(), context);
            }
        }
        return TraversalControl.CONTINUE;
    }

    private void checkArgument(String directiveName, String argumentName, InputValueWithState argumentValue, GraphQLInputType argumentType, TraverserContext<GraphQLSchemaElement> context) {
        GraphQLSchema schema = context.getVarFromParents(GraphQLSchema.class);
        SchemaValidationErrorCollector errorCollector = context.getVarFromParents(SchemaValidationErrorCollector.class);
        boolean invalid = false;
        if (argumentValue.isLiteral() && !this.validationUtil.isValidLiteralValue((Value)argumentValue.getValue(), argumentType, schema, GraphQLContext.getDefault(), Locale.getDefault())) {
            invalid = true;
        } else if (argumentValue.isExternal() && !this.isValidExternalValue(schema, argumentValue.getValue(), argumentType, GraphQLContext.getDefault(), Locale.getDefault())) {
            invalid = true;
        } else if (argumentValue.isNotSet() && GraphQLTypeUtil.isNonNull(argumentType)) {
            invalid = true;
        }
        if (invalid) {
            String message = String.format("Invalid argument '%s' for applied directive of name '%s'", argumentName, directiveName);
            errorCollector.addError(new SchemaValidationError(SchemaValidationErrorType.InvalidAppliedDirectiveArgument, message));
        }
    }

    private boolean isValidExternalValue(GraphQLSchema schema, Object externalValue, GraphQLInputType type, GraphQLContext graphQLContext, Locale locale) {
        try {
            ValuesResolver.externalValueToInternalValue(schema.getCodeRegistry().getFieldVisibility(), externalValue, type, graphQLContext, locale);
            return true;
        }
        catch (NonNullableValueCoercedAsNullException | CoercingParseValueException e) {
            return false;
        }
    }
}

