/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.events.zeromq;

import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.function.Consumer;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.events.EventListener;
import org.openqa.selenium.events.EventName;
import org.openqa.selenium.events.zeromq.BoundZmqEventBus;
import org.openqa.selenium.events.zeromq.UnboundZmqEventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.net.Urls;
import org.zeromq.ZContext;

public class ZeroMqEventBus {
    private static final String EVENTS_SECTION = "events";
    private static final int DEFAULT_HEARTBEAT_PERIOD_SECONDS = 60;

    private ZeroMqEventBus() {
    }

    public static EventBus create(ZContext context, String publish, String subscribe, boolean bind, Secret secret) {
        return ZeroMqEventBus.create(context, publish, subscribe, bind, secret, Duration.ofSeconds(60L));
    }

    public static EventBus create(ZContext context, String publish, String subscribe, boolean bind, Secret secret, Duration heartbeatPeriod) {
        if (bind) {
            return new BoundZmqEventBus(context, publish, subscribe, secret, heartbeatPeriod);
        }
        return new UnboundZmqEventBus(context, publish, subscribe, secret, heartbeatPeriod);
    }

    public static EventBus create(Config config) {
        String publish = config.get(EVENTS_SECTION, "publish").orElseGet(() -> {
            URI uri = config.get("node", "hub").map(Urls::from).orElseThrow(() -> new IllegalArgumentException("Unable to find address to publish events to."));
            return ZeroMqEventBus.mungeUri(uri, "tcp", 4442);
        });
        String subscribe = config.get(EVENTS_SECTION, "subscribe").orElseGet(() -> {
            URI uri = config.get("node", "hub").map(Urls::from).orElseThrow(() -> new IllegalArgumentException("Unable to find address to subscribe for events from."));
            return ZeroMqEventBus.mungeUri(uri, "tcp", 4443);
        });
        boolean bind = config.getBool(EVENTS_SECTION, "bind").orElse(false);
        Duration heartbeatPeriod = ZeroMqEventBus.getHeartbeatPeriod(config);
        SecretOptions secretOptions = new SecretOptions(config);
        return ZeroMqEventBus.create(new ZContext(), publish, subscribe, bind, secretOptions.getRegistrationSecret(), heartbeatPeriod);
    }

    private static Duration getHeartbeatPeriod(Config config) {
        int periodSeconds = config.getInt(EVENTS_SECTION, "eventbus-heartbeat-period").orElse(60);
        return Duration.ofSeconds(periodSeconds);
    }

    private static String mungeUri(URI base, String scheme, int port) {
        try {
            return new URI(scheme, null, base.getHost(), port, null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Unable to create URI from " + String.valueOf(base), new Object[0]);
        }
    }

    public static EventListener<RejectedEvent> onRejectedEvent(Consumer<RejectedEvent> handler) {
        Require.nonNull("Handler", handler);
        return new EventListener<RejectedEvent>(UnboundZmqEventBus.REJECTED_EVENT, (Type)((Object)RejectedEvent.class), handler);
    }

    public static class RejectedEvent {
        private final EventName name;
        private final Object data;

        RejectedEvent(EventName name, Object data) {
            this.name = name;
            this.data = data;
        }

        private static RejectedEvent fromJson(JsonInput input) {
            EventName name = null;
            Object data = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "data": {
                        data = input.read((Type)((Object)Object.class));
                        continue block8;
                    }
                    case "name": {
                        name = (EventName)input.read((Type)((Object)EventName.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new RejectedEvent(name, data);
        }

        public EventName getName() {
            return this.name;
        }

        public Object getData() {
            return this.data;
        }
    }
}

