package org.openqa.selenium.devtools.v141.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS style coming from animations with the name of the animation.
 */
public class CSSAnimationStyle {

    private final java.util.Optional<java.lang.String> name;

    private final org.openqa.selenium.devtools.v141.css.model.CSSStyle style;

    public CSSAnimationStyle(java.util.Optional<java.lang.String> name, org.openqa.selenium.devtools.v141.css.model.CSSStyle style) {
        this.name = name;
        this.style = java.util.Objects.requireNonNull(style, "style is required");
    }

    /**
     * The name of the animation.
     */
    public java.util.Optional<java.lang.String> getName() {
        return name;
    }

    /**
     * The style coming from the animation.
     */
    public org.openqa.selenium.devtools.v141.css.model.CSSStyle getStyle() {
        return style;
    }

    private static CSSAnimationStyle fromJson(JsonInput input) {
        java.util.Optional<java.lang.String> name = java.util.Optional.empty();
        org.openqa.selenium.devtools.v141.css.model.CSSStyle style = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "style":
                    style = input.read(org.openqa.selenium.devtools.v141.css.model.CSSStyle.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSAnimationStyle(name, style);
    }
}
