/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.network;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.bidi.network.RequestData;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class BaseParameters {
    private final String browsingContextId;
    private final boolean isBlocked;
    private final String navigationId;
    private final long redirectCount;
    private final RequestData request;
    private final long timestamp;
    private final List<String> intercepts;

    BaseParameters(String browsingContextId, boolean isBlocked, String navigation, long redirectCount, RequestData request, long timestamp, List<String> intercepts) {
        this.browsingContextId = browsingContextId;
        this.isBlocked = isBlocked;
        this.navigationId = navigation;
        this.redirectCount = redirectCount;
        this.request = request;
        this.timestamp = timestamp;
        this.intercepts = intercepts;
    }

    public static BaseParameters fromJson(JsonInput input) {
        String browsingContextId = null;
        boolean isBlocked = false;
        String navigationId = null;
        long redirectCount = 0L;
        RequestData request = null;
        long timestamp = 0L;
        List<String> intercepts = new ArrayList<String>();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "context": {
                    browsingContextId = (String)input.read(String.class);
                    continue block18;
                }
                case "isBlocked": {
                    isBlocked = (Boolean)input.read(Boolean.class);
                    continue block18;
                }
                case "navigation": {
                    navigationId = (String)input.read(String.class);
                    continue block18;
                }
                case "redirectCount": {
                    redirectCount = (Long)input.read(Long.class);
                    continue block18;
                }
                case "request": {
                    request = (RequestData)input.read(RequestData.class);
                    continue block18;
                }
                case "timestamp": {
                    timestamp = (Long)input.read(Long.class);
                    continue block18;
                }
                case "intercepts": {
                    intercepts = (List)input.read(new TypeToken<List<String>>(){}.getType());
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BaseParameters(browsingContextId, isBlocked, navigationId, redirectCount, request, timestamp, intercepts);
    }

    public String getBrowsingContextId() {
        return this.browsingContextId;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public String getNavigationId() {
        return this.navigationId;
    }

    public long getRedirectCount() {
        return this.redirectCount;
    }

    public RequestData getRequest() {
        return this.request;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<String> getIntercepts() {
        return this.intercepts;
    }
}

