/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.network;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.bidi.network.AuthChallenge;
import org.openqa.selenium.bidi.network.Header;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class ResponseData {
    private final String url;
    private final String protocol;
    private final int status;
    private final String statusText;
    private final boolean fromCache;
    private final List<Header> headers;
    private final String mimeType;
    private final long bytesReceived;
    private final long headersSize;
    private final long bodySize;
    private final Optional<Long> content;
    private final Optional<AuthChallenge> authChallenge;

    private ResponseData(String url, String protocol, int status, String statusText, boolean fromCache, List<Header> headers, String mimeType, long bytesReceived, long headersSize, long bodySize, Optional<Long> content, Optional<AuthChallenge> authChallenge) {
        this.url = url;
        this.protocol = protocol;
        this.status = status;
        this.statusText = statusText;
        this.fromCache = fromCache;
        this.headers = headers;
        this.mimeType = mimeType;
        this.bytesReceived = bytesReceived;
        this.headersSize = headersSize;
        this.bodySize = bodySize;
        this.content = content;
        this.authChallenge = authChallenge;
    }

    public static ResponseData fromJson(JsonInput input) {
        String url = null;
        String protocol = null;
        int status = 0;
        String statusText = null;
        boolean fromCache = false;
        List<Header> headers = new ArrayList<Header>();
        String mimeType = null;
        long bytesReceived = 0L;
        long headersSize = 0L;
        long bodySize = 0L;
        Optional<Long> content = Optional.empty();
        Optional<AuthChallenge> authChallenge = Optional.empty();
        input.beginObject();
        block28: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = (String)input.read(String.class);
                    continue block28;
                }
                case "protocol": {
                    protocol = (String)input.read(String.class);
                    continue block28;
                }
                case "status": {
                    status = (Integer)input.read(Integer.class);
                    continue block28;
                }
                case "statusText": {
                    statusText = (String)input.read(String.class);
                    continue block28;
                }
                case "fromCache": {
                    fromCache = (Boolean)input.read(Boolean.class);
                    continue block28;
                }
                case "headers": {
                    headers = (List)input.read(new TypeToken<List<Header>>(){}.getType());
                    continue block28;
                }
                case "mimeType": {
                    mimeType = (String)input.read(String.class);
                    continue block28;
                }
                case "bytesReceived": {
                    bytesReceived = (Long)input.read(Long.class);
                    continue block28;
                }
                case "headersSize": {
                    headersSize = (Long)input.read(Long.class);
                    continue block28;
                }
                case "bodySize": {
                    bodySize = (Long)input.read(Long.class);
                    continue block28;
                }
                case "content": {
                    Map responseContent = (Map)input.read(new TypeToken<Map<String, Long>>(){}.getType());
                    content = Optional.ofNullable((Long)responseContent.get("size"));
                    continue block28;
                }
                case "authChallenge": {
                    authChallenge = Optional.of((AuthChallenge)input.read(AuthChallenge.class));
                    continue block28;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ResponseData(url, protocol, status, statusText, fromCache, headers, mimeType, bytesReceived, headersSize, bodySize, content, authChallenge);
    }

    public String getUrl() {
        return this.url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public boolean isFromCache() {
        return this.fromCache;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public long getHeadersSize() {
        return this.headersSize;
    }

    public long getBodySize() {
        return this.bodySize;
    }

    public Optional<Long> getContent() {
        return this.content;
    }

    public Optional<AuthChallenge> getAuthChallenge() {
        return this.authChallenge;
    }
}

