/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class SdkLoggerInstrumentation {
    private final Object lock = new Object();
    private final Supplier<MeterProvider> meterProvider;
    @Nullable
    private Meter meter;
    @Nullable
    private volatile LongCounter createdLogs;

    SdkLoggerInstrumentation(Supplier<MeterProvider> meterProvider) {
        this.meterProvider = meterProvider;
    }

    void emitLog() {
        this.createdLogs().add(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LongCounter createdLogs() {
        LongCounter createdLogs = this.createdLogs;
        if (createdLogs == null) {
            Object object = this.lock;
            synchronized (object) {
                createdLogs = this.createdLogs;
                if (createdLogs == null) {
                    this.createdLogs = createdLogs = this.meter().counterBuilder("otel.sdk.log.created").setUnit("{log_record}").setDescription("The number of logs submitted to enabled SDK Loggers.").build();
                }
            }
        }
        return createdLogs;
    }

    private Meter meter() {
        if (this.meter == null) {
            this.meter = this.meterProvider.get().get("io.opentelemetry.sdk.logs");
        }
        return this.meter;
    }
}

