/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v142.css;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v142.css.model.CSSAnimationStyle;
import org.openqa.selenium.devtools.v142.css.model.CSSComputedStyleProperty;
import org.openqa.selenium.devtools.v142.css.model.CSSContainerQuery;
import org.openqa.selenium.devtools.v142.css.model.CSSFontPaletteValuesRule;
import org.openqa.selenium.devtools.v142.css.model.CSSFunctionRule;
import org.openqa.selenium.devtools.v142.css.model.CSSKeyframesRule;
import org.openqa.selenium.devtools.v142.css.model.CSSLayerData;
import org.openqa.selenium.devtools.v142.css.model.CSSMedia;
import org.openqa.selenium.devtools.v142.css.model.CSSPositionTryRule;
import org.openqa.selenium.devtools.v142.css.model.CSSProperty;
import org.openqa.selenium.devtools.v142.css.model.CSSPropertyRegistration;
import org.openqa.selenium.devtools.v142.css.model.CSSPropertyRule;
import org.openqa.selenium.devtools.v142.css.model.CSSRule;
import org.openqa.selenium.devtools.v142.css.model.CSSScope;
import org.openqa.selenium.devtools.v142.css.model.CSSStyle;
import org.openqa.selenium.devtools.v142.css.model.CSSStyleSheetHeader;
import org.openqa.selenium.devtools.v142.css.model.CSSSupports;
import org.openqa.selenium.devtools.v142.css.model.ComputedStyleExtraFields;
import org.openqa.selenium.devtools.v142.css.model.FontFace;
import org.openqa.selenium.devtools.v142.css.model.InheritedAnimatedStyleEntry;
import org.openqa.selenium.devtools.v142.css.model.InheritedPseudoElementMatches;
import org.openqa.selenium.devtools.v142.css.model.InheritedStyleEntry;
import org.openqa.selenium.devtools.v142.css.model.PlatformFontUsage;
import org.openqa.selenium.devtools.v142.css.model.PseudoElementMatches;
import org.openqa.selenium.devtools.v142.css.model.RuleMatch;
import org.openqa.selenium.devtools.v142.css.model.RuleUsage;
import org.openqa.selenium.devtools.v142.css.model.SelectorList;
import org.openqa.selenium.devtools.v142.css.model.SourceRange;
import org.openqa.selenium.devtools.v142.css.model.StyleDeclarationEdit;
import org.openqa.selenium.devtools.v142.css.model.StyleSheetId;
import org.openqa.selenium.devtools.v142.css.model.Value;
import org.openqa.selenium.devtools.v142.dom.model.NodeId;
import org.openqa.selenium.devtools.v142.dom.model.PseudoType;
import org.openqa.selenium.devtools.v142.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CSS {
    public static Command<CSSRule> addRule(StyleSheetId styleSheetId, String ruleText, SourceRange location, Optional<NodeId> nodeForPropertySyntaxValidation) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(ruleText, "ruleText is required");
        Objects.requireNonNull(location, "location is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("styleSheetId", styleSheetId);
        params.put("ruleText", ruleText);
        params.put("location", location);
        nodeForPropertySyntaxValidation.ifPresent(p -> params.put("nodeForPropertySyntaxValidation", p));
        return new Command("CSS.addRule", Map.copyOf(params), ConverterFunctions.map((String)"rule", CSSRule.class));
    }

    public static Command<List<String>> collectClassNames(StyleSheetId styleSheetId) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        LinkedHashMap<String, StyleSheetId> params = new LinkedHashMap<String, StyleSheetId>();
        params.put("styleSheetId", styleSheetId);
        return new Command("CSS.collectClassNames", Map.copyOf(params), ConverterFunctions.map((String)"classNames", input -> input.readArray(String.class)));
    }

    public static Command<StyleSheetId> createStyleSheet(FrameId frameId, Optional<Boolean> force) {
        Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, FrameId> params = new LinkedHashMap<String, FrameId>();
        params.put("frameId", frameId);
        force.ifPresent(p -> params.put("force", (FrameId)p));
        return new Command("CSS.createStyleSheet", Map.copyOf(params), ConverterFunctions.map((String)"styleSheetId", StyleSheetId.class));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("CSS.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("CSS.enable", Map.copyOf(params));
    }

    public static Command<Void> forcePseudoState(NodeId nodeId, List<String> forcedPseudoClasses) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(forcedPseudoClasses, "forcedPseudoClasses is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("nodeId", nodeId);
        params.put("forcedPseudoClasses", forcedPseudoClasses);
        return new Command("CSS.forcePseudoState", Map.copyOf(params));
    }

    public static Command<Void> forceStartingStyle(NodeId nodeId, Boolean forced) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(forced, "forced is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("nodeId", nodeId);
        params.put("forced", forced);
        return new Command("CSS.forceStartingStyle", Map.copyOf(params));
    }

    public static Command<GetBackgroundColorsResponse> getBackgroundColors(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        return new Command("CSS.getBackgroundColors", Map.copyOf(params), input -> (GetBackgroundColorsResponse)input.read(GetBackgroundColorsResponse.class));
    }

    public static Command<GetComputedStyleForNodeResponse> getComputedStyleForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        return new Command("CSS.getComputedStyleForNode", Map.copyOf(params), input -> (GetComputedStyleForNodeResponse)input.read(GetComputedStyleForNodeResponse.class));
    }

    @Beta
    public static Command<List<String>> resolveValues(List<String> values, NodeId nodeId, Optional<String> propertyName, Optional<PseudoType> pseudoType, Optional<String> pseudoIdentifier) {
        Objects.requireNonNull(values, "values is required");
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("values", values);
        params.put("nodeId", nodeId);
        propertyName.ifPresent(p -> params.put("propertyName", p));
        pseudoType.ifPresent(p -> params.put("pseudoType", p));
        pseudoIdentifier.ifPresent(p -> params.put("pseudoIdentifier", p));
        return new Command("CSS.resolveValues", Map.copyOf(params), ConverterFunctions.map((String)"results", input -> input.readArray(String.class)));
    }

    @Beta
    public static Command<List<CSSProperty>> getLonghandProperties(String shorthandName, String value) {
        Objects.requireNonNull(shorthandName, "shorthandName is required");
        Objects.requireNonNull(value, "value is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("shorthandName", shorthandName);
        params.put("value", value);
        return new Command("CSS.getLonghandProperties", Map.copyOf(params), ConverterFunctions.map((String)"longhandProperties", input -> input.readArray(CSSProperty.class)));
    }

    public static Command<GetInlineStylesForNodeResponse> getInlineStylesForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        return new Command("CSS.getInlineStylesForNode", Map.copyOf(params), input -> (GetInlineStylesForNodeResponse)input.read(GetInlineStylesForNodeResponse.class));
    }

    @Beta
    public static Command<GetAnimatedStylesForNodeResponse> getAnimatedStylesForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        return new Command("CSS.getAnimatedStylesForNode", Map.copyOf(params), input -> (GetAnimatedStylesForNodeResponse)input.read(GetAnimatedStylesForNodeResponse.class));
    }

    public static Command<GetMatchedStylesForNodeResponse> getMatchedStylesForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        return new Command("CSS.getMatchedStylesForNode", Map.copyOf(params), input -> (GetMatchedStylesForNodeResponse)input.read(GetMatchedStylesForNodeResponse.class));
    }

    @Beta
    public static Command<Map<String, Object>> getEnvironmentVariables() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("CSS.getEnvironmentVariables", Map.copyOf(params), ConverterFunctions.map((String)"environmentVariables", Map.class));
    }

    public static Command<List<CSSMedia>> getMediaQueries() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("CSS.getMediaQueries", Map.copyOf(params), ConverterFunctions.map((String)"medias", input -> input.readArray(CSSMedia.class)));
    }

    public static Command<List<PlatformFontUsage>> getPlatformFontsForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        return new Command("CSS.getPlatformFontsForNode", Map.copyOf(params), ConverterFunctions.map((String)"fonts", input -> input.readArray(PlatformFontUsage.class)));
    }

    public static Command<String> getStyleSheetText(StyleSheetId styleSheetId) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        LinkedHashMap<String, StyleSheetId> params = new LinkedHashMap<String, StyleSheetId>();
        params.put("styleSheetId", styleSheetId);
        return new Command("CSS.getStyleSheetText", Map.copyOf(params), ConverterFunctions.map((String)"text", String.class));
    }

    @Beta
    public static Command<CSSLayerData> getLayersForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        return new Command("CSS.getLayersForNode", Map.copyOf(params), ConverterFunctions.map((String)"rootLayer", CSSLayerData.class));
    }

    @Beta
    public static Command<List<SourceRange>> getLocationForSelector(StyleSheetId styleSheetId, String selectorText) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(selectorText, "selectorText is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("styleSheetId", styleSheetId);
        params.put("selectorText", selectorText);
        return new Command("CSS.getLocationForSelector", Map.copyOf(params), ConverterFunctions.map((String)"ranges", input -> input.readArray(SourceRange.class)));
    }

    @Beta
    public static Command<Void> trackComputedStyleUpdatesForNode(Optional<NodeId> nodeId) {
        LinkedHashMap params = new LinkedHashMap();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        return new Command("CSS.trackComputedStyleUpdatesForNode", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> trackComputedStyleUpdates(List<CSSComputedStyleProperty> propertiesToTrack) {
        Objects.requireNonNull(propertiesToTrack, "propertiesToTrack is required");
        LinkedHashMap<String, List<CSSComputedStyleProperty>> params = new LinkedHashMap<String, List<CSSComputedStyleProperty>>();
        params.put("propertiesToTrack", propertiesToTrack);
        return new Command("CSS.trackComputedStyleUpdates", Map.copyOf(params));
    }

    @Beta
    public static Command<List<NodeId>> takeComputedStyleUpdates() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("CSS.takeComputedStyleUpdates", Map.copyOf(params), ConverterFunctions.map((String)"nodeIds", input -> input.readArray(NodeId.class)));
    }

    public static Command<Void> setEffectivePropertyValueForNode(NodeId nodeId, String propertyName, String value) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(propertyName, "propertyName is required");
        Objects.requireNonNull(value, "value is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("nodeId", nodeId);
        params.put("propertyName", propertyName);
        params.put("value", value);
        return new Command("CSS.setEffectivePropertyValueForNode", Map.copyOf(params));
    }

    public static Command<Value> setPropertyRulePropertyName(StyleSheetId styleSheetId, SourceRange range, String propertyName) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(propertyName, "propertyName is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("propertyName", propertyName);
        return new Command("CSS.setPropertyRulePropertyName", Map.copyOf(params), ConverterFunctions.map((String)"propertyName", Value.class));
    }

    public static Command<Value> setKeyframeKey(StyleSheetId styleSheetId, SourceRange range, String keyText) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(keyText, "keyText is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("keyText", keyText);
        return new Command("CSS.setKeyframeKey", Map.copyOf(params), ConverterFunctions.map((String)"keyText", Value.class));
    }

    public static Command<CSSMedia> setMediaText(StyleSheetId styleSheetId, SourceRange range, String text) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(text, "text is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("text", text);
        return new Command("CSS.setMediaText", Map.copyOf(params), ConverterFunctions.map((String)"media", CSSMedia.class));
    }

    @Beta
    public static Command<CSSContainerQuery> setContainerQueryText(StyleSheetId styleSheetId, SourceRange range, String text) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(text, "text is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("text", text);
        return new Command("CSS.setContainerQueryText", Map.copyOf(params), ConverterFunctions.map((String)"containerQuery", CSSContainerQuery.class));
    }

    @Beta
    public static Command<CSSSupports> setSupportsText(StyleSheetId styleSheetId, SourceRange range, String text) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(text, "text is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("text", text);
        return new Command("CSS.setSupportsText", Map.copyOf(params), ConverterFunctions.map((String)"supports", CSSSupports.class));
    }

    @Beta
    public static Command<CSSScope> setScopeText(StyleSheetId styleSheetId, SourceRange range, String text) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(text, "text is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("text", text);
        return new Command("CSS.setScopeText", Map.copyOf(params), ConverterFunctions.map((String)"scope", CSSScope.class));
    }

    public static Command<SelectorList> setRuleSelector(StyleSheetId styleSheetId, SourceRange range, String selector) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(selector, "selector is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("selector", selector);
        return new Command("CSS.setRuleSelector", Map.copyOf(params), ConverterFunctions.map((String)"selectorList", SelectorList.class));
    }

    public static Command<String> setStyleSheetText(StyleSheetId styleSheetId, String text) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(text, "text is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("styleSheetId", styleSheetId);
        params.put("text", text);
        return new Command("CSS.setStyleSheetText", Map.copyOf(params), ConverterFunctions.map((String)"sourceMapURL", String.class));
    }

    public static Command<List<CSSStyle>> setStyleTexts(List<StyleDeclarationEdit> edits, Optional<NodeId> nodeForPropertySyntaxValidation) {
        Objects.requireNonNull(edits, "edits is required");
        LinkedHashMap<String, List<StyleDeclarationEdit>> params = new LinkedHashMap<String, List<StyleDeclarationEdit>>();
        params.put("edits", edits);
        nodeForPropertySyntaxValidation.ifPresent(p -> params.put("nodeForPropertySyntaxValidation", (List<StyleDeclarationEdit>)p));
        return new Command("CSS.setStyleTexts", Map.copyOf(params), ConverterFunctions.map((String)"styles", input -> input.readArray(CSSStyle.class)));
    }

    public static Command<Void> startRuleUsageTracking() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("CSS.startRuleUsageTracking", Map.copyOf(params));
    }

    public static Command<List<RuleUsage>> stopRuleUsageTracking() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("CSS.stopRuleUsageTracking", Map.copyOf(params), ConverterFunctions.map((String)"ruleUsage", input -> input.readArray(RuleUsage.class)));
    }

    public static Command<TakeCoverageDeltaResponse> takeCoverageDelta() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("CSS.takeCoverageDelta", Map.copyOf(params), input -> (TakeCoverageDeltaResponse)input.read(TakeCoverageDeltaResponse.class));
    }

    @Beta
    public static Command<Void> setLocalFontsEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command("CSS.setLocalFontsEnabled", Map.copyOf(params));
    }

    public static Event<FontFace> fontsUpdated() {
        return new Event("CSS.fontsUpdated", ConverterFunctions.map((String)"font", FontFace.class));
    }

    public static Event<Void> mediaQueryResultChanged() {
        return new Event("CSS.mediaQueryResultChanged", ConverterFunctions.empty());
    }

    public static Event<CSSStyleSheetHeader> styleSheetAdded() {
        return new Event("CSS.styleSheetAdded", ConverterFunctions.map((String)"header", CSSStyleSheetHeader.class));
    }

    public static Event<StyleSheetId> styleSheetChanged() {
        return new Event("CSS.styleSheetChanged", ConverterFunctions.map((String)"styleSheetId", StyleSheetId.class));
    }

    public static Event<StyleSheetId> styleSheetRemoved() {
        return new Event("CSS.styleSheetRemoved", ConverterFunctions.map((String)"styleSheetId", StyleSheetId.class));
    }

    public static Event<NodeId> computedStyleUpdated() {
        return new Event("CSS.computedStyleUpdated", ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    public static class TakeCoverageDeltaResponse {
        private final List<RuleUsage> coverage;
        private final Number timestamp;

        public TakeCoverageDeltaResponse(List<RuleUsage> coverage, Number timestamp) {
            this.coverage = Objects.requireNonNull(coverage, "coverage is required");
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        }

        public List<RuleUsage> getCoverage() {
            return this.coverage;
        }

        public Number getTimestamp() {
            return this.timestamp;
        }

        private static TakeCoverageDeltaResponse fromJson(JsonInput input) {
            List coverage = null;
            Number timestamp = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "coverage": {
                        coverage = input.readArray(RuleUsage.class);
                        continue block8;
                    }
                    case "timestamp": {
                        timestamp = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new TakeCoverageDeltaResponse(coverage, timestamp);
        }
    }

    public static class GetMatchedStylesForNodeResponse {
        private final Optional<CSSStyle> inlineStyle;
        private final Optional<CSSStyle> attributesStyle;
        private final Optional<List<RuleMatch>> matchedCSSRules;
        private final Optional<List<PseudoElementMatches>> pseudoElements;
        private final Optional<List<InheritedStyleEntry>> inherited;
        private final Optional<List<InheritedPseudoElementMatches>> inheritedPseudoElements;
        private final Optional<List<CSSKeyframesRule>> cssKeyframesRules;
        private final Optional<List<CSSPositionTryRule>> cssPositionTryRules;
        private final Optional<Integer> activePositionFallbackIndex;
        private final Optional<List<CSSPropertyRule>> cssPropertyRules;
        private final Optional<List<CSSPropertyRegistration>> cssPropertyRegistrations;
        private final Optional<CSSFontPaletteValuesRule> cssFontPaletteValuesRule;
        private final Optional<NodeId> parentLayoutNodeId;
        private final Optional<List<CSSFunctionRule>> cssFunctionRules;

        public GetMatchedStylesForNodeResponse(Optional<CSSStyle> inlineStyle, Optional<CSSStyle> attributesStyle, Optional<List<RuleMatch>> matchedCSSRules, Optional<List<PseudoElementMatches>> pseudoElements, Optional<List<InheritedStyleEntry>> inherited, Optional<List<InheritedPseudoElementMatches>> inheritedPseudoElements, Optional<List<CSSKeyframesRule>> cssKeyframesRules, Optional<List<CSSPositionTryRule>> cssPositionTryRules, Optional<Integer> activePositionFallbackIndex, Optional<List<CSSPropertyRule>> cssPropertyRules, Optional<List<CSSPropertyRegistration>> cssPropertyRegistrations, Optional<CSSFontPaletteValuesRule> cssFontPaletteValuesRule, Optional<NodeId> parentLayoutNodeId, Optional<List<CSSFunctionRule>> cssFunctionRules) {
            this.inlineStyle = inlineStyle;
            this.attributesStyle = attributesStyle;
            this.matchedCSSRules = matchedCSSRules;
            this.pseudoElements = pseudoElements;
            this.inherited = inherited;
            this.inheritedPseudoElements = inheritedPseudoElements;
            this.cssKeyframesRules = cssKeyframesRules;
            this.cssPositionTryRules = cssPositionTryRules;
            this.activePositionFallbackIndex = activePositionFallbackIndex;
            this.cssPropertyRules = cssPropertyRules;
            this.cssPropertyRegistrations = cssPropertyRegistrations;
            this.cssFontPaletteValuesRule = cssFontPaletteValuesRule;
            this.parentLayoutNodeId = parentLayoutNodeId;
            this.cssFunctionRules = cssFunctionRules;
        }

        public Optional<CSSStyle> getInlineStyle() {
            return this.inlineStyle;
        }

        public Optional<CSSStyle> getAttributesStyle() {
            return this.attributesStyle;
        }

        public Optional<List<RuleMatch>> getMatchedCSSRules() {
            return this.matchedCSSRules;
        }

        public Optional<List<PseudoElementMatches>> getPseudoElements() {
            return this.pseudoElements;
        }

        public Optional<List<InheritedStyleEntry>> getInherited() {
            return this.inherited;
        }

        public Optional<List<InheritedPseudoElementMatches>> getInheritedPseudoElements() {
            return this.inheritedPseudoElements;
        }

        public Optional<List<CSSKeyframesRule>> getCssKeyframesRules() {
            return this.cssKeyframesRules;
        }

        public Optional<List<CSSPositionTryRule>> getCssPositionTryRules() {
            return this.cssPositionTryRules;
        }

        public Optional<Integer> getActivePositionFallbackIndex() {
            return this.activePositionFallbackIndex;
        }

        public Optional<List<CSSPropertyRule>> getCssPropertyRules() {
            return this.cssPropertyRules;
        }

        public Optional<List<CSSPropertyRegistration>> getCssPropertyRegistrations() {
            return this.cssPropertyRegistrations;
        }

        public Optional<CSSFontPaletteValuesRule> getCssFontPaletteValuesRule() {
            return this.cssFontPaletteValuesRule;
        }

        public Optional<NodeId> getParentLayoutNodeId() {
            return this.parentLayoutNodeId;
        }

        public Optional<List<CSSFunctionRule>> getCssFunctionRules() {
            return this.cssFunctionRules;
        }

        private static GetMatchedStylesForNodeResponse fromJson(JsonInput input) {
            Optional<CSSStyle> inlineStyle = Optional.empty();
            Optional<CSSStyle> attributesStyle = Optional.empty();
            Optional<List<RuleMatch>> matchedCSSRules = Optional.empty();
            Optional<List<PseudoElementMatches>> pseudoElements = Optional.empty();
            Optional<List<InheritedStyleEntry>> inherited = Optional.empty();
            Optional<List<InheritedPseudoElementMatches>> inheritedPseudoElements = Optional.empty();
            Optional<List<CSSKeyframesRule>> cssKeyframesRules = Optional.empty();
            Optional<List<CSSPositionTryRule>> cssPositionTryRules = Optional.empty();
            Optional<Integer> activePositionFallbackIndex = Optional.empty();
            Optional<List<CSSPropertyRule>> cssPropertyRules = Optional.empty();
            Optional<List<CSSPropertyRegistration>> cssPropertyRegistrations = Optional.empty();
            Optional<CSSFontPaletteValuesRule> cssFontPaletteValuesRule = Optional.empty();
            Optional<NodeId> parentLayoutNodeId = Optional.empty();
            Optional<List<CSSFunctionRule>> cssFunctionRules = Optional.empty();
            input.beginObject();
            block32: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "inlineStyle": {
                        inlineStyle = Optional.ofNullable((CSSStyle)input.read(CSSStyle.class));
                        continue block32;
                    }
                    case "attributesStyle": {
                        attributesStyle = Optional.ofNullable((CSSStyle)input.read(CSSStyle.class));
                        continue block32;
                    }
                    case "matchedCSSRules": {
                        matchedCSSRules = Optional.ofNullable(input.readArray(RuleMatch.class));
                        continue block32;
                    }
                    case "pseudoElements": {
                        pseudoElements = Optional.ofNullable(input.readArray(PseudoElementMatches.class));
                        continue block32;
                    }
                    case "inherited": {
                        inherited = Optional.ofNullable(input.readArray(InheritedStyleEntry.class));
                        continue block32;
                    }
                    case "inheritedPseudoElements": {
                        inheritedPseudoElements = Optional.ofNullable(input.readArray(InheritedPseudoElementMatches.class));
                        continue block32;
                    }
                    case "cssKeyframesRules": {
                        cssKeyframesRules = Optional.ofNullable(input.readArray(CSSKeyframesRule.class));
                        continue block32;
                    }
                    case "cssPositionTryRules": {
                        cssPositionTryRules = Optional.ofNullable(input.readArray(CSSPositionTryRule.class));
                        continue block32;
                    }
                    case "activePositionFallbackIndex": {
                        activePositionFallbackIndex = Optional.ofNullable(input.nextNumber().intValue());
                        continue block32;
                    }
                    case "cssPropertyRules": {
                        cssPropertyRules = Optional.ofNullable(input.readArray(CSSPropertyRule.class));
                        continue block32;
                    }
                    case "cssPropertyRegistrations": {
                        cssPropertyRegistrations = Optional.ofNullable(input.readArray(CSSPropertyRegistration.class));
                        continue block32;
                    }
                    case "cssFontPaletteValuesRule": {
                        cssFontPaletteValuesRule = Optional.ofNullable((CSSFontPaletteValuesRule)input.read(CSSFontPaletteValuesRule.class));
                        continue block32;
                    }
                    case "parentLayoutNodeId": {
                        parentLayoutNodeId = Optional.ofNullable((NodeId)input.read(NodeId.class));
                        continue block32;
                    }
                    case "cssFunctionRules": {
                        cssFunctionRules = Optional.ofNullable(input.readArray(CSSFunctionRule.class));
                        continue block32;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetMatchedStylesForNodeResponse(inlineStyle, attributesStyle, matchedCSSRules, pseudoElements, inherited, inheritedPseudoElements, cssKeyframesRules, cssPositionTryRules, activePositionFallbackIndex, cssPropertyRules, cssPropertyRegistrations, cssFontPaletteValuesRule, parentLayoutNodeId, cssFunctionRules);
        }
    }

    public static class GetAnimatedStylesForNodeResponse {
        private final Optional<List<CSSAnimationStyle>> animationStyles;
        private final Optional<CSSStyle> transitionsStyle;
        private final Optional<List<InheritedAnimatedStyleEntry>> inherited;

        public GetAnimatedStylesForNodeResponse(Optional<List<CSSAnimationStyle>> animationStyles, Optional<CSSStyle> transitionsStyle, Optional<List<InheritedAnimatedStyleEntry>> inherited) {
            this.animationStyles = animationStyles;
            this.transitionsStyle = transitionsStyle;
            this.inherited = inherited;
        }

        public Optional<List<CSSAnimationStyle>> getAnimationStyles() {
            return this.animationStyles;
        }

        public Optional<CSSStyle> getTransitionsStyle() {
            return this.transitionsStyle;
        }

        public Optional<List<InheritedAnimatedStyleEntry>> getInherited() {
            return this.inherited;
        }

        private static GetAnimatedStylesForNodeResponse fromJson(JsonInput input) {
            Optional<List<CSSAnimationStyle>> animationStyles = Optional.empty();
            Optional<CSSStyle> transitionsStyle = Optional.empty();
            Optional<List<InheritedAnimatedStyleEntry>> inherited = Optional.empty();
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "animationStyles": {
                        animationStyles = Optional.ofNullable(input.readArray(CSSAnimationStyle.class));
                        continue block10;
                    }
                    case "transitionsStyle": {
                        transitionsStyle = Optional.ofNullable((CSSStyle)input.read(CSSStyle.class));
                        continue block10;
                    }
                    case "inherited": {
                        inherited = Optional.ofNullable(input.readArray(InheritedAnimatedStyleEntry.class));
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetAnimatedStylesForNodeResponse(animationStyles, transitionsStyle, inherited);
        }
    }

    public static class GetInlineStylesForNodeResponse {
        private final Optional<CSSStyle> inlineStyle;
        private final Optional<CSSStyle> attributesStyle;

        public GetInlineStylesForNodeResponse(Optional<CSSStyle> inlineStyle, Optional<CSSStyle> attributesStyle) {
            this.inlineStyle = inlineStyle;
            this.attributesStyle = attributesStyle;
        }

        public Optional<CSSStyle> getInlineStyle() {
            return this.inlineStyle;
        }

        public Optional<CSSStyle> getAttributesStyle() {
            return this.attributesStyle;
        }

        private static GetInlineStylesForNodeResponse fromJson(JsonInput input) {
            Optional<CSSStyle> inlineStyle = Optional.empty();
            Optional<CSSStyle> attributesStyle = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "inlineStyle": {
                        inlineStyle = Optional.ofNullable((CSSStyle)input.read(CSSStyle.class));
                        continue block8;
                    }
                    case "attributesStyle": {
                        attributesStyle = Optional.ofNullable((CSSStyle)input.read(CSSStyle.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetInlineStylesForNodeResponse(inlineStyle, attributesStyle);
        }
    }

    public static class GetComputedStyleForNodeResponse {
        private final List<CSSComputedStyleProperty> computedStyle;
        private final ComputedStyleExtraFields extraFields;

        public GetComputedStyleForNodeResponse(List<CSSComputedStyleProperty> computedStyle, ComputedStyleExtraFields extraFields) {
            this.computedStyle = Objects.requireNonNull(computedStyle, "computedStyle is required");
            this.extraFields = Objects.requireNonNull(extraFields, "extraFields is required");
        }

        public List<CSSComputedStyleProperty> getComputedStyle() {
            return this.computedStyle;
        }

        public ComputedStyleExtraFields getExtraFields() {
            return this.extraFields;
        }

        private static GetComputedStyleForNodeResponse fromJson(JsonInput input) {
            List computedStyle = null;
            ComputedStyleExtraFields extraFields = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "computedStyle": {
                        computedStyle = input.readArray(CSSComputedStyleProperty.class);
                        continue block8;
                    }
                    case "extraFields": {
                        extraFields = (ComputedStyleExtraFields)input.read(ComputedStyleExtraFields.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetComputedStyleForNodeResponse(computedStyle, extraFields);
        }
    }

    public static class GetBackgroundColorsResponse {
        private final Optional<List<String>> backgroundColors;
        private final Optional<String> computedFontSize;
        private final Optional<String> computedFontWeight;

        public GetBackgroundColorsResponse(Optional<List<String>> backgroundColors, Optional<String> computedFontSize, Optional<String> computedFontWeight) {
            this.backgroundColors = backgroundColors;
            this.computedFontSize = computedFontSize;
            this.computedFontWeight = computedFontWeight;
        }

        public Optional<List<String>> getBackgroundColors() {
            return this.backgroundColors;
        }

        public Optional<String> getComputedFontSize() {
            return this.computedFontSize;
        }

        public Optional<String> getComputedFontWeight() {
            return this.computedFontWeight;
        }

        private static GetBackgroundColorsResponse fromJson(JsonInput input) {
            Optional<List<String>> backgroundColors = Optional.empty();
            Optional<String> computedFontSize = Optional.empty();
            Optional<String> computedFontWeight = Optional.empty();
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "backgroundColors": {
                        backgroundColors = Optional.ofNullable(input.readArray(String.class));
                        continue block10;
                    }
                    case "computedFontSize": {
                        computedFontSize = Optional.ofNullable(input.nextString());
                        continue block10;
                    }
                    case "computedFontWeight": {
                        computedFontWeight = Optional.ofNullable(input.nextString());
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetBackgroundColorsResponse(backgroundColors, computedFontSize, computedFontWeight);
        }
    }
}

