/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.dnn;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfRotatedRect;
import org.opencv.dnn.Model;
import org.opencv.utils.Converters;

public class TextDetectionModel
extends Model {
    protected TextDetectionModel(long addr) {
        super(addr);
    }

    public static TextDetectionModel __fromPtr__(long addr) {
        return new TextDetectionModel(addr);
    }

    public void detect(Mat frame, List<MatOfPoint> detections, MatOfFloat confidences) {
        Mat detections_mat = new Mat();
        MatOfFloat confidences_mat = confidences;
        TextDetectionModel.detect_0(this.nativeObj, frame.nativeObj, detections_mat.nativeObj, confidences_mat.nativeObj);
        Converters.Mat_to_vector_vector_Point(detections_mat, detections);
        detections_mat.release();
    }

    public void detect(Mat frame, List<MatOfPoint> detections) {
        Mat detections_mat = new Mat();
        TextDetectionModel.detect_1(this.nativeObj, frame.nativeObj, detections_mat.nativeObj);
        Converters.Mat_to_vector_vector_Point(detections_mat, detections);
        detections_mat.release();
    }

    public void detectTextRectangles(Mat frame, MatOfRotatedRect detections, MatOfFloat confidences) {
        MatOfRotatedRect detections_mat = detections;
        MatOfFloat confidences_mat = confidences;
        TextDetectionModel.detectTextRectangles_0(this.nativeObj, frame.nativeObj, detections_mat.nativeObj, confidences_mat.nativeObj);
    }

    public void detectTextRectangles(Mat frame, MatOfRotatedRect detections) {
        MatOfRotatedRect detections_mat = detections;
        TextDetectionModel.detectTextRectangles_1(this.nativeObj, frame.nativeObj, detections_mat.nativeObj);
    }

    @Override
    protected void finalize() throws Throwable {
        TextDetectionModel.delete(this.nativeObj);
    }

    private static native void detect_0(long var0, long var2, long var4, long var6);

    private static native void detect_1(long var0, long var2, long var4);

    private static native void detectTextRectangles_0(long var0, long var2, long var4, long var6);

    private static native void detectTextRectangles_1(long var0, long var2, long var4);

    private static native void delete(long var0);
}

