/*
 * Decompiled with CFR 0.152.
 */
package graphql.incremental;

import graphql.ExperimentalApi;
import graphql.GraphQLError;
import graphql.incremental.IncrementalPayload;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@ExperimentalApi
public class StreamPayload
extends IncrementalPayload {
    private final List<Object> items;

    private StreamPayload(List<Object> items, List<Object> path, String label, List<GraphQLError> errors, Map<Object, Object> extensions) {
        super(path, label, errors, extensions);
        this.items = items;
    }

    public <T> @Nullable List<T> getItems() {
        return this.items;
    }

    @Override
    public Map<String, Object> toSpecification() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(super.toSpecification());
        map.put("items", this.items);
        return map;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.items);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StreamPayload that = (StreamPayload)obj;
        return Objects.equals(this.items, that.items);
    }

    public static Builder newStreamedItem() {
        return new Builder();
    }

    public static class Builder
    extends IncrementalPayload.Builder<Builder> {
        private List<Object> items = null;

        public Builder items(List<Object> items) {
            this.items = items;
            return this;
        }

        public Builder from(StreamPayload streamedItem) {
            super.from(streamedItem);
            this.items = streamedItem.items;
            return this;
        }

        public StreamPayload build() {
            return new StreamPayload(this.items, this.path, this.label, this.errors, this.extensions);
        }
    }
}

