/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi;

import java.io.Closeable;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.openqa.selenium.bidi.BiDiSessionStatus;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.Connection;
import org.openqa.selenium.bidi.Event;
import org.openqa.selenium.internal.Require;

public class BiDi
implements Closeable {
    private final Duration timeout;
    private final Connection connection;

    public BiDi(Connection connection, Duration timeout) {
        this.connection = Require.nonNull("WebSocket connection", connection);
        this.timeout = Require.nonNull("WebSocket timeout", timeout);
    }

    @Override
    public void close() {
        this.clearListeners();
        this.disconnectSession();
        this.connection.close();
    }

    public void disconnectSession() {
    }

    public <X> X send(Command<X> command) {
        Require.nonNull("Command to send", command);
        return this.connection.sendAndWait(command, this.timeout);
    }

    public <X> X send(Command<X> command, Duration timeout) {
        Require.nonNull("Command to send", command);
        Require.nonNull("Timeout", timeout);
        return this.connection.sendAndWait(command, timeout);
    }

    public <X> long addListener(Event<X> event, Consumer<X> handler) {
        Require.nonNull("Event to listen for", event);
        Require.nonNull("Handler to call", handler);
        this.send(new Command("session.subscribe", Map.of("events", Collections.singletonList(event.getMethod()))));
        return this.connection.addListener(event, handler);
    }

    public <X> long addListener(String browsingContextId, Event<X> event, Consumer<X> handler) {
        Require.nonNull("Event to listen for", event);
        Require.nonNull("Browsing context id", browsingContextId);
        Require.nonNull("Handler to call", handler);
        this.send(new Command("session.subscribe", Map.of("contexts", Collections.singletonList(browsingContextId), "events", Collections.singletonList(event.getMethod()))));
        return this.connection.addListener(event, handler);
    }

    public <X> long addListener(Set<String> browsingContextIds, Event<X> event, Consumer<X> handler) {
        Require.nonNull("List of browsing context ids", browsingContextIds);
        Require.nonNull("Event to listen for", event);
        Require.nonNull("Handler to call", handler);
        this.send(new Command("session.subscribe", Map.of("contexts", browsingContextIds, "events", Collections.singletonList(event.getMethod()))));
        return this.connection.addListener(event, handler);
    }

    public <X> void clearListener(Event<X> event) {
        Require.nonNull("Event to listen for", event);
        if (this.connection.isEventSubscribed(event)) {
            this.send(new Command("session.unsubscribe", Map.of("events", Collections.singletonList(event.getMethod()))));
            this.connection.clearListener(event);
        }
    }

    public void removeListener(long id) {
        this.connection.removeListener(id);
    }

    public void clearListeners() {
        this.connection.clearListeners();
    }

    public BiDiSessionStatus getBidiSessionStatus() {
        return (BiDiSessionStatus)this.send(new Command("session.status", Collections.emptyMap(), (Type)((Object)BiDiSessionStatus.class)));
    }
}

