/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.client;

import java.util.logging.Logger;
import org.openqa.selenium.docker.client.ApiVersionAdapter;
import org.openqa.selenium.docker.client.V140Adapter;
import org.openqa.selenium.docker.client.V144Adapter;
import org.openqa.selenium.docker.client.V148Adapter;

class AdapterFactory {
    private static final Logger LOG = Logger.getLogger(AdapterFactory.class.getName());

    AdapterFactory() {
    }

    public static ApiVersionAdapter createAdapter(String apiVersion) {
        if (apiVersion == null || apiVersion.trim().isEmpty()) {
            throw new IllegalArgumentException("API version cannot be null or empty");
        }
        if (AdapterFactory.compareVersions(apiVersion, "1.48") >= 0) {
            LOG.fine("Using V148Adapter for API version " + apiVersion);
            return new V148Adapter(apiVersion);
        }
        if (AdapterFactory.compareVersions(apiVersion, "1.44") >= 0) {
            LOG.fine("Using V144Adapter for API version " + apiVersion);
            return new V144Adapter(apiVersion);
        }
        LOG.fine("Using V140Adapter for API version " + apiVersion);
        return new V140Adapter(apiVersion);
    }

    private static int compareVersions(String version1, String version2) {
        int minor2;
        String[] parts1 = version1.split("\\.");
        String[] parts2 = version2.split("\\.");
        int major1 = Integer.parseInt(parts1[0]);
        int minor1 = parts1.length > 1 ? Integer.parseInt(parts1[1]) : 0;
        int major2 = Integer.parseInt(parts2[0]);
        int n = minor2 = parts2.length > 1 ? Integer.parseInt(parts2[1]) : 0;
        if (major1 != major2) {
            return major1 - major2;
        }
        return minor1 - minor2;
    }

    public static boolean supportsMultipleNetworks(String apiVersion) {
        return AdapterFactory.createAdapter(apiVersion).supportsMultipleNetworks();
    }

    public static boolean hasVirtualSizeField(String apiVersion) {
        return AdapterFactory.createAdapter(apiVersion).hasVirtualSizeField();
    }
}

