/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.client;

import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.client.DockerMessages;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;

class StartContainer {
    private final HttpHandler client;
    private final String apiVersion;

    public StartContainer(HttpHandler client, String apiVersion) {
        this.client = Require.nonNull("HTTP client", client);
        this.apiVersion = Require.nonNull("API version", apiVersion);
    }

    public void apply(ContainerId id) {
        Require.nonNull("Container id", id);
        DockerMessages.throwIfNecessary(this.client.execute((HttpRequest)new HttpRequest(HttpMethod.POST, String.format("/v%s/containers/%s/start", this.apiVersion, id)).addHeader("Content-Type", "text/plain")), "Unable to start container: %s", id);
    }
}

