/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.client;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.docker.client.ApiVersionAdapter;

class V144Adapter
implements ApiVersionAdapter {
    private static final Logger LOG = Logger.getLogger(V144Adapter.class.getName());
    private final String apiVersion;

    public V144Adapter(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Override
    public Map<String, Object> adaptImageResponse(Map<String, Object> response) {
        if (response == null) {
            return response;
        }
        HashMap<String, Object> adapted = new HashMap<String, Object>(response);
        if (adapted.containsKey("VirtualSize")) {
            LOG.warning("VirtualSize field found in API v" + this.apiVersion + " response, but this field was removed in v1.44. This may indicate an API version mismatch.");
            adapted.remove("VirtualSize");
        }
        if (!adapted.containsKey("Size")) {
            LOG.warning("Size field missing from image response in API v" + this.apiVersion);
        }
        return adapted;
    }

    @Override
    public Map<String, Object> adaptContainerCreateRequest(Map<String, Object> request) {
        Map endpointsConfig;
        if (request == null) {
            return request;
        }
        HashMap<String, Object> adapted = new HashMap<String, Object>(request);
        Map networkingConfig = (Map)adapted.get("NetworkingConfig");
        if (networkingConfig != null && (endpointsConfig = (Map)networkingConfig.get("EndpointsConfig")) != null && endpointsConfig.size() > 1) {
            LOG.fine("Creating container with " + endpointsConfig.size() + " network endpoints (supported in API v" + this.apiVersion + "+)");
        }
        return adapted;
    }

    @Override
    public Map<String, Object> adaptContainerInspectResponse(Map<String, Object> response) {
        if (response == null) {
            return response;
        }
        HashMap<String, Object> adapted = new HashMap<String, Object>(response);
        Map originalNetworkSettings = (Map)adapted.get("NetworkSettings");
        if (originalNetworkSettings != null) {
            String[] deprecatedFields;
            HashMap networkSettings = new HashMap(originalNetworkSettings);
            adapted.put("NetworkSettings", networkSettings);
            for (String field : deprecatedFields = new String[]{"HairpinMode", "LinkLocalIPv6Address", "LinkLocalIPv6PrefixLen", "SecondaryIPAddresses", "SecondaryIPv6Addresses"}) {
                if (!networkSettings.containsKey(field)) continue;
                LOG.fine("Removing deprecated field '" + field + "' from NetworkSettings (deprecated in API v1.44+)");
                networkSettings.remove(field);
            }
        }
        return adapted;
    }

    @Override
    public boolean supportsMultipleNetworks() {
        return true;
    }

    @Override
    public boolean hasVirtualSizeField() {
        return false;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }
}

