/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.SemanticVersionComparator;
import org.openqa.selenium.grid.data.SlotMatcher;

public class DefaultSlotMatcher
implements SlotMatcher,
Serializable {
    private static final List<String> EXTENSION_CAPABILITIES_PREFIXES = List.of("goog:", "moz:", "ms:", "safari:", "se:");
    public static final List<String> SPECIFIC_RELAY_CAPABILITIES_APP = List.of("appium:app", "appium:appPackage", "appium:bundleId");
    public static final List<String> MANDATORY_CAPABILITIES = List.of("platformName", "browserName", "browserVersion");

    @Override
    public boolean matches(Capabilities stereotype, Capabilities capabilities) {
        if (capabilities.asMap().isEmpty()) {
            return false;
        }
        if (!this.initialMatch(stereotype, capabilities).booleanValue()) {
            return false;
        }
        if (!this.managedDownloadsEnabled(stereotype, capabilities).booleanValue()) {
            return false;
        }
        if (!this.extensionCapabilitiesMatch(stereotype, capabilities).booleanValue()) {
            return false;
        }
        if (!this.platformVersionMatch(stereotype, capabilities).booleanValue()) {
            return false;
        }
        boolean browserNameMatch = capabilities.getBrowserName() == null || capabilities.getBrowserName().isEmpty() || Objects.equals(stereotype.getBrowserName(), capabilities.getBrowserName()) || DefaultSlotMatcher.matchConditionToRemoveCapability(capabilities) != false;
        boolean browserVersionMatch = capabilities.getBrowserVersion() == null || capabilities.getBrowserVersion().isEmpty() || Objects.equals(capabilities.getBrowserVersion(), "stable") || this.browserVersionMatch(stereotype.getBrowserVersion(), capabilities.getBrowserVersion()) || DefaultSlotMatcher.matchConditionToRemoveCapability(capabilities) != false;
        boolean platformNameMatch = capabilities.getPlatformName() == null || Objects.equals((Object)stereotype.getPlatformName(), (Object)capabilities.getPlatformName()) || stereotype.getPlatformName() != null && stereotype.getPlatformName().is(capabilities.getPlatformName());
        return browserNameMatch && browserVersionMatch && platformNameMatch;
    }

    private boolean browserVersionMatch(String stereotype, String capabilities) {
        return new SemanticVersionComparator().compare(stereotype, capabilities) == 0;
    }

    private Boolean initialMatch(Capabilities stereotype, Capabilities capabilities) {
        return stereotype.getCapabilityNames().stream().filter(name -> !name.contains(":")).filter(name -> MANDATORY_CAPABILITIES.stream().noneMatch(mandatory -> mandatory.equalsIgnoreCase((String)name))).map(name -> {
            if (capabilities.getCapability((String)name) instanceof String) {
                return stereotype.getCapability((String)name).toString().equalsIgnoreCase(capabilities.getCapability((String)name).toString());
            }
            return capabilities.getCapability((String)name) == null || Objects.equals(stereotype.getCapability((String)name), capabilities.getCapability((String)name));
        }).reduce(Boolean::logicalAnd).orElse(true);
    }

    private Boolean managedDownloadsEnabled(Capabilities stereotype, Capabilities capabilities) {
        Object raw = capabilities.getCapability("se:downloadsEnabled");
        if (raw == null || !Boolean.parseBoolean(raw.toString())) {
            return true;
        }
        raw = stereotype.getCapability("se:downloadsEnabled");
        return raw != null && Boolean.parseBoolean(raw.toString());
    }

    private Boolean platformVersionMatch(Capabilities stereotype, Capabilities capabilities) {
        return capabilities.getCapabilityNames().stream().filter(name -> name.contains("platformVersion")).map(platformVersionCapName -> Objects.equals(stereotype.getCapability((String)platformVersionCapName), capabilities.getCapability((String)platformVersionCapName))).reduce(Boolean::logicalAnd).orElse(true);
    }

    private Boolean extensionCapabilitiesMatch(Capabilities stereotype, Capabilities capabilities) {
        return stereotype.getCapabilityNames().stream().filter(name -> name.contains(":")).filter(name -> !name.toLowerCase().contains("options")).filter(name -> capabilities.asMap().containsKey(name)).filter(name -> EXTENSION_CAPABILITIES_PREFIXES.stream().noneMatch(name::contains)).map(name -> {
            if (capabilities.getCapability((String)name) instanceof String) {
                return stereotype.getCapability((String)name).toString().equalsIgnoreCase(capabilities.getCapability((String)name).toString());
            }
            return capabilities.getCapability((String)name) == null || Objects.equals(stereotype.getCapability((String)name), capabilities.getCapability((String)name));
        }).reduce(Boolean::logicalAnd).orElse(true);
    }

    public static Boolean matchConditionToRemoveCapability(Capabilities capabilities) {
        return SPECIFIC_RELAY_CAPABILITIES_APP.stream().anyMatch(name -> capabilities.getCapability((String)name) != null && !capabilities.getCapability((String)name).toString().isEmpty());
    }
}

