/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.selector;

import com.google.common.annotations.VisibleForTesting;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.SemanticVersionComparator;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.data.SlotId;
import org.openqa.selenium.grid.data.SlotMatcher;
import org.openqa.selenium.grid.distributor.selector.SlotSelector;
import org.openqa.selenium.internal.Sets;

public class DefaultSlotSelector
implements SlotSelector {
    public static SlotSelector create(Config config) {
        return new DefaultSlotSelector();
    }

    @Override
    public Set<SlotId> selectSlot(Capabilities capabilities, Set<NodeStatus> nodes, SlotMatcher slotMatcher) {
        return nodes.stream().filter(node -> node.hasCapacity(capabilities, slotMatcher) && node.getAvailability() == Availability.UP).sorted(Comparator.comparingLong(this::getNumberOfSupportedBrowsers).thenComparingDouble(NodeStatus::getLoad).thenComparingLong(NodeStatus::getLastSessionCreated).thenComparing(NodeStatus::getBrowserVersion, new SemanticVersionComparator().reversed()).thenComparing(NodeStatus::getNodeId)).flatMap(node -> node.getSlots().stream().filter(slot -> slot.getSession() == null).filter(slot -> slot.isSupporting(capabilities, slotMatcher)).map(Slot::getId)).collect(Sets.toSequencedSet());
    }

    @VisibleForTesting
    long getNumberOfSupportedBrowsers(NodeStatus nodeStatus) {
        return nodeStatus.getSlots().stream().map(slot -> slot.getStereotype().getBrowserName().toLowerCase(Locale.ENGLISH)).distinct().count();
    }
}

