/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Set;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.Browser;

class NamedBrowser
implements Browser {
    private final String name;
    private final Set<String> otherNames;

    protected NamedBrowser(String name, String ... otherNames) {
        this.name = Require.nonNull("Browser name", name);
        this.otherNames = Set.of(otherNames);
    }

    @Override
    public boolean is(String browserName) {
        return Browser.super.is(browserName) || this.otherNames.contains(browserName);
    }

    @Override
    public String browserName() {
        return this.name;
    }

    public final String toString() {
        return this.name;
    }
}

