/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Beta;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.LogCombiner;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.LogLevelMapping;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.remote.ExecuteMethod;

@Beta
public class RemoteLogs
implements Logs {
    private static final String LEVEL = "level";
    private static final String TIMESTAMP = "timestamp";
    private static final String MESSAGE = "message";
    private static final Logger LOG = Logger.getLogger(RemoteLogs.class.getName());
    protected ExecuteMethod executeMethod;
    public static final String TYPE_KEY = "type";
    private final @Nullable LocalLogs localLogs;

    public RemoteLogs(ExecuteMethod executeMethod) {
        this.executeMethod = executeMethod;
        this.localLogs = null;
    }

    @Deprecated(forRemoval=true)
    public RemoteLogs(ExecuteMethod executeMethod, LocalLogs localLogs) {
        this.executeMethod = executeMethod;
        this.localLogs = localLogs;
    }

    @Override
    public LogEntries get(String logType) {
        if ("client".equals(logType)) {
            LOG.warning("LogType.CLIENT is deprecated and not part of the W3C WebDriver specification. Returning empty log entries.");
            if (this.localLogs != null) {
                return this.getLocalEntries(logType);
            }
            return new LogEntries(Collections.emptyList());
        }
        if ("profiler".equals(logType)) {
            LOG.warning("LogType.PROFILER is deprecated and not part of the W3C WebDriver specification. Returning empty log entries.");
            if (this.localLogs != null) {
                LogEntries remoteEntries = new LogEntries(new ArrayList<LogEntry>());
                try {
                    remoteEntries = this.getRemoteEntries(logType);
                }
                catch (WebDriverException e) {
                    LOG.log(Level.WARNING, "Remote profiler logs are not available and have been omitted.", e);
                }
                return LogCombiner.combine(remoteEntries, this.getLocalEntries(logType));
            }
            return new LogEntries(Collections.emptyList());
        }
        if ("server".equals(logType)) {
            LOG.warning("LogType.SERVER is deprecated. Selenium Grid no longer supports server logs. Returning empty log entries.");
            return new LogEntries(Collections.emptyList());
        }
        return this.getRemoteEntries(logType);
    }

    private LogEntries getRemoteEntries(String logType) {
        Object raw = this.executeMethod.execute("getLog", Map.of(TYPE_KEY, logType));
        if (!(raw instanceof List)) {
            throw new UnsupportedCommandException("malformed response to remote logs command");
        }
        List rawList = (List)raw;
        ArrayList<LogEntry> remoteEntries = new ArrayList<LogEntry>(rawList.size());
        for (Map obj : rawList) {
            remoteEntries.add(new LogEntry(LogLevelMapping.toLevel((String)obj.get(LEVEL)), (Long)obj.get(TIMESTAMP), (String)obj.get(MESSAGE)));
        }
        return new LogEntries(remoteEntries);
    }

    @Deprecated(forRemoval=true)
    private LogEntries getLocalEntries(String logType) {
        if (this.localLogs == null) {
            return new LogEntries(Collections.emptyList());
        }
        return this.localLogs.get(logType);
    }

    @Deprecated(forRemoval=true)
    private Set<String> getAvailableLocalLogs() {
        if (this.localLogs == null) {
            return Collections.emptySet();
        }
        return this.localLogs.getAvailableLogTypes();
    }

    @Override
    public Set<String> getAvailableLogTypes() {
        Object raw = this.executeMethod.execute("getAvailableLogTypes", null);
        List rawList = (List)raw;
        LinkedHashSet<String> builder = new LinkedHashSet<String>();
        builder.addAll(rawList);
        builder.addAll(this.getAvailableLocalLogs());
        return Set.copyOf(builder);
    }
}

