/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;

public class BytesContentSupplier
implements Contents.Supplier {
    private final byte[] bytes;
    private boolean closed;

    public BytesContentSupplier(byte[] bytes) {
        this.bytes = Require.nonNull("Bytes to return", bytes, "may be empty", new Object[0]);
    }

    @Override
    public InputStream get() {
        if (this.closed) {
            throw new IllegalStateException("Contents.Supplier has been closed before");
        }
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public long length() {
        if (this.closed) {
            throw new IllegalStateException("Contents.Supplier has been closed before");
        }
        return this.bytes.length;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public String toString() {
        return this.bytes.length < 256 ? new String(this.bytes, StandardCharsets.UTF_8) : String.format("%s bytes: \"%s\"...", this.bytes.length, new String(this.bytes, 0, 256, StandardCharsets.UTF_8));
    }

    @Override
    public String contentAsString(Charset charset) {
        return new String(this.bytes, charset);
    }
}

