package org.openqa.selenium.devtools.v144.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Depending on the concrete errorType, different properties are set.
 */
public class GenericIssueDetails {

    private final org.openqa.selenium.devtools.v144.audits.model.GenericIssueErrorType errorType;

    private final java.util.Optional<org.openqa.selenium.devtools.v144.page.model.FrameId> frameId;

    private final java.util.Optional<org.openqa.selenium.devtools.v144.dom.model.BackendNodeId> violatingNodeId;

    private final java.util.Optional<java.lang.String> violatingNodeAttribute;

    private final java.util.Optional<org.openqa.selenium.devtools.v144.audits.model.AffectedRequest> request;

    public GenericIssueDetails(org.openqa.selenium.devtools.v144.audits.model.GenericIssueErrorType errorType, java.util.Optional<org.openqa.selenium.devtools.v144.page.model.FrameId> frameId, java.util.Optional<org.openqa.selenium.devtools.v144.dom.model.BackendNodeId> violatingNodeId, java.util.Optional<java.lang.String> violatingNodeAttribute, java.util.Optional<org.openqa.selenium.devtools.v144.audits.model.AffectedRequest> request) {
        this.errorType = java.util.Objects.requireNonNull(errorType, "errorType is required");
        this.frameId = frameId;
        this.violatingNodeId = violatingNodeId;
        this.violatingNodeAttribute = violatingNodeAttribute;
        this.request = request;
    }

    /**
     * Issues with the same errorType are aggregated in the frontend.
     */
    public org.openqa.selenium.devtools.v144.audits.model.GenericIssueErrorType getErrorType() {
        return errorType;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v144.page.model.FrameId> getFrameId() {
        return frameId;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v144.dom.model.BackendNodeId> getViolatingNodeId() {
        return violatingNodeId;
    }

    public java.util.Optional<java.lang.String> getViolatingNodeAttribute() {
        return violatingNodeAttribute;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v144.audits.model.AffectedRequest> getRequest() {
        return request;
    }

    private static GenericIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v144.audits.model.GenericIssueErrorType errorType = null;
        java.util.Optional<org.openqa.selenium.devtools.v144.page.model.FrameId> frameId = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v144.dom.model.BackendNodeId> violatingNodeId = java.util.Optional.empty();
        java.util.Optional<java.lang.String> violatingNodeAttribute = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v144.audits.model.AffectedRequest> request = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "errorType":
                    errorType = input.read(org.openqa.selenium.devtools.v144.audits.model.GenericIssueErrorType.class);
                    break;
                case "frameId":
                    frameId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v144.page.model.FrameId.class));
                    break;
                case "violatingNodeId":
                    violatingNodeId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v144.dom.model.BackendNodeId.class));
                    break;
                case "violatingNodeAttribute":
                    violatingNodeAttribute = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "request":
                    request = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v144.audits.model.AffectedRequest.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new GenericIssueDetails(errorType, frameId, violatingNodeId, violatingNodeAttribute, request);
    }
}
