package org.openqa.selenium.devtools.v144.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * This issue warns about improper usage of the <permission> element.
 */
public class PermissionElementIssueDetails {

    private final org.openqa.selenium.devtools.v144.audits.model.PermissionElementIssueType issueType;

    private final java.util.Optional<java.lang.String> type;

    private final java.util.Optional<org.openqa.selenium.devtools.v144.dom.model.BackendNodeId> nodeId;

    private final java.util.Optional<java.lang.Boolean> isWarning;

    private final java.util.Optional<java.lang.String> permissionName;

    private final java.util.Optional<java.lang.String> occluderNodeInfo;

    private final java.util.Optional<java.lang.String> occluderParentNodeInfo;

    private final java.util.Optional<java.lang.String> disableReason;

    public PermissionElementIssueDetails(org.openqa.selenium.devtools.v144.audits.model.PermissionElementIssueType issueType, java.util.Optional<java.lang.String> type, java.util.Optional<org.openqa.selenium.devtools.v144.dom.model.BackendNodeId> nodeId, java.util.Optional<java.lang.Boolean> isWarning, java.util.Optional<java.lang.String> permissionName, java.util.Optional<java.lang.String> occluderNodeInfo, java.util.Optional<java.lang.String> occluderParentNodeInfo, java.util.Optional<java.lang.String> disableReason) {
        this.issueType = java.util.Objects.requireNonNull(issueType, "issueType is required");
        this.type = type;
        this.nodeId = nodeId;
        this.isWarning = isWarning;
        this.permissionName = permissionName;
        this.occluderNodeInfo = occluderNodeInfo;
        this.occluderParentNodeInfo = occluderParentNodeInfo;
        this.disableReason = disableReason;
    }

    public org.openqa.selenium.devtools.v144.audits.model.PermissionElementIssueType getIssueType() {
        return issueType;
    }

    /**
     * The value of the type attribute.
     */
    public java.util.Optional<java.lang.String> getType() {
        return type;
    }

    /**
     * The node ID of the <permission> element.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v144.dom.model.BackendNodeId> getNodeId() {
        return nodeId;
    }

    /**
     * True if the issue is a warning, false if it is an error.
     */
    public java.util.Optional<java.lang.Boolean> getIsWarning() {
        return isWarning;
    }

    /**
     * Fields for message construction:
     * Used for messages that reference a specific permission name
     */
    public java.util.Optional<java.lang.String> getPermissionName() {
        return permissionName;
    }

    /**
     * Used for messages about occlusion
     */
    public java.util.Optional<java.lang.String> getOccluderNodeInfo() {
        return occluderNodeInfo;
    }

    /**
     * Used for messages about occluder's parent
     */
    public java.util.Optional<java.lang.String> getOccluderParentNodeInfo() {
        return occluderParentNodeInfo;
    }

    /**
     * Used for messages about activation disabled reason
     */
    public java.util.Optional<java.lang.String> getDisableReason() {
        return disableReason;
    }

    private static PermissionElementIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v144.audits.model.PermissionElementIssueType issueType = null;
        java.util.Optional<java.lang.String> type = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v144.dom.model.BackendNodeId> nodeId = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> isWarning = java.util.Optional.empty();
        java.util.Optional<java.lang.String> permissionName = java.util.Optional.empty();
        java.util.Optional<java.lang.String> occluderNodeInfo = java.util.Optional.empty();
        java.util.Optional<java.lang.String> occluderParentNodeInfo = java.util.Optional.empty();
        java.util.Optional<java.lang.String> disableReason = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "issueType":
                    issueType = input.read(org.openqa.selenium.devtools.v144.audits.model.PermissionElementIssueType.class);
                    break;
                case "type":
                    type = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "nodeId":
                    nodeId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v144.dom.model.BackendNodeId.class));
                    break;
                case "isWarning":
                    isWarning = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "permissionName":
                    permissionName = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "occluderNodeInfo":
                    occluderNodeInfo = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "occluderParentNodeInfo":
                    occluderParentNodeInfo = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "disableReason":
                    disableReason = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PermissionElementIssueDetails(issueType, type, nodeId, isWarning, permissionName, occluderNodeInfo, occluderParentNodeInfo, disableReason);
    }
}
