package org.openqa.selenium.devtools.v144.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * This issue warns about errors in property rules that lead to property
 * registrations being ignored.
 */
public class PropertyRuleIssueDetails {

    private final org.openqa.selenium.devtools.v144.audits.model.SourceCodeLocation sourceCodeLocation;

    private final org.openqa.selenium.devtools.v144.audits.model.PropertyRuleIssueReason propertyRuleIssueReason;

    private final java.util.Optional<java.lang.String> propertyValue;

    public PropertyRuleIssueDetails(org.openqa.selenium.devtools.v144.audits.model.SourceCodeLocation sourceCodeLocation, org.openqa.selenium.devtools.v144.audits.model.PropertyRuleIssueReason propertyRuleIssueReason, java.util.Optional<java.lang.String> propertyValue) {
        this.sourceCodeLocation = java.util.Objects.requireNonNull(sourceCodeLocation, "sourceCodeLocation is required");
        this.propertyRuleIssueReason = java.util.Objects.requireNonNull(propertyRuleIssueReason, "propertyRuleIssueReason is required");
        this.propertyValue = propertyValue;
    }

    /**
     * Source code position of the property rule.
     */
    public org.openqa.selenium.devtools.v144.audits.model.SourceCodeLocation getSourceCodeLocation() {
        return sourceCodeLocation;
    }

    /**
     * Reason why the property rule was discarded.
     */
    public org.openqa.selenium.devtools.v144.audits.model.PropertyRuleIssueReason getPropertyRuleIssueReason() {
        return propertyRuleIssueReason;
    }

    /**
     * The value of the property rule property that failed to parse
     */
    public java.util.Optional<java.lang.String> getPropertyValue() {
        return propertyValue;
    }

    private static PropertyRuleIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v144.audits.model.SourceCodeLocation sourceCodeLocation = null;
        org.openqa.selenium.devtools.v144.audits.model.PropertyRuleIssueReason propertyRuleIssueReason = null;
        java.util.Optional<java.lang.String> propertyValue = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "sourceCodeLocation":
                    sourceCodeLocation = input.read(org.openqa.selenium.devtools.v144.audits.model.SourceCodeLocation.class);
                    break;
                case "propertyRuleIssueReason":
                    propertyRuleIssueReason = input.read(org.openqa.selenium.devtools.v144.audits.model.PropertyRuleIssueReason.class);
                    break;
                case "propertyValue":
                    propertyValue = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PropertyRuleIssueDetails(sourceCodeLocation, propertyRuleIssueReason, propertyValue);
    }
}
