package org.openqa.selenium.devtools.v144.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Encapsulates the script ancestry and the root script filterlist rule that
 * caused the frame to be labelled as an ad. Only created when `ancestryChain`
 * is not empty.
 */
@org.openqa.selenium.Beta()
public class AdScriptAncestry {

    private final java.util.List<org.openqa.selenium.devtools.v144.page.model.AdScriptId> ancestryChain;

    private final java.util.Optional<java.lang.String> rootScriptFilterlistRule;

    public AdScriptAncestry(java.util.List<org.openqa.selenium.devtools.v144.page.model.AdScriptId> ancestryChain, java.util.Optional<java.lang.String> rootScriptFilterlistRule) {
        this.ancestryChain = java.util.Objects.requireNonNull(ancestryChain, "ancestryChain is required");
        this.rootScriptFilterlistRule = rootScriptFilterlistRule;
    }

    /**
     * A chain of `AdScriptId`s representing the ancestry of an ad script that
     * led to the creation of a frame. The chain is ordered from the script
     * itself (lower level) up to its root ancestor that was flagged by
     * filterlist.
     */
    public java.util.List<org.openqa.selenium.devtools.v144.page.model.AdScriptId> getAncestryChain() {
        return ancestryChain;
    }

    /**
     * The filterlist rule that caused the root (last) script in
     * `ancestryChain` to be ad-tagged. Only populated if the rule is
     * available.
     */
    public java.util.Optional<java.lang.String> getRootScriptFilterlistRule() {
        return rootScriptFilterlistRule;
    }

    private static AdScriptAncestry fromJson(JsonInput input) {
        java.util.List<org.openqa.selenium.devtools.v144.page.model.AdScriptId> ancestryChain = null;
        java.util.Optional<java.lang.String> rootScriptFilterlistRule = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "ancestryChain":
                    ancestryChain = input.readArray(org.openqa.selenium.devtools.v144.page.model.AdScriptId.class);
                    break;
                case "rootScriptFilterlistRule":
                    rootScriptFilterlistRule = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AdScriptAncestry(ancestryChain, rootScriptFilterlistRule);
    }
}
