package org.openqa.selenium.devtools.v143.bluetoothemulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Event for when a descriptor operation of |type| to the descriptor
 * respresented by |descriptorId| happened. |data| is expected to exist when
 * |type| is write.
 */
public class DescriptorOperationReceived {

    private final java.lang.String descriptorId;

    private final org.openqa.selenium.devtools.v143.bluetoothemulation.model.DescriptorOperationType type;

    private final java.util.Optional<java.lang.String> data;

    public DescriptorOperationReceived(java.lang.String descriptorId, org.openqa.selenium.devtools.v143.bluetoothemulation.model.DescriptorOperationType type, java.util.Optional<java.lang.String> data) {
        this.descriptorId = java.util.Objects.requireNonNull(descriptorId, "descriptorId is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.data = data;
    }

    public java.lang.String getDescriptorId() {
        return descriptorId;
    }

    public org.openqa.selenium.devtools.v143.bluetoothemulation.model.DescriptorOperationType getType() {
        return type;
    }

    public java.util.Optional<java.lang.String> getData() {
        return data;
    }

    private static DescriptorOperationReceived fromJson(JsonInput input) {
        java.lang.String descriptorId = null;
        org.openqa.selenium.devtools.v143.bluetoothemulation.model.DescriptorOperationType type = null;
        java.util.Optional<java.lang.String> data = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "descriptorId":
                    descriptorId = input.nextString();
                    break;
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v143.bluetoothemulation.model.DescriptorOperationType.class);
                    break;
                case "data":
                    data = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DescriptorOperationReceived(descriptorId, type, data);
    }
}
