package org.openqa.selenium.devtools.v143.bluetoothemulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Event for when a GATT operation of |type| to the peripheral with |address|
 * happened.
 */
public class GattOperationReceived {

    private final java.lang.String address;

    private final org.openqa.selenium.devtools.v143.bluetoothemulation.model.GATTOperationType type;

    public GattOperationReceived(java.lang.String address, org.openqa.selenium.devtools.v143.bluetoothemulation.model.GATTOperationType type) {
        this.address = java.util.Objects.requireNonNull(address, "address is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
    }

    public java.lang.String getAddress() {
        return address;
    }

    public org.openqa.selenium.devtools.v143.bluetoothemulation.model.GATTOperationType getType() {
        return type;
    }

    private static GattOperationReceived fromJson(JsonInput input) {
        java.lang.String address = null;
        org.openqa.selenium.devtools.v143.bluetoothemulation.model.GATTOperationType type = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "address":
                    address = input.nextString();
                    break;
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v143.bluetoothemulation.model.GATTOperationType.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new GattOperationReceived(address, type);
    }
}
