package org.openqa.selenium.devtools.v143.fedcm;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * This domain allows interacting with the FedCM dialog.
 */
@Beta()
public class FedCm {

    public static Command<Void> enable(java.util.Optional<java.lang.Boolean> disableRejectionDelay) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        disableRejectionDelay.ifPresent(p -> params.put("disableRejectionDelay", p));
        return new Command<>("FedCm.enable", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("FedCm.disable", Map.copyOf(params));
    }

    public static Command<Void> selectAccount(java.lang.String dialogId, java.lang.Integer accountIndex) {
        java.util.Objects.requireNonNull(dialogId, "dialogId is required");
        java.util.Objects.requireNonNull(accountIndex, "accountIndex is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("dialogId", dialogId);
        params.put("accountIndex", accountIndex);
        return new Command<>("FedCm.selectAccount", Map.copyOf(params));
    }

    public static Command<Void> clickDialogButton(java.lang.String dialogId, org.openqa.selenium.devtools.v143.fedcm.model.DialogButton dialogButton) {
        java.util.Objects.requireNonNull(dialogId, "dialogId is required");
        java.util.Objects.requireNonNull(dialogButton, "dialogButton is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("dialogId", dialogId);
        params.put("dialogButton", dialogButton);
        return new Command<>("FedCm.clickDialogButton", Map.copyOf(params));
    }

    public static Command<Void> openUrl(java.lang.String dialogId, java.lang.Integer accountIndex, org.openqa.selenium.devtools.v143.fedcm.model.AccountUrlType accountUrlType) {
        java.util.Objects.requireNonNull(dialogId, "dialogId is required");
        java.util.Objects.requireNonNull(accountIndex, "accountIndex is required");
        java.util.Objects.requireNonNull(accountUrlType, "accountUrlType is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("dialogId", dialogId);
        params.put("accountIndex", accountIndex);
        params.put("accountUrlType", accountUrlType);
        return new Command<>("FedCm.openUrl", Map.copyOf(params));
    }

    public static Command<Void> dismissDialog(java.lang.String dialogId, java.util.Optional<java.lang.Boolean> triggerCooldown) {
        java.util.Objects.requireNonNull(dialogId, "dialogId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("dialogId", dialogId);
        triggerCooldown.ifPresent(p -> params.put("triggerCooldown", p));
        return new Command<>("FedCm.dismissDialog", Map.copyOf(params));
    }

    /**
     * Resets the cooldown time, if any, to allow the next FedCM call to show
     * a dialog even if one was recently dismissed by the user.
     */
    public static Command<Void> resetCooldown() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("FedCm.resetCooldown", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v143.fedcm.model.DialogShown> dialogShown() {
        return new Event<>("FedCm.dialogShown", input -> input.read(org.openqa.selenium.devtools.v143.fedcm.model.DialogShown.class));
    }

    public static Event<java.lang.String> dialogClosed() {
        return new Event<>("FedCm.dialogClosed", ConverterFunctions.map("dialogId", java.lang.String.class));
    }
}
