package org.openqa.selenium.devtools.v143.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Enum of auction events.
 */
public enum InterestGroupAuctionEventType {

    STARTED("started"), CONFIGRESOLVED("configResolved");

    private String value;

    InterestGroupAuctionEventType(String value) {
        this.value = value;
    }

    public static InterestGroupAuctionEventType fromString(String s) {
        return java.util.Arrays.stream(InterestGroupAuctionEventType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within InterestGroupAuctionEventType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static InterestGroupAuctionEventType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
