package org.jcodec.codecs.mpa;

import org.jcodec.common.io.VLC;
import org.jcodec.common.io.VLCBuilder;

/**
 * This class is part of JCodec ( www.jcodec.org ) This software is distributed
 * under FreeBSD License
 * 
 * Constants for MPEG1 layer 2 and 3
 * 
 * @author The JCodec project
 */
class MpaConst {
    static final int MPEG2_LSF       = 0;
    static final int MPEG1           = 1;
    static final int MPEG25_LSF      = 2;

    static final int STEREO          = 0;
    static final int JOINT_STEREO    = 1;
    static final int DUAL_CHANNEL    = 2;
    static final int SINGLE_CHANNEL  = 3;
    static final int SAMPLE_FREQ_48K = 1;
    static final int SAMPLE_FREQ_32K = 2;
    
    static final int[][] frequencies = {
        { 22050, 24000, 16000, 1 },
        { 44100, 48000, 32000, 1 },
        { 11025, 12000,  8000, 1 } 
    };

    static final int bitrates[][][] = {{
        { 0, 32000, 48000, 56000,  64000,  80000,  96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000, 0 },
        { 0,  8000, 16000, 24000,  32000,  40000,  48000,  56000,  64000,  80000,  96000, 112000, 128000, 144000, 160000, 0 },
        { 0,  8000, 16000, 24000,  32000,  40000,  48000,  56000,  64000,  80000,  96000, 112000, 128000, 144000, 160000, 0 }
    }, {
        { 0, 32000, 64000, 96000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 352000, 384000, 416000, 448000, 0 },
        { 0, 32000, 48000, 56000,  64000,  80000,  96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 0 },
        { 0, 32000, 40000, 48000,  56000,  64000,  80000,  96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 0 }
    }, {
        { 0, 32000, 48000, 56000,  64000,  80000,  96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000, 0 },
        { 0,  8000, 16000, 24000,  32000,  40000,  48000,  56000,  64000,  80000,  96000, 112000, 128000, 144000, 160000, 0 },
        { 0,  8000, 16000, 24000,  32000,  40000,  48000,  56000,  64000,  80000,  96000, 112000, 128000, 144000, 160000, 0 }
    }};

    static int[][] sfbLong = {
        { 0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396,
                464, 522, 576 },
        { 0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 114, 136, 162, 194, 232, 278, 330, 394,
                464, 540, 576 },
        { 0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396,
                464, 522, 576 },
        { 0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 52, 62, 74, 90, 110, 134, 162, 196, 238, 288, 342,
                418, 576 },
        { 0, 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 60, 72, 88, 106, 128, 156, 190, 230, 276, 330,
                384, 576 },
        { 0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 54, 66, 82, 102, 126, 156, 194, 240, 296, 364, 448,
                550, 576 },
        { 0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396,
                464, 522, 576 },
        { 0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396,
                464, 522, 576 },
        { 0, 12, 24, 36, 48, 60, 72, 88, 108, 132, 160, 192, 232, 280, 336, 400, 476, 566, 568,
                570, 572, 574, 576 }
    };
    static int[][] sfbShort = {
            { 0, 4, 8, 12, 18, 24, 32, 42, 56, 74, 100, 132, 174, 192 },
            { 0, 4, 8, 12, 18, 26, 36, 48, 62, 80, 104, 136, 180, 192 },
            { 0, 4, 8, 12, 18, 26, 36, 48, 62, 80, 104, 134, 174, 192 },
            { 0, 4, 8, 12, 16, 22, 30, 40, 52, 66, 84, 106, 136, 192 },
            { 0, 4, 8, 12, 16, 22, 28, 38, 50, 64, 80, 100, 126, 192 },
            { 0, 4, 8, 12, 16, 22, 30, 42, 58, 78, 104, 138, 180, 192 },
            { 0, 4, 8, 12, 18, 26, 36, 48, 62, 80, 104, 134, 174, 192 },
            { 0, 4, 8, 12, 18, 26, 36, 48, 62, 80, 104, 134, 174, 192 },
            { 0, 8, 16, 24, 36, 52, 72, 96, 124, 160, 162, 164, 166, 192 }
    };

    static final int scaleFactorLen[][] = { { 0, 0, 0, 0, 3, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4 },
            { 0, 1, 2, 3, 0, 1, 2, 3, 1, 2, 3, 1, 2, 3, 2, 3 } };

    static final int pretab[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 3, 3, 3, 2, 0 };

    static final float quantizerTab[] = { 1.0000000000E+00f, 7.0710678119E-01f, 5.0000000000E-01f,
            3.5355339059E-01f, 2.5000000000E-01f, 1.7677669530E-01f, 1.2500000000E-01f, 8.8388347648E-02f,
            6.2500000000E-02f, 4.4194173824E-02f, 3.1250000000E-02f, 2.2097086912E-02f, 1.5625000000E-02f,
            1.1048543456E-02f, 7.8125000000E-03f, 5.5242717280E-03f, 3.9062500000E-03f, 2.7621358640E-03f,
            1.9531250000E-03f, 1.3810679320E-03f, 9.7656250000E-04f, 6.9053396600E-04f, 4.8828125000E-04f,
            3.4526698300E-04f, 2.4414062500E-04f, 1.7263349150E-04f, 1.2207031250E-04f, 8.6316745750E-05f,
            6.1035156250E-05f, 4.3158372875E-05f, 3.0517578125E-05f, 2.1579186438E-05f, 1.5258789062E-05f,
            1.0789593219E-05f, 7.6293945312E-06f, 5.3947966094E-06f, 3.8146972656E-06f, 2.6973983047E-06f,
            1.9073486328E-06f, 1.3486991523E-06f, 9.5367431641E-07f, 6.7434957617E-07f, 4.7683715820E-07f,
            3.3717478809E-07f, 2.3841857910E-07f, 1.6858739404E-07f, 1.1920928955E-07f, 8.4293697022E-08f,
            5.9604644775E-08f, 4.2146848511E-08f, 2.9802322388E-08f, 2.1073424255E-08f, 1.4901161194E-08f,
            1.0536712128E-08f, 7.4505805969E-09f, 5.2683560639E-09f, 3.7252902985E-09f, 2.6341780319E-09f,
            1.8626451492E-09f, 1.3170890160E-09f, 9.3132257462E-10f, 6.5854450798E-10f, 4.6566128731E-10f,
            3.2927225399E-10f };

    static private float[] create_t_43() {
        float[] t43 = new float[8192];
        final double d43 = (4.0 / 3.0);

        for (int i = 0; i < 8192; i++) {
            t43[i] = (float) Math.pow(i, d43);
        }
        return t43;
    }

    static final float power43Tab[] = create_t_43();

    static final float intensityOffset[][] = {
            { 1.0000000000E+00f, 8.4089641526E-01f, 7.0710678119E-01f, 5.9460355751E-01f, 5.0000000001E-01f,
                    4.2044820763E-01f, 3.5355339060E-01f, 2.9730177876E-01f, 2.5000000001E-01f, 2.1022410382E-01f,
                    1.7677669530E-01f, 1.4865088938E-01f, 1.2500000000E-01f, 1.0511205191E-01f, 8.8388347652E-02f,
                    7.4325444691E-02f, 6.2500000003E-02f, 5.2556025956E-02f, 4.4194173826E-02f, 3.7162722346E-02f,
                    3.1250000002E-02f, 2.6278012978E-02f, 2.2097086913E-02f, 1.8581361173E-02f, 1.5625000001E-02f,
                    1.3139006489E-02f, 1.1048543457E-02f, 9.2906805866E-03f, 7.8125000006E-03f, 6.5695032447E-03f,
                    5.5242717285E-03f, 4.6453402934E-03f },
            { 1.0000000000E+00f, 7.0710678119E-01f, 5.0000000000E-01f, 3.5355339060E-01f, 2.5000000000E-01f,
                    1.7677669530E-01f, 1.2500000000E-01f, 8.8388347650E-02f, 6.2500000001E-02f, 4.4194173825E-02f,
                    3.1250000001E-02f, 2.2097086913E-02f, 1.5625000000E-02f, 1.1048543456E-02f, 7.8125000002E-03f,
                    5.5242717282E-03f, 3.9062500001E-03f, 2.7621358641E-03f, 1.9531250001E-03f, 1.3810679321E-03f,
                    9.7656250004E-04f, 6.9053396603E-04f, 4.8828125002E-04f, 3.4526698302E-04f, 2.4414062501E-04f,
                    1.7263349151E-04f, 1.2207031251E-04f, 8.6316745755E-05f, 6.1035156254E-05f, 4.3158372878E-05f,
                    3.0517578127E-05f, 2.1579186439E-05f } };

    static final float TAN12[] = { 0.0f, 0.26794919f, 0.57735027f, 1.0f, 1.73205081f, 3.73205081f, 9.9999999e10f,
            -3.73205081f, -1.73205081f, -1.0f, -0.57735027f, -0.26794919f, 0.0f, 0.26794919f, 0.57735027f, 1.0f };

    static int[] ll0 = { 0, 6, 11, 16, 21 };
    static int[] ss0 = { 0, 6, 12 };
    static class Sftable {
        int[] l;
        int[] s;

        Sftable(int[] thel, int[] thes) {
            l = thel;
            s = thes;
        }
    }
    static Sftable sftable = new Sftable(ll0, ss0);

    static final float cs[] = { 0.857492925712f, 0.881741997318f, 0.949628649103f, 0.983314592492f, 0.995517816065f,
            0.999160558175f, 0.999899195243f, 0.999993155067f };

    static final float ca[] = { -0.5144957554270f, -0.4717319685650f, -0.3133774542040f, -0.1819131996110f,
            -0.0945741925262f, -0.0409655828852f, -0.0141985685725f, -0.00369997467375f };

    static final float win[][] = {
            { -1.6141214951E-02f, -5.3603178919E-02f, -1.0070713296E-01f, -1.6280817573E-01f, -4.9999999679E-01f,
                    -3.8388735032E-01f, -6.2061144372E-01f, -1.1659756083E+00f, -3.8720752656E+00f, -4.2256286556E+00f,
                    -1.5195289984E+00f, -9.7416483388E-01f, -7.3744074053E-01f, -1.2071067773E+00f, -5.1636156596E-01f,
                    -4.5426052317E-01f, -4.0715656898E-01f, -3.6969460527E-01f, -3.3876269197E-01f, -3.1242222492E-01f,
                    -2.8939587111E-01f, -2.6880081906E-01f, -5.0000000266E-01f, -2.3251417468E-01f, -2.1596714708E-01f,
                    -2.0004979098E-01f, -1.8449493497E-01f, -1.6905846094E-01f, -1.5350360518E-01f, -1.3758624925E-01f,
                    -1.2103922149E-01f, -2.0710679058E-01f, -8.4752577594E-02f, -6.4157525656E-02f, -4.1131172614E-02f,
                    -1.4790705759E-02f },

            { -1.6141214951E-02f, -5.3603178919E-02f, -1.0070713296E-01f, -1.6280817573E-01f, -4.9999999679E-01f,
                    -3.8388735032E-01f, -6.2061144372E-01f, -1.1659756083E+00f, -3.8720752656E+00f, -4.2256286556E+00f,
                    -1.5195289984E+00f, -9.7416483388E-01f, -7.3744074053E-01f, -1.2071067773E+00f, -5.1636156596E-01f,
                    -4.5426052317E-01f, -4.0715656898E-01f, -3.6969460527E-01f, -3.3908542600E-01f, -3.1511810350E-01f,
                    -2.9642226150E-01f, -2.8184548650E-01f, -5.4119610000E-01f, -2.6213228100E-01f, -2.5387916537E-01f,
                    -2.3296291359E-01f, -1.9852728987E-01f, -1.5233534808E-01f, -9.6496400054E-02f, -3.3423828516E-02f,
                    0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f,
                    0.0000000000E+00f },

            { -4.8300800645E-02f, -1.5715656932E-01f, -2.8325045177E-01f, -4.2953747763E-01f, -1.2071067795E+00f,
                    -8.2426483178E-01f, -1.1451749106E+00f, -1.7695290101E+00f, -4.5470225061E+00f, -3.4890531002E+00f,
                    -7.3296292804E-01f, -1.5076514758E-01f, 0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f,
                    0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f,
                    0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f,
                    0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f,
                    0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f,
                    0.0000000000E+00f },

            { 0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f, 0.0000000000E+00f,
                    0.0000000000E+00f, -1.5076513660E-01f, -7.3296291107E-01f, -3.4890530566E+00f, -4.5470224727E+00f,
                    -1.7695290031E+00f, -1.1451749092E+00f, -8.3137738100E-01f, -1.3065629650E+00f, -5.4142014250E-01f,
                    -4.6528974900E-01f, -4.1066990750E-01f, -3.7004680800E-01f, -3.3876269197E-01f, -3.1242222492E-01f,
                    -2.8939587111E-01f, -2.6880081906E-01f, -5.0000000266E-01f, -2.3251417468E-01f, -2.1596714708E-01f,
                    -2.0004979098E-01f, -1.8449493497E-01f, -1.6905846094E-01f, -1.5350360518E-01f, -1.3758624925E-01f,
                    -1.2103922149E-01f, -2.0710679058E-01f, -8.4752577594E-02f, -6.4157525656E-02f, -4.1131172614E-02f,
                    -1.4790705759E-02f } };

    static final int numberOfScaleFactors[][][] = {
            { {  6,  5, 5, 5 }, {  9,  9,  9, 9 }, {  6,  9,  9, 9 } },
            { {  6,  5, 7, 3 }, {  9,  9, 12, 6 }, {  6,  9, 12, 6 } },
            { { 11, 10, 0, 0 }, { 18, 18,  0, 0 }, { 15, 18,  0, 0 } },
            { {  7,  7, 7, 0 }, { 12, 12, 12, 0 }, {  6, 15, 12, 0 } },
            { {  6,  6, 6, 3 }, { 12,  9,  9, 6 }, {  6, 12,  9, 6 } },
            { {  8,  8, 5, 0 }, { 15, 12,  9, 0 }, {  6, 18,  9, 0 } } 
    };

    static final float[] dp = new float[] {
             0f,          -4.42505E-4f,   0.003250122f, -0.007003784f,  0.031082153f, -0.07862854f,  0.10031128f,  -0.57203674f,
             1.144989f,    0.57203674f,   0.10031128f,   0.07862854f,   0.031082153f,  0.007003784f, 0.003250122f,  4.42505E-4f,
            -1.5259E-5f,  -4.73022E-4f,   0.003326416f, -0.007919312f,  0.030517578f, -0.08418274f,  0.090927124f, -0.6002197f,
             1.1442871f,   0.54382324f,   0.1088562f,    0.07305908f,   0.03147888f,   0.006118774f, 0.003173828f,  3.96729E-4f,
            -1.5259E-5f,  -5.34058E-4f,   0.003387451f, -0.008865356f,  0.029785156f, -0.08970642f,  0.08068848f,  -0.6282959f,
             1.1422119f,   0.51560974f,   0.11657715f,   0.06752014f,   0.03173828f,   0.0052948f,   0.003082275f,  3.66211E-4f,
            -1.5259E-5f,  -5.79834E-4f,   0.003433228f, -0.009841919f,  0.028884888f, -0.09516907f,  0.06959534f,  -0.6562195f,
             1.1387634f,   0.48747253f,   0.12347412f,   0.06199646f,   0.031845093f,  0.004486084f, 0.002990723f,  3.20435E-4f,
            -1.5259E-5f,  -6.2561E-4f,    0.003463745f, -0.010848999f,  0.027801514f, -0.10054016f,  0.057617188f, -0.6839142f,
             1.1339264f,   0.45947266f,   0.12957764f,   0.056533813f,  0.031814575f,  0.003723145f, 0.00289917f,   2.89917E-4f,
            -1.5259E-5f,  -6.86646E-4f,   0.003479004f, -0.011886597f,  0.026535034f, -0.1058197f,   0.044784546f, -0.71131897f,
             1.1277466f,   0.43165588f,   0.1348877f,    0.051132202f,  0.031661987f,  0.003005981f, 0.002792358f,  2.59399E-4f,
            -1.5259E-5f,  -7.47681E-4f,   0.003479004f, -0.012939453f,  0.02508545f,  -0.110946655f, 0.031082153f, -0.7383728f,
             1.120224f,    0.40408325f,   0.13945007f,   0.045837402f,  0.03138733f,   0.002334595f, 0.002685547f,  2.44141E-4f,
            -3.0518E-5f,  -8.08716E-4f,   0.003463745f, -0.014022827f,  0.023422241f, -0.11592102f,  0.01651001f,  -0.7650299f,
             1.1113739f,   0.37680054f,   0.14326477f,   0.040634155f,  0.03100586f,   0.001693726f, 0.002578735f,  2.13623E-4f,
            -3.0518E-5f,  -8.8501E-4f,    0.003417969f, -0.01512146f,   0.021575928f, -0.12069702f,  0.001068115f, -0.791214f,
             1.1012115f,   0.34986877f,   0.1463623f,    0.03555298f,   0.030532837f,  0.001098633f, 0.002456665f,  1.98364E-4f,
            -3.0518E-5f,  -9.61304E-4f,   0.003372192f, -0.016235352f,  0.01953125f,  -0.1252594f,  -0.015228271f, -0.816864f,
             1.0897827f,   0.32331848f,   0.1487732f,    0.03060913f,   0.029937744f,  5.49316E-4f,  0.002349854f,  1.67847E-4f,
            -3.0518E-5f,  -0.001037598f,  0.00328064f,  -0.017349243f,  0.01725769f,  -0.12956238f, -0.03237915f,  -0.84194946f,
             1.0771179f,   0.2972107f,    0.15049744f,   0.025817871f,  0.029281616f,  3.0518E-5f,   0.002243042f,  1.52588E-4f,
            -4.5776E-5f,  -0.001113892f,  0.003173828f, -0.018463135f,  0.014801025f, -0.1335907f,  -0.050354004f, -0.8663635f,
             1.0632172f,   0.2715912f,    0.15159607f,   0.0211792f,    0.028533936f, -4.42505E-4f,  0.002120972f,  1.37329E-4f,
            -4.5776E-5f,  -0.001205444f,  0.003051758f, -0.019577026f,  0.012115479f, -0.13729858f, -0.06916809f,  -0.89009094f,
             1.0481567f,   0.24650574f,   0.15206909f,   0.016708374f,  0.02772522f,  -8.69751E-4f,  0.00201416f,   1.2207E-4f,
            -6.1035E-5f,  -0.001296997f,  0.002883911f, -0.020690918f,  0.009231567f, -0.14067078f, -0.088775635f, -0.9130554f,
             1.0319366f,   0.22198486f,   0.15196228f,   0.012420654f,  0.02684021f,  -0.001266479f, 0.001907349f,  1.06812E-4f,
            -6.1035E-5f,  -0.00138855f,   0.002700806f, -0.02178955f,   0.006134033f, -0.14367676f, -0.10916138f,  -0.9351959f,
             1.0146179f,   0.19805908f,   0.15130615f,   0.00831604f,   0.025909424f, -0.001617432f, 0.001785278f,  1.06812E-4f,
            -7.6294E-5f,  -0.001480103f,  0.002487183f, -0.022857666f,  0.002822876f, -0.1462555f,  -0.13031006f,  -0.95648193f,
             0.99624634f,  0.17478943f,   0.15011597f,   0.004394531f,  0.024932861f, -0.001937866f, 0.001693726f,  9.1553E-5f,
            -7.6294E-5f,  -0.001586914f,  0.002227783f, -0.023910522f, -6.86646E-4f,  -0.14842224f, -0.15220642f,  -0.9768524f,
             0.9768524f,   0.15220642f,   0.14842224f,   6.86646E-4f,   0.023910522f, -0.002227783f, 0.001586914f,  7.6294E-5f,
            -9.1553E-5f,  -0.001693726f,  0.001937866f, -0.024932861f, -0.004394531f, -0.15011597f, -0.17478943f,  -0.99624634f,
             0.95648193f,  0.13031006f,   0.1462555f,   -0.002822876f,  0.022857666f, -0.002487183f, 0.001480103f,  7.6294E-5f,
            -1.06812E-4f, -0.001785278f,  0.001617432f, -0.025909424f, -0.00831604f,  -0.15130615f, -0.19805908f,  -1.0146179f,
             0.9351959f,   0.10916138f,   0.14367676f,  -0.006134033f,  0.02178955f,  -0.002700806f, 0.00138855f,   6.1035E-5f,
            -1.06812E-4f, -0.001907349f,  0.001266479f, -0.02684021f,  -0.012420654f, -0.15196228f, -0.22198486f,  -1.0319366f,
             0.9130554f,   0.088775635f,  0.14067078f,  -0.009231567f,  0.020690918f, -0.002883911f, 0.001296997f,  6.1035E-5f,
            -1.2207E-4f,  -0.00201416f,   8.69751E-4f,  -0.02772522f,  -0.016708374f, -0.15206909f, -0.24650574f,  -1.0481567f,
             0.89009094f,  0.06916809f,   0.13729858f,  -0.012115479f,  0.019577026f, -0.003051758f, 0.001205444f,  4.5776E-5f,
            -1.37329E-4f, -0.002120972f,  4.42505E-4f,  -0.028533936f, -0.0211792f,   -0.15159607f, -0.2715912f,   -1.0632172f,
             0.8663635f,   0.050354004f,  0.1335907f,   -0.014801025f,  0.018463135f, -0.003173828f, 0.001113892f,  4.5776E-5f,
            -1.52588E-4f, -0.002243042f, -3.0518E-5f,   -0.029281616f, -0.025817871f, -0.15049744f, -0.2972107f,   -1.0771179f,
             0.84194946f,  0.03237915f,   0.12956238f,  -0.01725769f,   0.017349243f, -0.00328064f,  0.001037598f,  3.0518E-5f,
            -1.67847E-4f, -0.002349854f, -5.49316E-4f,  -0.029937744f, -0.03060913f,  -0.1487732f,  -0.32331848f,  -1.0897827f,
             0.816864f,    0.015228271f,  0.1252594f,   -0.01953125f,   0.016235352f, -0.003372192f, 9.61304E-4f,   3.0518E-5f,
            -1.98364E-4f, -0.002456665f, -0.001098633f, -0.030532837f, -0.03555298f,  -0.1463623f,  -0.34986877f,  -1.1012115f,
             0.791214f,   -0.001068115f,  0.12069702f,  -0.021575928f,  0.01512146f,  -0.003417969f, 8.8501E-4f,    3.0518E-5f,
            -2.13623E-4f, -0.002578735f, -0.001693726f, -0.03100586f,  -0.040634155f, -0.14326477f, -0.37680054f,  -1.1113739f,
             0.7650299f,  -0.01651001f,   0.11592102f,  -0.023422241f,  0.014022827f, -0.003463745f, 8.08716E-4f,   3.0518E-5f,
            -2.44141E-4f, -0.002685547f, -0.002334595f, -0.03138733f,  -0.045837402f, -0.13945007f, -0.40408325f,  -1.120224f,
             0.7383728f,  -0.031082153f,  0.110946655f, -0.02508545f,   0.012939453f, -0.003479004f, 7.47681E-4f,   1.5259E-5f,
            -2.59399E-4f, -0.002792358f, -0.003005981f, -0.031661987f, -0.051132202f, -0.1348877f,  -0.43165588f,  -1.1277466f,
             0.71131897f, -0.044784546f,  0.1058197f,   -0.026535034f,  0.011886597f, -0.003479004f, 6.86646E-4f,   1.5259E-5f,
            -2.89917E-4f, -0.00289917f,  -0.003723145f, -0.031814575f, -0.056533813f, -0.12957764f, -0.45947266f,  -1.1339264f,
             0.6839142f,  -0.057617188f,  0.10054016f,  -0.027801514f,  0.010848999f, -0.003463745f, 6.2561E-4f,    1.5259E-5f,
            -3.20435E-4f, -0.002990723f, -0.004486084f, -0.031845093f, -0.06199646f,  -0.12347412f, -0.48747253f,  -1.1387634f,
             0.6562195f,  -0.06959534f,   0.09516907f,  -0.028884888f,  0.009841919f, -0.003433228f, 5.79834E-4f,   1.5259E-5f,
            -3.66211E-4f, -0.003082275f, -0.0052948f,   -0.03173828f,  -0.06752014f,  -0.11657715f, -0.51560974f,  -1.1422119f,
             0.6282959f,  -0.08068848f,   0.08970642f,  -0.029785156f,  0.008865356f, -0.003387451f, 5.34058E-4f,   1.5259E-5f,
            -3.96729E-4f, -0.003173828f, -0.006118774f, -0.03147888f,  -0.07305908f,  -0.1088562f,  -0.54382324f,  -1.1442871f,
             0.6002197f,  -0.090927124f,  0.08418274f,  -0.030517578f,  0.007919312f, -0.003326416f, 4.73022E-4f,   1.5259E-5f
    };
    
    static final float grouping5Bits[] = new float[] { -2.0f / 3.0f, -2.0f / 3.0f, -2.0f / 3.0f, 0.0f, -2.0f / 3.0f,
            -2.0f / 3.0f, 2.0f / 3.0f, -2.0f / 3.0f, -2.0f / 3.0f, -2.0f / 3.0f, 0.0f, -2.0f / 3.0f, 0.0f, 0.0f,
            -2.0f / 3.0f, 2.0f / 3.0f, 0.0f, -2.0f / 3.0f, -2.0f / 3.0f, 2.0f / 3.0f, -2.0f / 3.0f, 0.0f, 2.0f / 3.0f,
            -2.0f / 3.0f, 2.0f / 3.0f, 2.0f / 3.0f, -2.0f / 3.0f, -2.0f / 3.0f, -2.0f / 3.0f, 0.0f, 0.0f, -2.0f / 3.0f,
            0.0f, 2.0f / 3.0f, -2.0f / 3.0f, 0.0f, -2.0f / 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f / 3.0f, 0.0f, 0.0f,
            -2.0f / 3.0f, 2.0f / 3.0f, 0.0f, 0.0f, 2.0f / 3.0f, 0.0f, 2.0f / 3.0f, 2.0f / 3.0f, 0.0f, -2.0f / 3.0f,
            -2.0f / 3.0f, 2.0f / 3.0f, 0.0f, -2.0f / 3.0f, 2.0f / 3.0f, 2.0f / 3.0f, -2.0f / 3.0f, 2.0f / 3.0f,
            -2.0f / 3.0f, 0.0f, 2.0f / 3.0f, 0.0f, 0.0f, 2.0f / 3.0f, 2.0f / 3.0f, 0.0f, 2.0f / 3.0f, -2.0f / 3.0f,
            2.0f / 3.0f, 2.0f / 3.0f, 0.0f, 2.0f / 3.0f, 2.0f / 3.0f, 2.0f / 3.0f, 2.0f / 3.0f, 2.0f / 3.0f };

    static final float grouping7Bits[] = new float[] { -0.8f, -0.8f, -0.8f, -0.4f, -0.8f, -0.8f, 0.0f, -0.8f, -0.8f,
            0.4f, -0.8f, -0.8f, 0.8f, -0.8f, -0.8f, -0.8f, -0.4f, -0.8f, -0.4f, -0.4f, -0.8f, 0.0f, -0.4f, -0.8f, 0.4f,
            -0.4f, -0.8f, 0.8f, -0.4f, -0.8f, -0.8f, 0.0f, -0.8f, -0.4f, 0.0f, -0.8f, 0.0f, 0.0f, -0.8f, 0.4f, 0.0f,
            -0.8f, 0.8f, 0.0f, -0.8f, -0.8f, 0.4f, -0.8f, -0.4f, 0.4f, -0.8f, 0.0f, 0.4f, -0.8f, 0.4f, 0.4f, -0.8f,
            0.8f, 0.4f, -0.8f, -0.8f, 0.8f, -0.8f, -0.4f, 0.8f, -0.8f, 0.0f, 0.8f, -0.8f, 0.4f, 0.8f, -0.8f, 0.8f, 0.8f,
            -0.8f, -0.8f, -0.8f, -0.4f, -0.4f, -0.8f, -0.4f, 0.0f, -0.8f, -0.4f, 0.4f, -0.8f, -0.4f, 0.8f, -0.8f, -0.4f,
            -0.8f, -0.4f, -0.4f, -0.4f, -0.4f, -0.4f, 0.0f, -0.4f, -0.4f, 0.4f, -0.4f, -0.4f, 0.8f, -0.4f, -0.4f, -0.8f,
            0.0f, -0.4f, -0.4f, 0.0f, -0.4f, 0.0f, 0.0f, -0.4f, 0.4f, 0.0f, -0.4f, 0.8f, 0.0f, -0.4f, -0.8f, 0.4f,
            -0.4f, -0.4f, 0.4f, -0.4f, 0.0f, 0.4f, -0.4f, 0.4f, 0.4f, -0.4f, 0.8f, 0.4f, -0.4f, -0.8f, 0.8f, -0.4f,
            -0.4f, 0.8f, -0.4f, 0.0f, 0.8f, -0.4f, 0.4f, 0.8f, -0.4f, 0.8f, 0.8f, -0.4f, -0.8f, -0.8f, 0.0f, -0.4f,
            -0.8f, 0.0f, 0.0f, -0.8f, 0.0f, 0.4f, -0.8f, 0.0f, 0.8f, -0.8f, 0.0f, -0.8f, -0.4f, 0.0f, -0.4f, -0.4f,
            0.0f, 0.0f, -0.4f, 0.0f, 0.4f, -0.4f, 0.0f, 0.8f, -0.4f, 0.0f, -0.8f, 0.0f, 0.0f, -0.4f, 0.0f, 0.0f, 0.0f,
            0.0f, 0.0f, 0.4f, 0.0f, 0.0f, 0.8f, 0.0f, 0.0f, -0.8f, 0.4f, 0.0f, -0.4f, 0.4f, 0.0f, 0.0f, 0.4f, 0.0f,
            0.4f, 0.4f, 0.0f, 0.8f, 0.4f, 0.0f, -0.8f, 0.8f, 0.0f, -0.4f, 0.8f, 0.0f, 0.0f, 0.8f, 0.0f, 0.4f, 0.8f,
            0.0f, 0.8f, 0.8f, 0.0f, -0.8f, -0.8f, 0.4f, -0.4f, -0.8f, 0.4f, 0.0f, -0.8f, 0.4f, 0.4f, -0.8f, 0.4f, 0.8f,
            -0.8f, 0.4f, -0.8f, -0.4f, 0.4f, -0.4f, -0.4f, 0.4f, 0.0f, -0.4f, 0.4f, 0.4f, -0.4f, 0.4f, 0.8f, -0.4f,
            0.4f, -0.8f, 0.0f, 0.4f, -0.4f, 0.0f, 0.4f, 0.0f, 0.0f, 0.4f, 0.4f, 0.0f, 0.4f, 0.8f, 0.0f, 0.4f, -0.8f,
            0.4f, 0.4f, -0.4f, 0.4f, 0.4f, 0.0f, 0.4f, 0.4f, 0.4f, 0.4f, 0.4f, 0.8f, 0.4f, 0.4f, -0.8f, 0.8f, 0.4f,
            -0.4f, 0.8f, 0.4f, 0.0f, 0.8f, 0.4f, 0.4f, 0.8f, 0.4f, 0.8f, 0.8f, 0.4f, -0.8f, -0.8f, 0.8f, -0.4f, -0.8f,
            0.8f, 0.0f, -0.8f, 0.8f, 0.4f, -0.8f, 0.8f, 0.8f, -0.8f, 0.8f, -0.8f, -0.4f, 0.8f, -0.4f, -0.4f, 0.8f, 0.0f,
            -0.4f, 0.8f, 0.4f, -0.4f, 0.8f, 0.8f, -0.4f, 0.8f, -0.8f, 0.0f, 0.8f, -0.4f, 0.0f, 0.8f, 0.0f, 0.0f, 0.8f,
            0.4f, 0.0f, 0.8f, 0.8f, 0.0f, 0.8f, -0.8f, 0.4f, 0.8f, -0.4f, 0.4f, 0.8f, 0.0f, 0.4f, 0.8f, 0.4f, 0.4f,
            0.8f, 0.8f, 0.4f, 0.8f, -0.8f, 0.8f, 0.8f, -0.4f, 0.8f, 0.8f, 0.0f, 0.8f, 0.8f, 0.4f, 0.8f, 0.8f, 0.8f,
            0.8f, 0.8f };

    static final float grouping10Bits[] = { -8.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f,
            -8.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f, 0.0f,
            -8.0f / 9.0f, -8.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f,
            -8.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f,
            -8.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f,
            -6.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f, 0.0f, -6.0f / 9.0f, -8.0f / 9.0f,
            2.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f,
            -8.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f,
            -6.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f,
            -4.0f / 9.0f, -8.0f / 9.0f, 0.0f, -4.0f / 9.0f, -8.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f,
            4.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f,
            -8.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f, -8.0f / 9.0f,
            -4.0f / 9.0f, -2.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f, -2.0f / 9.0f, -8.0f / 9.0f, 0.0f, -2.0f / 9.0f,
            -8.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f,
            -2.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f, 0.0f, -8.0f / 9.0f,
            -6.0f / 9.0f, 0.0f, -8.0f / 9.0f, -4.0f / 9.0f, 0.0f, -8.0f / 9.0f, -2.0f / 9.0f, 0.0f, -8.0f / 9.0f, 0.0f,
            0.0f, -8.0f / 9.0f, 2.0f / 9.0f, 0.0f, -8.0f / 9.0f, 4.0f / 9.0f, 0.0f, -8.0f / 9.0f, 6.0f / 9.0f, 0.0f,
            -8.0f / 9.0f, 8.0f / 9.0f, 0.0f, -8.0f / 9.0f, -8.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f,
            2.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f,
            0.0f, 2.0f / 9.0f, -8.0f / 9.0f, 2.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f,
            -8.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f,
            4.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f,
            -2.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f, 0.0f, 4.0f / 9.0f, -8.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f,
            -8.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f,
            4.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f,
            -4.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, 0.0f, 6.0f / 9.0f,
            -8.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f,
            6.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f,
            -6.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f,
            -8.0f / 9.0f, 0.0f, 8.0f / 9.0f, -8.0f / 9.0f, 2.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f,
            8.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f,
            -8.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f, -4.0f / 9.0f,
            -8.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f, 0.0f, -8.0f / 9.0f, -6.0f / 9.0f,
            2.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f,
            -6.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f,
            -6.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f, -4.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f,
            -6.0f / 9.0f, -6.0f / 9.0f, 0.0f, -6.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f,
            4.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f,
            -6.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f, -4.0f / 9.0f, -6.0f / 9.0f,
            -4.0f / 9.0f, -4.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f, -4.0f / 9.0f, -6.0f / 9.0f, 0.0f, -4.0f / 9.0f,
            -6.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f,
            -4.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f,
            -6.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f, -6.0f / 9.0f, -4.0f / 9.0f, -2.0f / 9.0f, -6.0f / 9.0f,
            -2.0f / 9.0f, -2.0f / 9.0f, -6.0f / 9.0f, 0.0f, -2.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f,
            -6.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f,
            -2.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f, 0.0f, -6.0f / 9.0f, -6.0f / 9.0f, 0.0f, -6.0f / 9.0f,
            -4.0f / 9.0f, 0.0f, -6.0f / 9.0f, -2.0f / 9.0f, 0.0f, -6.0f / 9.0f, 0.0f, 0.0f, -6.0f / 9.0f, 2.0f / 9.0f,
            0.0f, -6.0f / 9.0f, 4.0f / 9.0f, 0.0f, -6.0f / 9.0f, 6.0f / 9.0f, 0.0f, -6.0f / 9.0f, 8.0f / 9.0f, 0.0f,
            -6.0f / 9.0f, -8.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f,
            -4.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f, 0.0f, 2.0f / 9.0f,
            -6.0f / 9.0f, 2.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f,
            2.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f,
            -6.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f,
            -6.0f / 9.0f, 0.0f, 4.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f,
            4.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f,
            -8.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f,
            -6.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f, 0.0f, 6.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f,
            6.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f,
            8.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f,
            -6.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f, 0.0f,
            8.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f,
            6.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f,
            -4.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f,
            -2.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f, 0.0f, -8.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f,
            -4.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f,
            -8.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f, -4.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f,
            -4.0f / 9.0f, -4.0f / 9.0f, -6.0f / 9.0f, -4.0f / 9.0f, -2.0f / 9.0f, -6.0f / 9.0f, -4.0f / 9.0f, 0.0f,
            -6.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f,
            -4.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f, -4.0f / 9.0f,
            -8.0f / 9.0f, -4.0f / 9.0f, -4.0f / 9.0f, -6.0f / 9.0f, -4.0f / 9.0f, -4.0f / 9.0f, -4.0f / 9.0f,
            -4.0f / 9.0f, -4.0f / 9.0f, -2.0f / 9.0f, -4.0f / 9.0f, -4.0f / 9.0f, 0.0f, -4.0f / 9.0f, -4.0f / 9.0f,
            2.0f / 9.0f, -4.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f, -4.0f / 9.0f,
            -4.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f, -4.0f / 9.0f,
            -6.0f / 9.0f, -2.0f / 9.0f, -4.0f / 9.0f, -4.0f / 9.0f, -2.0f / 9.0f, -4.0f / 9.0f, -2.0f / 9.0f,
            -2.0f / 9.0f, -4.0f / 9.0f, 0.0f, -2.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f, -4.0f / 9.0f,
            4.0f / 9.0f, -2.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f,
            -4.0f / 9.0f, -8.0f / 9.0f, 0.0f, -4.0f / 9.0f, -6.0f / 9.0f, 0.0f, -4.0f / 9.0f, -4.0f / 9.0f, 0.0f,
            -4.0f / 9.0f, -2.0f / 9.0f, 0.0f, -4.0f / 9.0f, 0.0f, 0.0f, -4.0f / 9.0f, 2.0f / 9.0f, 0.0f, -4.0f / 9.0f,
            4.0f / 9.0f, 0.0f, -4.0f / 9.0f, 6.0f / 9.0f, 0.0f, -4.0f / 9.0f, 8.0f / 9.0f, 0.0f, -4.0f / 9.0f,
            -8.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f,
            -4.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f, 0.0f, 2.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f,
            2.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f,
            8.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f,
            -4.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f, 0.0f,
            4.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f,
            6.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f,
            -4.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f, -4.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f, -4.0f / 9.0f,
            -2.0f / 9.0f, 6.0f / 9.0f, -4.0f / 9.0f, 0.0f, 6.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f,
            -4.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f,
            6.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f,
            -4.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f, 0.0f, 8.0f / 9.0f,
            -4.0f / 9.0f, 2.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f,
            8.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f,
            -6.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f, -2.0f / 9.0f,
            -8.0f / 9.0f, -2.0f / 9.0f, 0.0f, -8.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f,
            4.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f,
            -2.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f,
            -4.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f, -2.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f, 0.0f, -6.0f / 9.0f,
            -2.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f,
            -6.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f,
            -2.0f / 9.0f, -6.0f / 9.0f, -4.0f / 9.0f, -2.0f / 9.0f, -4.0f / 9.0f, -4.0f / 9.0f, -2.0f / 9.0f,
            -2.0f / 9.0f, -4.0f / 9.0f, -2.0f / 9.0f, 0.0f, -4.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f,
            -2.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f, -4.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f,
            -4.0f / 9.0f, -2.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f, -2.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f,
            -2.0f / 9.0f, -4.0f / 9.0f, -2.0f / 9.0f, -2.0f / 9.0f, -2.0f / 9.0f, -2.0f / 9.0f, -2.0f / 9.0f, 0.0f,
            -2.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f,
            -2.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f, -2.0f / 9.0f,
            -8.0f / 9.0f, 0.0f, -2.0f / 9.0f, -6.0f / 9.0f, 0.0f, -2.0f / 9.0f, -4.0f / 9.0f, 0.0f, -2.0f / 9.0f,
            -2.0f / 9.0f, 0.0f, -2.0f / 9.0f, 0.0f, 0.0f, -2.0f / 9.0f, 2.0f / 9.0f, 0.0f, -2.0f / 9.0f, 4.0f / 9.0f,
            0.0f, -2.0f / 9.0f, 6.0f / 9.0f, 0.0f, -2.0f / 9.0f, 8.0f / 9.0f, 0.0f, -2.0f / 9.0f, -8.0f / 9.0f,
            2.0f / 9.0f, -2.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f,
            -2.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f, 0.0f, 2.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, 2.0f / 9.0f,
            -2.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f,
            2.0f / 9.0f, -2.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f,
            -4.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f, 0.0f, 4.0f / 9.0f,
            -2.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f,
            4.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f,
            -6.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f,
            -2.0f / 9.0f, 0.0f, 6.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f,
            6.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f,
            -8.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f,
            -2.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f, 0.0f, 8.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f,
            8.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f,
            8.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f, 0.0f, -6.0f / 9.0f, -8.0f / 9.0f, 0.0f,
            -4.0f / 9.0f, -8.0f / 9.0f, 0.0f, -2.0f / 9.0f, -8.0f / 9.0f, 0.0f, 0.0f, -8.0f / 9.0f, 0.0f, 2.0f / 9.0f,
            -8.0f / 9.0f, 0.0f, 4.0f / 9.0f, -8.0f / 9.0f, 0.0f, 6.0f / 9.0f, -8.0f / 9.0f, 0.0f, 8.0f / 9.0f,
            -8.0f / 9.0f, 0.0f, -8.0f / 9.0f, -6.0f / 9.0f, 0.0f, -6.0f / 9.0f, -6.0f / 9.0f, 0.0f, -4.0f / 9.0f,
            -6.0f / 9.0f, 0.0f, -2.0f / 9.0f, -6.0f / 9.0f, 0.0f, 0.0f, -6.0f / 9.0f, 0.0f, 2.0f / 9.0f, -6.0f / 9.0f,
            0.0f, 4.0f / 9.0f, -6.0f / 9.0f, 0.0f, 6.0f / 9.0f, -6.0f / 9.0f, 0.0f, 8.0f / 9.0f, -6.0f / 9.0f, 0.0f,
            -8.0f / 9.0f, -4.0f / 9.0f, 0.0f, -6.0f / 9.0f, -4.0f / 9.0f, 0.0f, -4.0f / 9.0f, -4.0f / 9.0f, 0.0f,
            -2.0f / 9.0f, -4.0f / 9.0f, 0.0f, 0.0f, -4.0f / 9.0f, 0.0f, 2.0f / 9.0f, -4.0f / 9.0f, 0.0f, 4.0f / 9.0f,
            -4.0f / 9.0f, 0.0f, 6.0f / 9.0f, -4.0f / 9.0f, 0.0f, 8.0f / 9.0f, -4.0f / 9.0f, 0.0f, -8.0f / 9.0f,
            -2.0f / 9.0f, 0.0f, -6.0f / 9.0f, -2.0f / 9.0f, 0.0f, -4.0f / 9.0f, -2.0f / 9.0f, 0.0f, -2.0f / 9.0f,
            -2.0f / 9.0f, 0.0f, 0.0f, -2.0f / 9.0f, 0.0f, 2.0f / 9.0f, -2.0f / 9.0f, 0.0f, 4.0f / 9.0f, -2.0f / 9.0f,
            0.0f, 6.0f / 9.0f, -2.0f / 9.0f, 0.0f, 8.0f / 9.0f, -2.0f / 9.0f, 0.0f, -8.0f / 9.0f, 0.0f, 0.0f,
            -6.0f / 9.0f, 0.0f, 0.0f, -4.0f / 9.0f, 0.0f, 0.0f, -2.0f / 9.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f / 9.0f,
            0.0f, 0.0f, 4.0f / 9.0f, 0.0f, 0.0f, 6.0f / 9.0f, 0.0f, 0.0f, 8.0f / 9.0f, 0.0f, 0.0f, -8.0f / 9.0f,
            2.0f / 9.0f, 0.0f, -6.0f / 9.0f, 2.0f / 9.0f, 0.0f, -4.0f / 9.0f, 2.0f / 9.0f, 0.0f, -2.0f / 9.0f,
            2.0f / 9.0f, 0.0f, 0.0f, 2.0f / 9.0f, 0.0f, 2.0f / 9.0f, 2.0f / 9.0f, 0.0f, 4.0f / 9.0f, 2.0f / 9.0f, 0.0f,
            6.0f / 9.0f, 2.0f / 9.0f, 0.0f, 8.0f / 9.0f, 2.0f / 9.0f, 0.0f, -8.0f / 9.0f, 4.0f / 9.0f, 0.0f,
            -6.0f / 9.0f, 4.0f / 9.0f, 0.0f, -4.0f / 9.0f, 4.0f / 9.0f, 0.0f, -2.0f / 9.0f, 4.0f / 9.0f, 0.0f, 0.0f,
            4.0f / 9.0f, 0.0f, 2.0f / 9.0f, 4.0f / 9.0f, 0.0f, 4.0f / 9.0f, 4.0f / 9.0f, 0.0f, 6.0f / 9.0f, 4.0f / 9.0f,
            0.0f, 8.0f / 9.0f, 4.0f / 9.0f, 0.0f, -8.0f / 9.0f, 6.0f / 9.0f, 0.0f, -6.0f / 9.0f, 6.0f / 9.0f, 0.0f,
            -4.0f / 9.0f, 6.0f / 9.0f, 0.0f, -2.0f / 9.0f, 6.0f / 9.0f, 0.0f, 0.0f, 6.0f / 9.0f, 0.0f, 2.0f / 9.0f,
            6.0f / 9.0f, 0.0f, 4.0f / 9.0f, 6.0f / 9.0f, 0.0f, 6.0f / 9.0f, 6.0f / 9.0f, 0.0f, 8.0f / 9.0f, 6.0f / 9.0f,
            0.0f, -8.0f / 9.0f, 8.0f / 9.0f, 0.0f, -6.0f / 9.0f, 8.0f / 9.0f, 0.0f, -4.0f / 9.0f, 8.0f / 9.0f, 0.0f,
            -2.0f / 9.0f, 8.0f / 9.0f, 0.0f, 0.0f, 8.0f / 9.0f, 0.0f, 2.0f / 9.0f, 8.0f / 9.0f, 0.0f, 4.0f / 9.0f,
            8.0f / 9.0f, 0.0f, 6.0f / 9.0f, 8.0f / 9.0f, 0.0f, 8.0f / 9.0f, 8.0f / 9.0f, 0.0f, -8.0f / 9.0f,
            -8.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, 2.0f / 9.0f,
            -2.0f / 9.0f, -8.0f / 9.0f, 2.0f / 9.0f, 0.0f, -8.0f / 9.0f, 2.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f,
            2.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, 2.0f / 9.0f, 8.0f / 9.0f,
            -8.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f,
            -4.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, 0.0f, -6.0f / 9.0f,
            2.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f,
            -6.0f / 9.0f, 2.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f,
            -6.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f,
            -4.0f / 9.0f, 2.0f / 9.0f, 0.0f, -4.0f / 9.0f, 2.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f,
            4.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f,
            2.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f,
            -2.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, 0.0f, -2.0f / 9.0f, 2.0f / 9.0f,
            2.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f,
            2.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f, 0.0f, 2.0f / 9.0f, -6.0f / 9.0f, 0.0f,
            2.0f / 9.0f, -4.0f / 9.0f, 0.0f, 2.0f / 9.0f, -2.0f / 9.0f, 0.0f, 2.0f / 9.0f, 0.0f, 0.0f, 2.0f / 9.0f,
            2.0f / 9.0f, 0.0f, 2.0f / 9.0f, 4.0f / 9.0f, 0.0f, 2.0f / 9.0f, 6.0f / 9.0f, 0.0f, 2.0f / 9.0f, 8.0f / 9.0f,
            0.0f, 2.0f / 9.0f, -8.0f / 9.0f, 2.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, 2.0f / 9.0f,
            -4.0f / 9.0f, 2.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, 2.0f / 9.0f, 0.0f, 2.0f / 9.0f,
            2.0f / 9.0f, 2.0f / 9.0f, 2.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f,
            2.0f / 9.0f, 2.0f / 9.0f, 8.0f / 9.0f, 2.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f,
            -6.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f,
            2.0f / 9.0f, 0.0f, 4.0f / 9.0f, 2.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f,
            4.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f,
            -8.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f,
            2.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f, 0.0f, 6.0f / 9.0f, 2.0f / 9.0f, 2.0f / 9.0f,
            6.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f,
            8.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f,
            2.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f, 2.0f / 9.0f, 0.0f,
            8.0f / 9.0f, 2.0f / 9.0f, 2.0f / 9.0f, 8.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, 2.0f / 9.0f,
            6.0f / 9.0f, 8.0f / 9.0f, 2.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f,
            4.0f / 9.0f, -6.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f,
            -8.0f / 9.0f, 4.0f / 9.0f, 0.0f, -8.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f,
            4.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f,
            4.0f / 9.0f, -8.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f,
            -6.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f, 0.0f, -6.0f / 9.0f, 4.0f / 9.0f,
            2.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f,
            4.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f,
            -4.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f,
            0.0f, -4.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f,
            4.0f / 9.0f, 6.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f,
            -2.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f,
            -2.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f, 0.0f, -2.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f,
            4.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f,
            -2.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f, 0.0f, 4.0f / 9.0f, -6.0f / 9.0f, 0.0f, 4.0f / 9.0f, -4.0f / 9.0f,
            0.0f, 4.0f / 9.0f, -2.0f / 9.0f, 0.0f, 4.0f / 9.0f, 0.0f, 0.0f, 4.0f / 9.0f, 2.0f / 9.0f, 0.0f, 4.0f / 9.0f,
            4.0f / 9.0f, 0.0f, 4.0f / 9.0f, 6.0f / 9.0f, 0.0f, 4.0f / 9.0f, 8.0f / 9.0f, 0.0f, 4.0f / 9.0f,
            -8.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f,
            4.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, 0.0f, 2.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f,
            2.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f,
            8.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f,
            4.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, 0.0f,
            4.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f,
            6.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f,
            4.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f,
            6.0f / 9.0f, 4.0f / 9.0f, 0.0f, 6.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f, 4.0f / 9.0f,
            4.0f / 9.0f, 6.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f,
            4.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f,
            8.0f / 9.0f, 4.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, 0.0f, 8.0f / 9.0f, 4.0f / 9.0f,
            2.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f, 8.0f / 9.0f,
            4.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f,
            -8.0f / 9.0f, 6.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f,
            0.0f, -8.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f,
            6.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f,
            -6.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f, -4.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f,
            -2.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f, 0.0f, -6.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f,
            6.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f, 8.0f / 9.0f,
            -6.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f,
            -4.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f, 0.0f, -4.0f / 9.0f,
            6.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f,
            -4.0f / 9.0f, 6.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f,
            -6.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f, -4.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f,
            -2.0f / 9.0f, 6.0f / 9.0f, 0.0f, -2.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f,
            4.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f, 6.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f,
            6.0f / 9.0f, -8.0f / 9.0f, 0.0f, 6.0f / 9.0f, -6.0f / 9.0f, 0.0f, 6.0f / 9.0f, -4.0f / 9.0f, 0.0f,
            6.0f / 9.0f, -2.0f / 9.0f, 0.0f, 6.0f / 9.0f, 0.0f, 0.0f, 6.0f / 9.0f, 2.0f / 9.0f, 0.0f, 6.0f / 9.0f,
            4.0f / 9.0f, 0.0f, 6.0f / 9.0f, 6.0f / 9.0f, 0.0f, 6.0f / 9.0f, 8.0f / 9.0f, 0.0f, 6.0f / 9.0f,
            -8.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f,
            6.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f, 0.0f, 2.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f,
            2.0f / 9.0f, 6.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f,
            8.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f,
            6.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f, 0.0f,
            4.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f,
            6.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f,
            6.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f,
            6.0f / 9.0f, 6.0f / 9.0f, 0.0f, 6.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f,
            4.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f,
            6.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f, -4.0f / 9.0f,
            8.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f, 0.0f, 8.0f / 9.0f, 6.0f / 9.0f,
            2.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f, 8.0f / 9.0f,
            6.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f,
            -8.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f,
            0.0f, -8.0f / 9.0f, 8.0f / 9.0f, 2.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, -8.0f / 9.0f,
            8.0f / 9.0f, 6.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f,
            -6.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f,
            -2.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f, 0.0f, -6.0f / 9.0f, 8.0f / 9.0f, 2.0f / 9.0f, -6.0f / 9.0f,
            8.0f / 9.0f, 4.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f,
            -6.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f,
            -4.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f, 0.0f, -4.0f / 9.0f,
            8.0f / 9.0f, 2.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f,
            -4.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f,
            -6.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f,
            -2.0f / 9.0f, 8.0f / 9.0f, 0.0f, -2.0f / 9.0f, 8.0f / 9.0f, 2.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f,
            4.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f,
            8.0f / 9.0f, -8.0f / 9.0f, 0.0f, 8.0f / 9.0f, -6.0f / 9.0f, 0.0f, 8.0f / 9.0f, -4.0f / 9.0f, 0.0f,
            8.0f / 9.0f, -2.0f / 9.0f, 0.0f, 8.0f / 9.0f, 0.0f, 0.0f, 8.0f / 9.0f, 2.0f / 9.0f, 0.0f, 8.0f / 9.0f,
            4.0f / 9.0f, 0.0f, 8.0f / 9.0f, 6.0f / 9.0f, 0.0f, 8.0f / 9.0f, 8.0f / 9.0f, 0.0f, 8.0f / 9.0f,
            -8.0f / 9.0f, 2.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f, 2.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f, 2.0f / 9.0f,
            8.0f / 9.0f, -2.0f / 9.0f, 2.0f / 9.0f, 8.0f / 9.0f, 0.0f, 2.0f / 9.0f, 8.0f / 9.0f, 2.0f / 9.0f,
            2.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, 2.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f, 2.0f / 9.0f, 8.0f / 9.0f,
            8.0f / 9.0f, 2.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f, 4.0f / 9.0f,
            8.0f / 9.0f, -4.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, 0.0f,
            4.0f / 9.0f, 8.0f / 9.0f, 2.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f,
            6.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, -8.0f / 9.0f, 6.0f / 9.0f,
            8.0f / 9.0f, -6.0f / 9.0f, 6.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f, 6.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f,
            6.0f / 9.0f, 8.0f / 9.0f, 0.0f, 6.0f / 9.0f, 8.0f / 9.0f, 2.0f / 9.0f, 6.0f / 9.0f, 8.0f / 9.0f,
            4.0f / 9.0f, 6.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f, 6.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f,
            8.0f / 9.0f, -8.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, -6.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, -4.0f / 9.0f,
            8.0f / 9.0f, 8.0f / 9.0f, -2.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, 0.0f, 8.0f / 9.0f, 8.0f / 9.0f,
            2.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, 4.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, 6.0f / 9.0f, 8.0f / 9.0f,
            8.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f, 8.0f / 9.0f };

    static final int tableAb1CodeLength[] =
            { 0, 5, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 };

    static final float tableAb1Groupingtables[][] =
            { null, grouping5Bits, null, null, null, null, null, null, null, null, null, null, null, null, null,
                    null };

    static final float tableAb1Factor[] =
            { 0.0f, 1.0f / 2.0f, 1.0f / 4.0f, 1.0f / 8.0f, 1.0f / 16.0f, 1.0f / 32.0f, 1.0f / 64.0f, 1.0f / 128.0f,
                    1.0f / 256.0f, 1.0f / 512.0f, 1.0f / 1024.0f, 1.0f / 2048.0f, 1.0f / 4096.0f, 1.0f / 8192.0f,
                    1.0f / 16384.0f, 1.0f / 32768.0f };

    static final float tableAb1C[] =
            { 0.0f, 1.33333333333f, 1.14285714286f, 1.06666666666f, 1.03225806452f, 1.01587301587f, 1.00787401575f,
                    1.00392156863f, 1.00195694716f, 1.00097751711f, 1.00048851979f, 1.00024420024f, 1.00012208522f,
                    1.00006103888f, 1.00003051851f, 1.00001525902f };

    static final float tableAb1D[] =
            { 0.0f, 0.50000000000f, 0.25000000000f, 0.12500000000f, 0.06250000000f, 0.03125000000f, 0.01562500000f,
                    0.00781250000f, 0.00390625000f, 0.00195312500f, 0.00097656250f, 0.00048828125f, 0.00024414063f,
                    0.00012207031f, 0.00006103516f, 0.00003051758f };

    static final float[] tableAb234Groupingtables[] = { null, grouping5Bits, grouping7Bits, null, grouping10Bits,
            null, null, null, null, null, null, null, null, null, null, null };

    static final int tableAb2CodeLength[] = { 0, 5, 7, 3, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16 };
    static final float tableAb2Factor[] = { 0.0f, 1.0f / 2.0f, 1.0f / 4.0f, 1.0f / 4.0f, 1.0f / 8.0f, 1.0f / 8.0f,
            1.0f / 16.0f, 1.0f / 32.0f, 1.0f / 64.0f, 1.0f / 128.0f, 1.0f / 256.0f, 1.0f / 512.0f, 1.0f / 1024.0f,
            1.0f / 2048.0f, 1.0f / 4096.0f, 1.0f / 32768.0f };
    static final float table_ab2_c[] = { 0.0f, 1.33333333333f, 1.60000000000f, 1.14285714286f, 1.77777777777f,
            1.06666666666f, 1.03225806452f, 1.01587301587f, 1.00787401575f, 1.00392156863f, 1.00195694716f,
            1.00097751711f, 1.00048851979f, 1.00024420024f, 1.00012208522f, 1.00001525902f };
    static final float table_ab2_d[] = { 0.0f, 0.50000000000f, 0.50000000000f, 0.25000000000f, 0.50000000000f,
            0.12500000000f, 0.06250000000f, 0.03125000000f, 0.01562500000f, 0.00781250000f, 0.00390625000f,
            0.00195312500f, 0.00097656250f, 0.00048828125f, 0.00024414063f, 0.00003051758f };

    static final int tableAb3CodeLength[] = { 0, 5, 7, 3, 10, 4, 5, 16 };
    static final float tableAb3Factor[] = { 0.0f, 1.0f / 2.0f, 1.0f / 4.0f, 1.0f / 4.0f, 1.0f / 8.0f, 1.0f / 8.0f,
            1.0f / 16.0f, 1.0f / 32768.0f };
    static final float tableAb3C[] = { 0.0f, 1.33333333333f, 1.60000000000f, 1.14285714286f, 1.77777777777f,
            1.06666666666f, 1.03225806452f, 1.00001525902f };
    static final float tableAb3D[] = { 0.0f, 0.50000000000f, 0.50000000000f, 0.25000000000f, 0.50000000000f,
            0.12500000000f, 0.06250000000f, 0.00003051758f };

    static final int tableAb4CodeLength[] = { 0, 5, 7, 16 };
    static final float tableAb4Factor[] = { 0.0f, 1.0f / 2.0f, 1.0f / 4.0f, 1.0f / 32768.0f };
    static final float tableAb4C[] = { 0.0f, 1.33333333333f, 1.60000000000f, 1.00001525902f };
    static final float tableAb4D[] = { 0.0f, 0.50000000000f, 0.50000000000f, 0.00003051758f };

    static final int tableCdCodelength[] = { 0, 5, 7, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 };
    static final float tableCdGroupingtables[][] = { null, grouping5Bits, grouping7Bits, grouping10Bits, null, null,
            null, null, null, null, null, null, null, null, null, null };
    static final float tableCdFactor[] = { 0.0f, 1.0f / 2.0f, 1.0f / 4.0f, 1.0f / 8.0f, 1.0f / 8.0f, 1.0f / 16.0f,
            1.0f / 32.0f, 1.0f / 64.0f, 1.0f / 128.0f, 1.0f / 256.0f, 1.0f / 512.0f, 1.0f / 1024.0f, 1.0f / 2048.0f,
            1.0f / 4096.0f, 1.0f / 8192.0f, 1.0f / 16384.0f };
    static final float tableCdC[] = { 0.0f, 1.33333333333f, 1.60000000000f, 1.77777777777f, 1.06666666666f,
            1.03225806452f, 1.01587301587f, 1.00787401575f, 1.00392156863f, 1.00195694716f, 1.00097751711f,
            1.00048851979f, 1.00024420024f, 1.00012208522f, 1.00006103888f, 1.00003051851f };
    static final float tableCdD[] = { 0.0f, 0.50000000000f, 0.50000000000f, 0.50000000000f, 0.12500000000f,
            0.06250000000f, 0.03125000000f, 0.01562500000f, 0.00781250000f, 0.00390625000f, 0.00195312500f,
            0.00097656250f, 0.00048828125f, 0.00024414063f, 0.00012207031f, 0.00006103516f };
    
    static VLC tab1 = VLCBuilder
            .createVLCBuilder(new int[] { 1, 1, 1, 0 }, new int[] { 1, 2, 3, 3 }, new int[] { 0, 16, 1, 17 }).getVLC();

    static VLC tab2 = VLCBuilder.createVLCBuilder(new int[] { 1, 3, 2, 1, 3, 2, 1, 1, 0, },
            new int[] { 1, 3, 3, 3, 5, 5, 5, 6, 6, }, new int[] { 0, 16, 1, 17, 32, 33, 18, 2, 34, }).getVLC();
    static VLC tab3 = VLCBuilder.createVLCBuilder(new int[] { 3, 2, 1, 1, 3, 2, 1, 1, 0, },
            new int[] { 2, 2, 2, 3, 5, 5, 5, 6, 6, }, new int[] { 0, 1, 17, 16, 32, 33, 18, 2, 34, }).getVLC();

    static VLC tab5 = VLCBuilder.createVLCBuilder(new int[] { 1, 3, 2, 1, 7, 6, 5, 4, 7, 6, 5, 4, 1, 1, 1, 0, },
            new int[] { 1, 3, 3, 3, 6, 6, 6, 6, 7, 7, 7, 7, 6, 7, 8, 8, },
            new int[] { 0, 16, 1, 17, 32, 2, 33, 18, 34, 48, 3, 19, 49, 50, 35, 51, }).getVLC();
    static VLC tab6 = VLCBuilder.createVLCBuilder(new int[] { 7, 6, 2, 3, 5, 4, 3, 5, 4, 3, 2, 3, 2, 1, 1, 0, },
            new int[] { 3, 3, 2, 3, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, },
            new int[] { 0, 16, 17, 1, 32, 33, 18, 2, 34, 49, 19, 48, 50, 35, 3, 51, }).getVLC();
    static VLC tab7 = VLCBuilder.createVLCBuilder(
            new int[] { 1, 3, 2, 3, 11, 10, 4, 7, 13, 12, 11, 10, 19, 18, 17, 16, 7, 6, 5, 9, 8, 15, 14, 6, 11, 10, 4,
                    3, 5, 4, 3, 2, 3, 2, 1, 0, },
            new int[] { 1, 3, 3, 4, 6, 6, 5, 6, 7, 7, 7, 7, 8, 8, 8, 8, 7, 7, 7, 8, 8, 9, 9, 8, 9, 9, 8, 8, 9, 9, 9, 9,
                    10, 10, 10, 10, },
            new int[] { 0, 16, 1, 17, 32, 2, 33, 18, 34, 48, 49, 19, 3, 50, 35, 4, 64, 65, 20, 66, 36, 51, 67, 80, 52,
                    5, 81, 21, 82, 37, 68, 53, 83, 84, 69, 85, })
            .getVLC();
    static VLC tab8 = VLCBuilder.createVLCBuilder(
            new int[] { 3, 5, 4, 1, 3, 2, 7, 6, 5, 19, 18, 17, 16, 15, 14, 13, 12, 5, 9, 8, 7, 13, 12, 11, 10, 4, 3, 5,
                    4, 3, 5, 4, 1, 1, 1, 0, },
            new int[] { 2, 3, 3, 2, 4, 4, 6, 6, 6, 8, 8, 8, 8, 8, 8, 8, 8, 7, 8, 8, 8, 9, 9, 9, 9, 8, 8, 9, 9, 9, 10,
                    10, 9, 10, 11, 11, },
            new int[] { 0, 16, 1, 17, 33, 18, 32, 2, 34, 48, 3, 49, 19, 50, 35, 64, 4, 65, 20, 66, 36, 51, 80, 67, 52,
                    81, 21, 5, 82, 37, 68, 53, 83, 69, 84, 85, })
            .getVLC();
    static VLC tab9 = VLCBuilder.createVLCBuilder(
            new int[] { 7, 6, 5, 4, 7, 6, 5, 9, 8, 15, 14, 6, 5, 9, 8, 7, 6, 11, 10, 9, 8, 15, 14, 6, 5, 4, 7, 6, 5, 4,
                    7, 6, 2, 1, 1, 0, },
            new int[] { 3, 3, 3, 3, 4, 4, 4, 5, 5, 6, 6, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 7, 7, 7, 8, 8, 8, 8, 9, 9,
                    8, 8, 9, 9, },
            new int[] { 0, 16, 1, 17, 32, 33, 18, 2, 34, 48, 3, 49, 19, 50, 35, 65, 20, 64, 51, 66, 36, 4, 80, 67, 52,
                    81, 21, 82, 37, 68, 5, 84, 83, 53, 69, 85, })
            .getVLC();
    static VLC tab10 = VLCBuilder
            .createVLCBuilder(
                    new int[] { 1, 3, 2, 3, 11, 10, 9, 8, 15, 14, 13, 12, 23, 22, 21, 20, 19, 18, 35, 34, 33, 32, 31,
                            30, 14, 13, 12, 47, 46, 22, 21, 41, 40, 19, 18, 8, 7, 27, 26, 12, 23, 22, 10, 9, 17, 16, 7,
                            6, 11, 21, 20, 9, 8, 7, 6, 5, 4, 3, 5, 4, 3, 2, 1, 0, },
                    new int[] { 1, 3, 3, 4, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 8, 8, 8, 10, 10,
                            9, 9, 10, 10, 9, 9, 8, 8, 10, 10, 9, 10, 10, 9, 9, 10, 10, 9, 9, 10, 11, 11, 10, 10, 10, 10,
                            10, 10, 10, 11, 11, 11, 11, 11, 11, },
                    new int[] { 0, 16, 1, 17, 32, 2, 33, 18, 34, 48, 49, 19, 3, 50, 35, 64, 65, 20, 4, 51, 66, 36, 80,
                            5, 96, 97, 22, 67, 52, 81, 21, 82, 37, 38, 54, 113, 23, 68, 83, 6, 53, 69, 98, 112, 7, 100,
                            114, 39, 99, 84, 85, 70, 115, 55, 101, 86, 116, 71, 102, 117, 87, 118, 103, 119, })
            .getVLC();
    static VLC tab11 = VLCBuilder.createVLCBuilder(
            new int[] { 3, 5, 4, 3, 11, 10, 4, 7, 13, 25, 24, 11, 10, 19, 18, 35, 34, 33, 32, 31, 30, 59, 58, 28, 27,
                    26, 12, 11, 21, 20, 9, 17, 33, 32, 31, 30, 14, 13, 12, 11, 10, 4, 15, 14, 6, 5, 19, 18, 17, 16, 7,
                    6, 5, 9, 8, 15, 14, 6, 5, 4, 3, 2, 1, 0, },
            new int[] { 2, 3, 3, 3, 5, 5, 4, 5, 6, 7, 7, 6, 6, 7, 7, 8, 8, 8, 8, 8, 8, 9, 9, 8, 8, 8, 7, 7, 8, 8, 7, 8,
                    9, 9, 9, 9, 8, 8, 8, 8, 8, 7, 9, 9, 8, 8, 10, 10, 10, 10, 9, 9, 9, 10, 10, 11, 11, 10, 10, 10, 10,
                    10, 10, 10, },
            new int[] { 0, 16, 1, 17, 32, 2, 18, 33, 34, 48, 3, 49, 19, 50, 35, 64, 4, 65, 20, 66, 36, 51, 67, 80, 52,
                    81, 97, 22, 6, 38, 98, 21, 5, 82, 37, 68, 96, 99, 54, 112, 23, 113, 7, 100, 114, 39, 83, 53, 84, 69,
                    70, 115, 55, 101, 86, 85, 87, 116, 71, 102, 117, 118, 103, 119, })
            .getVLC();
    static VLC tab12 = VLCBuilder.createVLCBuilder(
            new int[] { 7, 6, 5, 9, 17, 16, 7, 6, 11, 10, 9, 17, 33, 32, 15, 14, 13, 12, 23, 22, 21, 41, 40, 19, 18, 17,
                    16, 31, 30, 29, 28, 27, 26, 12, 11, 10, 39, 38, 18, 17, 16, 15, 14, 27, 26, 12, 11, 10, 9, 8, 7, 13,
                    12, 5, 4, 7, 6, 5, 4, 3, 2, 1, 1, 0, },
            new int[] { 3, 3, 3, 4, 5, 5, 4, 4, 5, 5, 5, 6, 7, 7, 6, 6, 6, 6, 7, 7, 7, 8, 8, 7, 7, 7, 7, 8, 8, 8, 8, 8,
                    8, 7, 7, 7, 9, 9, 8, 8, 8, 8, 8, 9, 9, 8, 8, 8, 8, 8, 8, 9, 9, 8, 8, 9, 9, 9, 9, 9, 9, 9, 10, 10, },
            new int[] { 16, 1, 17, 0, 32, 2, 33, 18, 34, 49, 19, 48, 3, 64, 50, 35, 65, 51, 20, 66, 36, 4, 80, 67, 52,
                    81, 21, 82, 37, 83, 53, 96, 22, 97, 98, 38, 5, 6, 68, 84, 69, 99, 54, 112, 7, 113, 23, 100, 70, 114,
                    39, 85, 115, 55, 86, 101, 116, 71, 102, 117, 87, 118, 103, 119, })
            .getVLC();
    static VLC tab13 = VLCBuilder.createVLCBuilder(new int[] { 1, 3, 5, 4, 15, 14, 13, 12, 23, 22, 21, 20, 19, 37, 36,
            35, 34, 16, 31, 61, 60, 59, 58, 57, 56, 27, 26, 51, 50, 49, 97, 96, 47, 46, 45, 44, 43, 42, 20, 79, 78, 77,
            76, 75, 74, 73, 72, 71, 70, 34, 33, 65, 64, 31, 30, 29, 115, 114, 56, 55, 54, 53, 52, 25, 24, 95, 94, 93,
            92, 91, 90, 44, 43, 85, 84, 41, 40, 79, 78, 77, 76, 37, 73, 72, 35, 69, 68, 33, 32, 31, 30, 59, 58, 57, 56,
            55, 54, 53, 52, 25, 24, 23, 91, 90, 44, 87, 86, 42, 83, 82, 40, 79, 78, 38, 37, 73, 72, 71, 70, 34, 67, 66,
            32, 31, 61, 60, 29, 28, 27, 26, 51, 50, 49, 48, 47, 46, 45, 44, 21, 41, 81, 80, 39, 77, 76, 75, 74, 36, 35,
            34, 33, 65, 64, 31, 30, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 23, 22, 43, 42, 20, 39, 38, 37, 36,
            35, 34, 16, 15, 14, 55, 54, 26, 25, 49, 48, 23, 45, 44, 21, 41, 40, 19, 37, 36, 17, 16, 31, 30, 14, 27, 53,
            52, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 29, 28, 27, 26, 12, 11, 43, 42, 20, 39, 38, 18, 17, 16, 15,
            14, 13, 12, 11, 10, 9, 17, 16, 7, 6, 23, 22, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 1, 1, 1, 0, },
            new int[] { 1, 3, 4, 4, 6, 6, 6, 6, 7, 7, 7, 7, 7, 8, 8, 8, 8, 7, 8, 9, 9, 9, 9, 9, 9, 8, 8, 9, 9, 9, 10,
                    10, 9, 9, 9, 9, 9, 9, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 9, 9, 10, 10, 9, 9, 9, 11, 11, 10,
                    10, 10, 10, 10, 9, 9, 11, 11, 11, 11, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 11, 11, 10, 11, 11,
                    10, 11, 11, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 10, 10, 10, 12, 12, 11, 12, 12, 11, 12,
                    12, 11, 12, 12, 11, 11, 12, 12, 12, 12, 11, 12, 12, 11, 11, 12, 12, 11, 11, 11, 11, 12, 12, 12, 12,
                    12, 12, 12, 12, 11, 12, 13, 13, 12, 13, 13, 13, 13, 12, 12, 12, 12, 13, 13, 12, 12, 13, 13, 13, 13,
                    13, 13, 13, 13, 13, 13, 13, 13, 12, 12, 13, 13, 12, 13, 13, 13, 13, 13, 13, 12, 12, 12, 14, 14, 13,
                    13, 14, 14, 13, 14, 14, 13, 14, 14, 13, 14, 14, 13, 13, 14, 14, 13, 14, 15, 15, 14, 14, 14, 14, 14,
                    14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 14, 14, 16, 16, 15, 16, 16, 15, 15, 15, 15, 15, 15, 15, 15,
                    15, 15, 16, 16, 15, 15, 17, 17, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 18, 19, 19, },
            new int[] { 0, 16, 1, 17, 32, 2, 33, 18, 34, 48, 3, 49, 19, 50, 35, 64, 4, 65, 20, 51, 66, 36, 80, 67, 52,
                    81, 21, 5, 82, 37, 68, 83, 96, 6, 97, 22, 128, 8, 129, 53, 98, 38, 84, 69, 99, 54, 112, 7, 85, 113,
                    23, 39, 55, 24, 130, 40, 100, 70, 114, 132, 72, 144, 9, 145, 25, 115, 101, 86, 116, 71, 102, 131,
                    56, 117, 87, 146, 41, 103, 133, 88, 57, 147, 73, 134, 160, 104, 10, 161, 26, 162, 42, 149, 89, 163,
                    58, 74, 150, 176, 11, 177, 27, 178, 118, 119, 148, 135, 120, 164, 105, 165, 43, 90, 136, 179, 59,
                    121, 166, 106, 180, 192, 12, 152, 193, 28, 137, 181, 91, 194, 44, 60, 182, 107, 196, 76, 168, 138,
                    208, 13, 209, 75, 151, 167, 195, 122, 153, 197, 92, 183, 29, 210, 45, 123, 211, 61, 198, 108, 169,
                    154, 212, 184, 139, 77, 199, 124, 213, 93, 224, 225, 30, 14, 46, 226, 227, 109, 140, 228, 229, 186,
                    240, 241, 31, 170, 155, 185, 62, 214, 200, 78, 215, 125, 171, 94, 201, 15, 156, 110, 242, 47, 216,
                    141, 63, 243, 230, 202, 244, 79, 187, 172, 231, 245, 217, 157, 95, 232, 111, 246, 203, 188, 173,
                    218, 247, 126, 127, 142, 158, 174, 204, 248, 143, 219, 189, 234, 249, 159, 235, 190, 205, 250, 221,
                    236, 233, 175, 220, 206, 251, 191, 222, 207, 238, 223, 239, 255, 237, 253, 252, 254, })
            .getVLC();

    static VLC tab15 = VLCBuilder.createVLCBuilder(
            new int[] { 7, 13, 12, 5, 19, 18, 17, 16, 15, 29, 28, 27, 53, 52, 25, 24, 47, 46, 22, 43, 42, 41, 40, 39,
                    77, 76, 37, 36, 35, 34, 67, 66, 32, 63, 125, 124, 61, 60, 59, 58, 57, 56, 55, 109, 108, 53, 52, 51,
                    50, 49, 48, 95, 94, 93, 92, 91, 90, 89, 88, 43, 42, 41, 40, 79, 78, 77, 76, 75, 74, 73, 72, 71, 70,
                    34, 67, 66, 65, 64, 63, 62, 123, 122, 60, 59, 58, 57, 56, 55, 109, 108, 53, 52, 51, 50, 49, 48, 47,
                    93, 92, 91, 90, 89, 88, 87, 86, 42, 83, 82, 40, 79, 78, 77, 76, 37, 73, 72, 71, 70, 69, 68, 67, 66,
                    65, 64, 63, 62, 30, 119, 118, 58, 57, 56, 55, 54, 107, 106, 52, 51, 50, 49, 48, 47, 46, 91, 90, 44,
                    43, 42, 41, 81, 80, 39, 38, 75, 74, 73, 72, 71, 70, 34, 67, 66, 65, 64, 63, 62, 123, 122, 60, 59,
                    58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 71, 70,
                    34, 33, 32, 31, 30, 29, 28, 27, 53, 52, 25, 24, 23, 22, 21, 20, 39, 38, 37, 36, 17, 16, 63, 62, 30,
                    29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 15, 14, 6, 11,
                    10, 9, 8, 7, 6, 2, 3, 2, 1, 0, },
            new int[] { 3, 4, 4, 3, 5, 5, 5, 5, 5, 6, 6, 6, 7, 7, 6, 6, 7, 7, 6, 7, 7, 7, 7, 7, 8, 8, 7, 7, 7, 7, 8, 8,
                    7, 8, 9, 9, 8, 8, 8, 8, 8, 8, 8, 9, 9, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 8, 8, 8, 8, 9, 9,
                    9, 9, 9, 9, 9, 9, 9, 9, 8, 9, 9, 9, 9, 9, 9, 10, 10, 9, 9, 9, 9, 9, 9, 10, 10, 9, 9, 9, 9, 9, 9, 9,
                    10, 10, 10, 10, 10, 10, 10, 10, 9, 10, 10, 9, 10, 10, 10, 10, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10,
                    10, 10, 10, 9, 11, 11, 10, 10, 10, 10, 10, 11, 11, 10, 10, 10, 10, 10, 10, 10, 11, 11, 10, 10, 10,
                    10, 11, 11, 10, 10, 11, 11, 11, 11, 11, 11, 10, 11, 11, 11, 11, 11, 11, 12, 12, 11, 11, 11, 11, 11,
                    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 11, 11, 11,
                    11, 11, 11, 11, 11, 12, 12, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 11, 11, 13, 13, 12, 12, 12, 12,
                    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 12, 13, 13, 13,
                    13, 13, 13, 12, 13, 13, 13, 13, },
            new int[] { 0, 16, 1, 17, 32, 2, 33, 18, 34, 48, 49, 19, 3, 64, 50, 35, 4, 20, 65, 51, 66, 36, 67, 52, 80,
                    5, 81, 21, 82, 37, 68, 83, 97, 53, 96, 6, 22, 98, 38, 84, 69, 99, 54, 112, 7, 113, 85, 23, 100, 114,
                    39, 70, 115, 55, 101, 86, 128, 8, 116, 129, 24, 130, 40, 71, 102, 131, 56, 117, 87, 132, 72, 144,
                    25, 145, 146, 118, 103, 41, 133, 88, 9, 119, 147, 57, 148, 73, 134, 104, 160, 10, 161, 26, 162, 42,
                    149, 89, 163, 58, 135, 120, 164, 74, 150, 105, 176, 177, 27, 165, 178, 90, 43, 136, 151, 179, 121,
                    59, 106, 180, 75, 193, 152, 137, 28, 181, 91, 44, 194, 11, 192, 166, 167, 122, 195, 60, 12, 153,
                    182, 107, 196, 76, 168, 138, 197, 208, 92, 209, 183, 123, 29, 13, 45, 210, 211, 61, 198, 108, 169,
                    154, 184, 212, 139, 77, 199, 124, 213, 93, 224, 14, 225, 30, 226, 170, 46, 185, 155, 227, 214, 109,
                    62, 200, 140, 228, 78, 215, 125, 229, 186, 171, 94, 201, 156, 241, 31, 240, 110, 242, 47, 230, 216,
                    243, 63, 244, 79, 141, 217, 187, 202, 172, 231, 126, 245, 157, 95, 232, 142, 246, 203, 15, 174, 111,
                    188, 218, 173, 247, 127, 233, 158, 204, 248, 143, 219, 189, 234, 249, 159, 220, 205, 235, 190, 250,
                    175, 221, 236, 206, 251, 191, 237, 222, 252, 207, 253, 238, 223, 254, 239, 255, })
            .getVLC();

    static VLC tab16 = VLCBuilder.createVLCBuilder(
            new int[] { 1, 3, 5, 4, 15, 14, 13, 12, 23, 45, 44, 21, 20, 39, 38, 75, 74, 36, 35, 69, 68, 67, 66, 65, 64,
                    63, 62, 30, 59, 58, 115, 114, 56, 111, 110, 54, 53, 52, 103, 102, 101, 100, 99, 98, 48, 47, 93, 185,
                    184, 91, 90, 179, 178, 88, 87, 173, 172, 85, 84, 83, 165, 164, 81, 161, 160, 159, 158, 157, 156,
                    155, 154, 76, 75, 149, 148, 73, 72, 143, 142, 141, 140, 139, 138, 68, 67, 133, 265, 264, 131, 261,
                    260, 129, 257, 256, 127, 253, 252, 125, 249, 248, 247, 246, 245, 244, 243, 242, 120, 119, 118, 117,
                    233, 232, 115, 229, 228, 227, 226, 225, 224, 223, 222, 110, 219, 218, 217, 216, 107, 427, 426, 212,
                    211, 210, 209, 208, 207, 206, 102, 407, 406, 202, 201, 401, 400, 199, 397, 396, 395, 394, 393, 392,
                    195, 389, 388, 387, 386, 385, 384, 383, 382, 381, 380, 379, 378, 377, 376, 187, 747, 746, 372, 743,
                    742, 370, 369, 737, 736, 735, 734, 366, 365, 364, 727, 726, 362, 723, 722, 721, 720, 359, 358, 715,
                    714, 713, 712, 711, 710, 709, 708, 707, 706, 352, 10, 9, 17, 16, 7, 223, 445, 889, 888, 443, 885,
                    884, 883, 882, 440, 439, 877, 876, 437, 436, 871, 870, 434, 1735, 1734, 866, 865, 3459, 3458, 1728,
                    26, 12, 11, 10, 9, 17, 16, 3, 11, 10, 9, 8, 7, 13, 12, 11, 10, 4, 7, 6, 5, 4, 3, 2, 1, 0, },
            new int[] { 1, 3, 4, 4, 6, 6, 6, 6, 7, 8, 8, 7, 7, 8, 8, 9, 9, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 8, 9, 9, 10,
                    10, 9, 10, 10, 9, 9, 9, 10, 10, 10, 10, 10, 10, 9, 9, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11,
                    10, 10, 10, 11, 11, 10, 11, 11, 11, 11, 11, 11, 11, 11, 10, 10, 11, 11, 10, 10, 11, 11, 11, 11, 11,
                    11, 10, 10, 11, 12, 12, 11, 12, 12, 11, 12, 12, 11, 12, 12, 11, 12, 12, 12, 12, 12, 12, 12, 12, 11,
                    11, 11, 11, 12, 12, 11, 12, 12, 12, 12, 12, 12, 12, 12, 11, 12, 12, 12, 12, 11, 13, 13, 12, 12, 12,
                    12, 12, 12, 12, 11, 13, 13, 12, 12, 13, 13, 12, 13, 13, 13, 13, 13, 13, 12, 13, 13, 13, 13, 13, 13,
                    13, 13, 13, 13, 13, 13, 13, 13, 12, 14, 14, 13, 14, 14, 13, 13, 14, 14, 14, 14, 13, 13, 13, 14, 14,
                    13, 14, 14, 14, 14, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 13, 8, 8, 9, 9, 8, 13, 14, 15,
                    15, 14, 15, 15, 15, 15, 14, 14, 15, 15, 14, 14, 15, 15, 14, 16, 16, 15, 15, 17, 17, 16, 10, 9, 9, 9,
                    9, 10, 10, 8, 10, 10, 10, 10, 10, 11, 11, 11, 11, 10, 11, 11, 11, 11, 11, 11, 11, 11, },
            new int[] { 0, 16, 1, 17, 32, 2, 33, 18, 34, 48, 3, 49, 19, 50, 35, 64, 4, 65, 20, 51, 66, 36, 80, 67, 52,
                    5, 21, 81, 82, 37, 68, 53, 83, 96, 6, 97, 22, 98, 38, 84, 69, 99, 54, 112, 113, 23, 7, 85, 100, 114,
                    39, 70, 101, 115, 55, 86, 8, 128, 129, 24, 116, 71, 130, 40, 102, 131, 56, 117, 132, 72, 144, 145,
                    25, 9, 118, 146, 41, 133, 88, 147, 57, 160, 10, 26, 162, 103, 87, 73, 148, 119, 134, 161, 104, 149,
                    42, 89, 58, 163, 135, 120, 164, 74, 150, 105, 176, 11, 177, 27, 178, 43, 165, 90, 179, 166, 106,
                    180, 75, 12, 193, 181, 194, 44, 167, 195, 107, 196, 29, 136, 151, 59, 209, 210, 45, 211, 30, 46,
                    226, 121, 152, 192, 28, 137, 91, 60, 122, 182, 76, 153, 168, 138, 13, 197, 92, 61, 198, 108, 154,
                    139, 77, 199, 124, 213, 93, 224, 14, 227, 208, 183, 123, 169, 184, 212, 225, 170, 185, 155, 214,
                    109, 62, 200, 140, 228, 78, 215, 229, 186, 171, 156, 230, 110, 216, 141, 187, 231, 157, 232, 142,
                    203, 188, 158, 241, 31, 15, 47, 242, 189, 94, 125, 201, 202, 172, 126, 218, 173, 204, 174, 219, 220,
                    205, 190, 235, 237, 238, 217, 234, 233, 222, 221, 236, 206, 63, 240, 243, 244, 79, 245, 95, 255,
                    246, 111, 247, 127, 143, 248, 249, 159, 250, 175, 251, 191, 252, 207, 253, 223, 254, 239, })
            .getVLC();

    static VLC tab24 = VLCBuilder.createVLCBuilder(new int[] { 15, 14, 13, 12, 47, 46, 22, 21, 41, 81, 80, 39, 38, 75,
            74, 147, 146, 72, 71, 70, 69, 68, 135, 134, 66, 263, 262, 130, 129, 128, 127, 126, 125, 249, 248, 123, 122,
            121, 120, 119, 118, 117, 116, 115, 114, 113, 112, 111, 221, 220, 109, 435, 434, 216, 215, 214, 427, 426,
            212, 211, 210, 209, 208, 207, 206, 205, 204, 203, 202, 201, 200, 199, 198, 197, 196, 195, 194, 193, 192,
            191, 190, 189, 188, 187, 186, 185, 184, 183, 182, 181, 180, 179, 178, 177, 353, 352, 175, 174, 347, 346,
            345, 344, 171, 341, 340, 169, 168, 335, 669, 668, 333, 332, 331, 330, 164, 327, 653, 652, 325, 649, 648,
            323, 322, 321, 320, 319, 318, 317, 316, 315, 314, 313, 312, 311, 621, 620, 309, 308, 307, 306, 305, 304,
            303, 302, 301, 300, 299, 298, 297, 296, 295, 294, 293, 292, 291, 290, 289, 288, 287, 286, 285, 284, 283,
            282, 281, 280, 279, 278, 277, 276, 275, 274, 273, 272, 271, 541, 540, 269, 268, 267, 266, 531, 530, 264,
            263, 262, 261, 521, 520, 259, 517, 1033, 1032, 515, 514, 513, 512, 3, 383, 382, 381, 380, 379, 378, 377,
            376, 375, 374, 373, 372, 371, 370, 369, 368, 367, 366, 365, 364, 363, 362, 361, 360, 359, 358, 357, 356, 88,
            43, 42, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 17, 16, 7, 6, 11, 10, 4, 7, 6, 5, 4, 3, 2, 1, 0, },
            new int[] { 4, 4, 4, 4, 6, 6, 5, 5, 6, 7, 7, 6, 6, 7, 7, 8, 8, 7, 7, 7, 7, 7, 8, 8, 7, 9, 9, 8, 8, 8, 8, 8,
                    8, 9, 9, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 8, 10, 10, 9, 9, 9, 10, 10, 9, 9, 9, 9, 9, 9,
                    9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 9,
                    9, 10, 10, 10, 10, 9, 10, 10, 9, 9, 10, 11, 11, 10, 10, 10, 10, 9, 10, 11, 11, 10, 11, 11, 10, 10,
                    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
                    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
                    10, 10, 11, 11, 10, 10, 10, 10, 11, 11, 10, 10, 10, 10, 11, 11, 10, 11, 12, 12, 11, 11, 11, 11, 4,
                    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
                    11, 11, 11, 9, 8, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 7, 7, 8, 8, 7, 8, 8, 8, 8, 8, 8, 8,
                    8, },
            new int[] { 0, 16, 1, 17, 32, 2, 33, 18, 34, 48, 3, 49, 19, 50, 35, 64, 4, 65, 20, 51, 66, 36, 67, 52, 81,
                    80, 5, 21, 82, 37, 68, 83, 53, 96, 6, 97, 22, 98, 38, 84, 69, 99, 54, 113, 85, 100, 70, 114, 39, 55,
                    115, 112, 7, 23, 101, 86, 128, 8, 129, 116, 71, 24, 130, 40, 102, 131, 56, 117, 87, 132, 72, 145,
                    25, 146, 118, 103, 41, 133, 88, 147, 57, 148, 73, 119, 134, 104, 161, 162, 42, 149, 89, 163, 58,
                    135, 120, 74, 164, 150, 105, 177, 27, 165, 178, 90, 43, 136, 179, 144, 9, 160, 151, 121, 166, 106,
                    180, 26, 10, 176, 59, 11, 192, 75, 193, 152, 137, 28, 181, 91, 194, 44, 167, 122, 195, 60, 12, 208,
                    182, 107, 196, 76, 153, 168, 138, 197, 92, 209, 183, 123, 29, 210, 45, 211, 61, 198, 108, 169, 154,
                    212, 184, 139, 77, 199, 124, 213, 93, 225, 30, 226, 170, 185, 155, 227, 214, 109, 62, 46, 78, 200,
                    140, 228, 215, 125, 171, 229, 186, 94, 201, 156, 110, 230, 13, 224, 14, 216, 141, 187, 202, 255,
                    172, 231, 126, 217, 157, 232, 142, 203, 188, 218, 173, 233, 158, 204, 219, 189, 234, 174, 220, 205,
                    235, 190, 221, 236, 206, 237, 222, 238, 15, 240, 31, 241, 242, 47, 243, 63, 244, 79, 245, 95, 246,
                    111, 247, 127, 143, 248, 249, 159, 175, 250, 251, 191, 252, 207, 253, 223, 254, 239, })
            .getVLC();

    static VLC[] bigValVlc = new VLC[] { null, tab1, tab2, tab3, null, tab5, tab6, tab7, tab8, tab9, tab10, tab11,
            tab12, tab13, null, tab15, tab16, tab16, tab16, tab16, tab16, tab16, tab16, tab16, tab24, tab24, tab24,
            tab24, tab24, tab24, tab24, tab24 };
    static int[] bigValMaxval = new int[] { 0, 2, 3, 3, 0, 4, 4, 6, 6, 6, 8, 8, 8, 16, 0, 16, 16, 16, 16, 16, 16, 16,
            16, 16, 16, 16, 16, 16, 16, 16, 16, 16 };
    static int[] bigValEscBits = new int[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 6, 8, 10, 13,
            4, 5, 6, 7, 8, 9, 11, 13 };
    static VLC cnt1A = VLCBuilder.createVLCBuilder(new int[] { 1, 7, 6, 5, 4, 7, 6, 5, 4, 3, 5, 4, 3, 2, 1, 0, },
            new int[] { 1, 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, },
            new int[] { 0, 8, 4, 1, 2, 12, 10, 3, 6, 9, 5, 7, 14, 13, 15, 11, }).getVLC();
    static VLC cnt1B = VLCBuilder.createVLCBuilder(new int[] { 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, },
            new int[] { 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, },
            new int[] { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, }).getVLC();
}